/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ReferenceComparator;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ReferencersPanel
extends SelectableContainer {
    private static final long serialVersionUID = -3053088272109571777L;
    private SelectableTable _table;

    public ReferencersPanel(Instance instance) {
        this.createTable(instance);
        this.setSelectable(this._table);
        this.setPreferredSize(new Dimension(700, 300));
    }

    public ReferencersPanel(Project project, Instance instance) {
        this(instance);
    }

    private void addColumn(int n, TableCellRenderer tableCellRenderer) {
        this._table.addColumn(new TableColumn(this._table.getColumnCount(), n, tableCellRenderer, null));
    }

    private void createColumns() {
        this.addColumn(250, FrameRenderer.createInstance());
        this.addColumn(250, FrameRenderer.createInstance());
        DefaultRenderer defaultRenderer = new DefaultRenderer(){
            private static final long serialVersionUID = -5008610693872505393L;

            public void load(Object object) {
                Reference reference = (Reference)object;
                Facet facet = reference.getFacet();
                if (facet != null && facet.getName().equals(":VALUE-TYPE")) {
                    this.setMainIcon(Icons.getFacetIcon());
                    Cls cls = (Cls)reference.getFrame();
                    Slot slot = reference.getSlot();
                    ValueType valueType = cls.getTemplateSlotValueType(slot);
                    if (1.equals(valueType, ValueType.INSTANCE)) {
                        this.setMainText("allowed-classes");
                    } else if (1.equals(valueType, ValueType.CLS)) {
                        this.setMainText("allowed-parents");
                    }
                }
            }
        };
        this.addColumn(125, defaultRenderer);
    }

    private void createTable(Instance instance) {
        Action action = this.createViewAction();
        this._table = ComponentFactory.createSelectableTable(action);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = ComponentFactory.createScrollPane(this._table);
        String string = "References to " + instance.getName();
        LabeledComponent labeledComponent = new LabeledComponent(string, (Component)jScrollPane);
        labeledComponent.addHeaderButton(action);
        labeledComponent.addHeaderButton(new ReferencersAction(this));
        this.add(labeledComponent);
        this._table.setModel(ReferencersPanel.createTableModel(instance));
        this.createColumns();
    }

    private static TableModel createTableModel(Instance instance) {
        DefaultTableModel defaultTableModel = new DefaultTableModel(){
            private static final long serialVersionUID = -1289987049965852246L;

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        defaultTableModel.addColumn("Frame");
        defaultTableModel.addColumn("Slot");
        defaultTableModel.addColumn("Facet");
        KnowledgeBase knowledgeBase = instance.getKnowledgeBase();
        ArrayList<Reference> arrayList = new ArrayList<Reference>(knowledgeBase.getReferences(instance, 1000));
        Collections.sort(arrayList, new ReferenceComparator());
        for (Reference reference : arrayList) {
            defaultTableModel.addRow(new Object[]{reference.getFrame(), reference.getSlot(), reference});
        }
        return defaultTableModel;
    }

    private Action createViewAction() {
        return new AbstractAction("View Reference", Icons.getViewIcon()){
            private static final long serialVersionUID = -9110036539380008551L;

            public void actionPerformed(ActionEvent actionEvent) {
                for (Reference reference : ReferencersPanel.this.getSelectedReferences()) {
                    Project project = reference.getFrame().getProject();
                    if (reference.isTemplate()) {
                        project.show((Cls)reference.getFrame(), reference.getSlot());
                        continue;
                    }
                    project.show((Instance)reference.getFrame());
                }
            }
        };
    }

    public int getReferencerCount() {
        return this._table.getRowCount();
    }

    private Collection getSelectedReferences() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TableModel tableModel = this._table.getModel();
        int[] nArray = this._table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(tableModel.getValueAt(nArray[i], 2));
        }
        return arrayList;
    }
}

