/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache;

import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheResult<R>
implements Serializable {
    private static final long serialVersionUID = -8134642352504821785L;
    private R result;
    private boolean isValid;

    public CacheResult(R r, boolean bl) {
        this.result = r;
        this.isValid = bl;
    }

    public static <R> CacheResult<R> getInvalid() {
        return new CacheResult<Object>(null, false);
    }

    public R getResult() {
        return this.result;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CacheResult)) {
            return false;
        }
        CacheResult cacheResult = (CacheResult)object;
        if (cacheResult.isValid() != this.isValid) {
            return false;
        }
        if (this.result == null) {
            return cacheResult.getResult() == null;
        }
        return this.result.equals(cacheResult.getResult());
    }

    public int hashCode() {
        return this.result.hashCode() + (this.isValid ? 42 : 0);
    }

    public String toString() {
        if (this.isValid()) {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append("Valid Result ");
            if (this.getResult() == null) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(" of type ");
                stringBuffer.append(this.getResult().getClass());
                if (this.getResult() instanceof Collection) {
                    stringBuffer.append(" (size=");
                    stringBuffer.append(((Collection)this.getResult()).size());
                    stringBuffer.append(")");
                }
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return "[Invalid Result]";
    }
}

