/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheModify;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadCommittedCache<S, V, R>
implements Cache<S, V, R> {
    public static final Logger LOGGER = Log.getLogger(ReadCommittedCache.class);
    private Map<S, Map<V, CacheResult<R>>> transactedWriteCache = new HashMap<S, Map<V, CacheResult<R>>>();
    private Map<S, List<CacheModify<S, V, R>>> transactedModifications = new HashMap<S, List<CacheModify<S, V, R>>>();
    private Cache<S, V, R> delegate;

    public ReadCommittedCache(Cache<S, V, R> cache) {
        this.delegate = cache;
    }

    @Override
    public CacheResult<R> readCache(S s, V v) {
        Map<V, CacheResult<R>> map = this.transactedWriteCache.get(s);
        if (map != null && map.containsKey(v)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Cache " + this.getCacheId() + " reading from change made in transaction for session " + s);
            }
            return map.get(v);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Cache " + this.getCacheId() + " reading from cache seen by everyone  for session " + s);
        }
        return this.delegate.readCache(s, v);
    }

    @Override
    public void updateCache(S s, V v) {
        Map<V, CacheResult<R>> map = this.transactedWriteCache.get(s);
        if (map != null && map.containsKey(v)) {
            return;
        }
        this.delegate.updateCache(s, v);
    }

    @Override
    public void updateCache(S s, V v, R r) {
        Map<V, CacheResult<R>> map = this.transactedWriteCache.get(s);
        if (map != null && map.containsKey(v)) {
            return;
        }
        this.delegate.updateCache(s, v, r);
    }

    @Override
    public void modifyCache(S s, V v) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Modifying cache " + this.getCacheId() + " (read-committed) with unknown value");
        }
        if (this.delegate.getTransactionNesting(s) == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cache " + this.getCacheId() + " not in transaction for session " + s);
            }
            this.delegate.modifyCache(s, v);
            return;
        }
        this.addUpdateToTransaction(s, v, new CacheResult<Object>(null, false));
    }

    @Override
    public void modifyCache(S s, V v, R r) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Modifying cache " + this.getCacheId() + " (read-committed) with known value");
        }
        if (this.delegate.getTransactionNesting(s) == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cache " + this.getCacheId() + " not in transaction for session " + s);
            }
            this.delegate.modifyCache(s, v, r);
            return;
        }
        this.addUpdateToTransaction(s, v, new CacheResult<R>(r, true));
    }

    private void addUpdateToTransaction(S s, V v, CacheResult<R> cacheResult) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache " + this.getCacheId() + " is in transaction for session " + s);
        }
        this.transactedWriteCache.get(s).put((CacheResult<R>)v, cacheResult);
        this.transactedModifications.get(s).add(new CacheModify<S, V, R>(s, v, cacheResult));
    }

    @Override
    public void invalidate(S s) {
        this.delegate.invalidate(s);
    }

    @Override
    public boolean isInvalid() {
        return this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(S s) {
        if (this.getTransactionNesting(s) == 0) {
            this.transactedWriteCache.put(s, new HashMap());
            this.transactedModifications.put(s, new ArrayList());
        }
        this.delegate.beginTransaction(s);
    }

    @Override
    public void commitTransaction(S s) {
        this.delegate.commitTransaction(s);
        if (this.getTransactionNesting(s) == 0) {
            this.transactedWriteCache.remove(s);
            for (CacheModify<S, V, R> cacheModify : this.transactedModifications.remove(s)) {
                if (cacheModify.getNewValue().isValid()) {
                    this.delegate.modifyCache(s, cacheModify.getVar(), cacheModify.getNewValue().getResult());
                    continue;
                }
                this.delegate.modifyCache(s, cacheModify.getVar());
            }
        }
    }

    @Override
    public void rollbackTransaction(S s) {
        this.delegate.rollbackTransaction(s);
        if (this.getTransactionNesting(s) == 0) {
            this.transactedWriteCache.remove(s);
            this.transactedModifications.remove(s);
        }
    }

    @Override
    public int getTransactionNesting(S s) {
        return this.delegate.getTransactionNesting(s);
    }

    @Override
    public void flush() {
        this.transactedModifications.clear();
        this.transactedWriteCache.clear();
        this.delegate.flush();
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }
}

