/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class MultiplexingClassLoader
extends ClassLoader {
    private Collection childLoaders;

    public MultiplexingClassLoader(Collection collection) {
        this.childLoaders = new ArrayList(collection);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        Iterator iterator = this.childLoaders.iterator();
        while (iterator.hasNext() && clazz == null) {
            ClassLoader classLoader = (ClassLoader)iterator.next();
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            clazz = super.findClass(string);
        }
        return clazz;
    }

    protected URL findResource(String string) {
        URL uRL = null;
        Iterator iterator = this.childLoaders.iterator();
        while (iterator.hasNext() && uRL == null) {
            ClassLoader classLoader = (ClassLoader)iterator.next();
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            uRL = super.findResource(string);
        }
        return uRL;
    }

    protected Enumeration findResources(String string) throws IOException {
        Object object2;
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        for (Object object2 : this.childLoaders) {
            ArrayList<URL> arrayList = Collections.list(((ClassLoader)object2).getResources(string));
            linkedHashSet.addAll(arrayList);
        }
        object2 = Collections.list(super.findResources(string));
        linkedHashSet.addAll((Collection<URL>)object2);
        return Collections.enumeration(linkedHashSet);
    }
}

