/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.event.WidgetAdapter;
import edu.stanford.smi.protege.event.WidgetEvent;
import edu.stanford.smi.protege.event.WidgetListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.StandardDateFormat;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.AbstractClsWidget;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.FormWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceDisplay
extends JDesktopPane
implements Disposable {
    private static final long serialVersionUID = 4777948146986438293L;
    private Project _project;
    private JScrollPane _scrollPane;
    private Collection<ClsWidget> _currentWidgets = new ArrayList<ClsWidget>();
    private Instance _currentInstance;
    private Cls _currentAssociatedCls;
    private HeaderComponent _header;
    private JComponent _child;
    private Point _lastYellowStickyPosition = new Point();
    private Slot _templateSlotsSlot;
    private AbstractButton _hideNotesButton;
    private AbstractButton _createNoteButton;
    private AbstractButton _deleteNoteButton;
    private boolean resizeVertically;
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSuperclassAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            InstanceDisplay.this.reloadForm();
        }

        public void directSuperclassRemoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            InstanceDisplay.this.reloadForm();
        }

        public void templateSlotAdded(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (InstanceDisplay.this.shouldDisplaySlot(clsEvent.getCls(), clsEvent.getSlot())) {
                InstanceDisplay.this.reloadForm();
            }
        }

        public void templateSlotRemoved(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (InstanceDisplay.this.isDisplayingSlot(clsEvent.getCls(), clsEvent.getSlot())) {
                InstanceDisplay.this.reloadForm();
            }
        }

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            if (clsEvent.isReplacementEvent()) {
                return;
            }
            if (InstanceDisplay.this.isDisplayingSlot(clsEvent.getCls(), clsEvent.getSlot())) {
                InstanceDisplay.this.reloadForm();
            }
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            if (frameEvent.isReplacementEvent()) {
                return;
            }
            Slot slot = frameEvent.getSlot();
            if (slot.hasSuperslot(InstanceDisplay.this._templateSlotsSlot)) {
                InstanceDisplay.this.reloadForm();
            }
        }
    };
    private KnowledgeBaseListener _kbListener = new KnowledgeBaseAdapter(){

        public void frameReplaced(KnowledgeBaseEvent knowledgeBaseEvent) {
            Frame frame = knowledgeBaseEvent.getFrame();
            Frame frame2 = knowledgeBaseEvent.getNewFrame();
            if (InstanceDisplay.this._currentInstance != null && InstanceDisplay.this._currentInstance.equals(frame)) {
                InstanceDisplay.this.setInstance((Instance)frame2);
            }
            if (InstanceDisplay.this._currentAssociatedCls != null && InstanceDisplay.this._currentAssociatedCls.equals(frame)) {
                InstanceDisplay.this.setInstance(InstanceDisplay.this._currentInstance);
            }
        }
    };
    private WidgetListener _widgetListener = new WidgetAdapter(){

        public void labelChanged(WidgetEvent widgetEvent) {
            if (InstanceDisplay.this._header != null) {
                InstanceDisplay.this.loadHeader();
            }
        }
    };
    private ProjectListener _projectListener = new ProjectAdapter(){

        public void formChanged(ProjectEvent projectEvent) {
            Cls cls = projectEvent.getCls();
            if (InstanceDisplay.this.isDisplayingCls(cls)) {
                InstanceDisplay.this.reloadForm();
            }
        }
    };
    private InstanceListener _instanceListener = new InstanceListener(){

        public void directTypeAdded(InstanceEvent instanceEvent) {
            InstanceDisplay.this.onDirectTypeAdded(instanceEvent.getCls());
        }

        public void directTypeRemoved(InstanceEvent instanceEvent) {
            InstanceDisplay.this.onDirectTypeRemoved(instanceEvent.getCls());
        }
    };

    protected boolean shouldDisplaySlot(Cls cls, Slot slot) {
        return true;
    }

    protected boolean isDisplayingSlot(Cls cls, Slot slot) {
        ClsWidget clsWidget = this.getClsWidget(cls);
        return clsWidget.getSlotWidget(slot) != null;
    }

    private boolean isDisplayingCls(Cls cls) {
        return this.getClsWidget(cls) != null;
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    protected void onDirectTypeAdded(Cls cls) {
        this.reloadForm();
    }

    protected void onDirectTypeRemoved(Cls cls) {
        this.reloadForm();
    }

    public InstanceDisplay(Project project) {
        this(project, true, true);
    }

    public InstanceDisplay(Project project, boolean bl, boolean bl2) {
        this._child = new JPanel(new BorderLayout());
        if (bl) {
            this._child.add((Component)this.createHeaderComponent(), "North");
            if (!bl2) {
                this._header.setVisible(false);
            }
        }
        this._project = project;
        this._templateSlotsSlot = project.getKnowledgeBase().getSlot(":DIRECT-TEMPLATE-SLOTS");
        project.getKnowledgeBase().addKnowledgeBaseListener(this._kbListener);
        project.addProjectListener(this._projectListener);
        this._scrollPane = this.makeInstanceScrollPane();
        this._child.add((Component)this._scrollPane, "Center");
        this.add(this._child);
        if (bl) {
            this.loadHeader();
        }
    }

    @Override
    public void setBorder(Border border) {
        if (this._child != null) {
            this._child.setBorder(border);
        }
    }

    public HeaderComponent getHeaderComponent() {
        return this._header;
    }

    protected JLabel getHeaderLabel() {
        return (JLabel)this._header.getComponent();
    }

    protected JScrollPane makeInstanceScrollPane() {
        JScrollPane jScrollPane = ComponentFactory.createScrollPane();
        jScrollPane.setBorder(null);
        return jScrollPane;
    }

    protected void addRuntimeWidgets(Instance instance, Cls cls) {
        Object object2;
        Collection collection = instance.getDirectTypes();
        this._currentWidgets.clear();
        for (Object object2 : collection) {
            ClsWidget clsWidget = this.getWidget((Cls)object2, instance, cls);
            if (clsWidget == null) continue;
            object2.addClsListener(this._clsListener);
            object2.addFrameListener(this._frameListener);
            clsWidget.addWidgetListener(this._widgetListener);
            this._currentWidgets.add(clsWidget);
        }
        object2 = this.createWidgetContainer(this._currentWidgets);
        this._scrollPane.setViewportView((Component)object2);
        this.update();
    }

    protected ClsWidget getWidget(Cls cls, Instance instance, Cls cls2) {
        return this._project.createRuntimeClsWidget(cls, instance, cls2);
    }

    protected JComponent createWidgetContainer(Collection collection) {
        JComponent jComponent;
        if (collection.size() == 1) {
            FormWidget formWidget = (FormWidget)CollectionUtilities.getFirstItem(collection);
            formWidget.setResizeVertically(this.resizeVertically);
            jComponent = formWidget;
        } else {
            jComponent = this.doTabbedFormLayout() ? this.createTabbedWidgetLayout(collection) : this.createSingleFormWidgetLayout(collection);
        }
        return jComponent;
    }

    protected boolean doTabbedFormLayout() {
        return this._project.getTabbedInstanceFormLayout();
    }

    protected JComponent createTabbedWidgetLayout(Collection collection) {
        JTabbedPane jTabbedPane = ComponentFactory.createTabbedPane(false);
        for (ClsWidget clsWidget : collection) {
            jTabbedPane.addTab(clsWidget.getCls().getBrowserText(), (JComponent)((Object)clsWidget));
        }
        jTabbedPane.setBorder(ComponentUtilities.getAlignBorder());
        return jTabbedPane;
    }

    protected JComponent createSingleFormWidgetLayout(Collection collection) {
        Object object;
        JPanel jPanel2;
        Box box = Box.createVerticalBox();
        for (JPanel jPanel2 : collection) {
            ((FormWidget)jPanel2).setResizeVertically(this.resizeVertically);
            object = jPanel2;
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add(jPanel2);
            String string = "as " + ((AbstractClsWidget)jPanel2).getCls().getBrowserText();
            JLabel jLabel = ComponentFactory.createSmallFontLabel(string);
            jLabel.setPreferredSize(ComponentFactory.STANDARD_BUTTON_SIZE);
            jPanel3.setBorder(BorderFactory.createEtchedBorder());
            object = new JPanel(new BorderLayout());
            ((Container)object).add((Component)jLabel, "North");
            ((Container)object).add((Component)jPanel3, "Center");
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            box.add((Component)object);
        }
        jPanel2 = new JPanel(new BorderLayout());
        object = this.resizeVertically ? "Center" : "North";
        jPanel2.add((Component)box, object);
        return jPanel2;
    }

    private AbstractAction createCreateYellowStickiesAction() {
        return new StandardAction(ResourceKey.INSTANCE_NOTE_CREATE){
            private static final long serialVersionUID = -693378347365867392L;

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceDisplay.this.createYellowSticky();
            }
        };
    }

    private AbstractAction createDeleteYellowStickiesAction() {
        return new StandardAction(ResourceKey.INSTANCE_NOTE_DELETE){
            private static final long serialVersionUID = 4056875859826717485L;

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceDisplay.this.deleteYellowSticky();
            }
        };
    }

    private AbstractAction createHideYellowStickiesAction() {
        return new StandardAction(ResourceKey.INSTANCE_NOTE_HIDE){
            private static final long serialVersionUID = 4169231408766745704L;

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceDisplay.this.updateYellowStickiesView();
            }
        };
    }

    protected JComponent createHeaderComponent() {
        this._header = new HeaderComponent(ComponentFactory.createLabel());
        this._hideNotesButton = this._header.addToggleButton(this.createHideYellowStickiesAction());
        this._createNoteButton = this._header.addButton(this.createCreateYellowStickiesAction());
        this._deleteNoteButton = this._header.addButton(this.createDeleteYellowStickiesAction());
        return this._header;
    }

    private void createYellowSticky() {
        this.ensureYellowStickiesAreVisible();
        KnowledgeBase knowledgeBase = this._project.getKnowledgeBase();
        Instance instance = knowledgeBase.createInstance(null, knowledgeBase.getCls(":INSTANCE-ANNOTATION"));
        ModelUtilities.setOwnSlotValue(instance, ":CREATOR", this._project.getUserName());
        StandardDateFormat standardDateFormat = new StandardDateFormat();
        String string = standardDateFormat.format(new Date());
        ModelUtilities.setOwnSlotValue(instance, ":CREATION-TIMESTAMP", string);
        ModelUtilities.setOwnSlotValue(instance, ":ANNOTATED-INSTANCE", this._currentInstance);
        this.showYellowSticky(instance);
    }

    private void deleteYellowSticky() {
        Collection collection = this.getStickyInstances();
        int n = collection.size();
        if (n == 1) {
            String string = "Are you sure that you want to delete this note";
            int n2 = ModalDialog.showMessageDialog((Component)this, string, 13);
            if (n2 == 2) {
                Instance instance = (Instance)CollectionUtilities.getFirstItem(collection);
                this.removeSticky(instance);
                instance.delete();
            }
        } else if (n > 1) {
            Collection collection2 = DisplayUtilities.pickInstancesFromCollection(this, collection, "Select a note to delete");
            for (Instance instance : collection2) {
                this.removeSticky(instance);
                instance.delete();
            }
        }
    }

    private void updateYellowStickiesView() {
        boolean bl = this._hideNotesButton.isSelected();
        if (bl) {
            this.removeAllStickies();
        } else {
            this.showAllStickies();
        }
    }

    @Override
    public void dispose() {
        if (this._project == null) {
            return;
        }
        this._project.getKnowledgeBase().removeKnowledgeBaseListener(this._kbListener);
        this._project.removeProjectListener(this._projectListener);
        if (this._currentInstance != null) {
            this._currentInstance.removeInstanceListener(this._instanceListener);
        }
        for (ClsWidget clsWidget : this._currentWidgets) {
            clsWidget.removeWidgetListener(this._widgetListener);
            clsWidget.getCls().removeClsListener(this._clsListener);
            clsWidget.getCls().removeFrameListener(this._frameListener);
        }
        this._currentWidgets.clear();
        this._project = null;
    }

    private void ensureYellowStickiesAreVisible() {
    }

    @Deprecated
    public ClsWidget getCurrentClsWidget() {
        return this.getFirstClsWidget();
    }

    public ClsWidget getFirstClsWidget() {
        return CollectionUtilities.getFirstItem(this._currentWidgets);
    }

    private ClsWidget getClsWidget(Cls cls) {
        ClsWidget clsWidget = null;
        for (ClsWidget clsWidget2 : this._currentWidgets) {
            if (!clsWidget2.getCls().equals(cls)) continue;
            clsWidget = clsWidget2;
            break;
        }
        return clsWidget;
    }

    public Instance getCurrentInstance() {
        return this._currentInstance;
    }

    public void setResizeVertically(boolean bl) {
        this.resizeVertically = bl;
        this.reloadForm();
    }

    private Point getNextYellowStickyPosition() {
        int n = 25;
        int n2 = 100;
        this._lastYellowStickyPosition.x += n;
        this._lastYellowStickyPosition.x %= n2;
        this._lastYellowStickyPosition.y += n;
        this._lastYellowStickyPosition.y %= n2;
        return this._lastYellowStickyPosition;
    }

    @Override
    public Dimension getPreferredSize() {
        return this._child.getPreferredSize();
    }

    private Collection getStickyInstances() {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        if (this._currentInstance != null) {
            KnowledgeBase knowledgeBase = this._project.getKnowledgeBase();
            Slot slot = knowledgeBase.getSlot(":ANNOTATED-INSTANCE");
            for (Instance instance : knowledgeBase.getCls(":INSTANCE-ANNOTATION").getInstances()) {
                Instance instance2 = (Instance)instance.getOwnSlotValue(slot);
                if (!InstanceDisplay.equals(instance2, this._currentInstance)) continue;
                arrayList.add(instance);
            }
        }
        return arrayList;
    }

    private Map<Instance, Rectangle> getYellowStickyMap() {
        String string = "InstanceDisplay.yellow_stickies";
        HashMap hashMap = (HashMap)this._project.getClientInformation(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this._project.setClientInformation(string, hashMap);
        }
        return hashMap;
    }

    protected void loadHeader() {
        if (this._currentInstance instanceof Cls) {
            this.loadHeaderWithCls((Cls)this._currentInstance);
        } else if (this._currentInstance instanceof Slot) {
            this.loadHeaderWithSlot((Slot)this._currentInstance);
        } else {
            this.loadHeaderWithSimpleInstance(this._currentInstance);
        }
    }

    protected void loadHeaderWithCls(Cls cls) {
        this.loadHeaderLabel(cls);
        this._header.setColor(Colors.getClsColor());
        this._header.setTitle(LocalizedText.getText(ResourceKey.CLASS_EDITOR_TITLE));
        this._header.setComponentLabel(LocalizedText.getText(ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL));
        InstanceDisplay.setResource(this._hideNotesButton, ResourceKey.CLASS_NOTE_HIDE_ALL);
        InstanceDisplay.setResource(this._createNoteButton, ResourceKey.CLASS_NOTE_CREATE);
        InstanceDisplay.setResource(this._deleteNoteButton, ResourceKey.CLASS_NOTE_DELETE);
    }

    private static void setResource(AbstractButton abstractButton, ResourceKey resourceKey) {
        abstractButton.setIcon(Icons.getIcon(resourceKey));
        abstractButton.setToolTipText(LocalizedText.getText(resourceKey));
    }

    protected void loadHeaderWithSlot(Slot slot) {
        this.loadHeaderLabel(slot);
        this._header.setColor(Colors.getSlotColor());
        this._header.setTitle(LocalizedText.getText(ResourceKey.SLOT_EDITOR_TITLE));
        this._header.setComponentLabel(LocalizedText.getText(ResourceKey.SLOT_EDITOR_FOR_SLOT_LABEL));
        InstanceDisplay.setResource(this._hideNotesButton, ResourceKey.SLOT_NOTE_HIDE);
        InstanceDisplay.setResource(this._createNoteButton, ResourceKey.SLOT_NOTE_CREATE);
        InstanceDisplay.setResource(this._deleteNoteButton, ResourceKey.SLOT_NOTE_DELETE);
    }

    protected void loadHeaderLabel(Instance instance) {
        JLabel jLabel = this.getHeaderLabel();
        if (instance != null) {
            jLabel.setIcon(instance.getIcon());
            String string = instance.getBrowserText();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("     ");
            String string2 = this.getTypeText(instance);
            String string3 = instance.getName();
            String string4 = string3.equals(string) ? LocalizedText.getText(ResourceKey.FRAME_EDITOR_FRAME_TYPE, string2) : LocalizedText.getText(ResourceKey.FRAME_EDITOR_FRAME_TYPE_AND_NAME, string2, string3);
            stringBuffer.append(string4);
            jLabel.setText(stringBuffer.toString());
        } else {
            jLabel.setIcon(null);
            jLabel.setText("");
        }
    }

    protected String getTypeText(Instance instance) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = instance.getDirectTypes().iterator();
        while (iterator.hasNext()) {
            Cls cls = (Cls)iterator.next();
            stringBuffer.append(cls.getBrowserText());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    protected void loadHeaderWithSimpleInstance(Instance instance) {
        this.loadHeaderLabel(instance);
        this._header.setColor(Colors.getInstanceColor());
        this._header.setTitle(LocalizedText.getText(ResourceKey.INSTANCE_EDITOR_TITLE));
        this._header.setComponentLabel(LocalizedText.getText(ResourceKey.INSTANCE_EDITOR_FOR_INSTANCE_LABEL));
        InstanceDisplay.setResource(this._hideNotesButton, ResourceKey.INSTANCE_NOTE_HIDE);
        InstanceDisplay.setResource(this._createNoteButton, ResourceKey.INSTANCE_NOTE_CREATE);
        InstanceDisplay.setResource(this._deleteNoteButton, ResourceKey.INSTANCE_NOTE_DELETE);
    }

    private JInternalFrame loadIntoFrame(final Instance instance) {
        JInternalFrame jInternalFrame = this._project.showInInternalFrame(instance);
        Map<Instance, Rectangle> map = this.getYellowStickyMap();
        Rectangle rectangle = map.get(instance);
        if (rectangle == null) {
            jInternalFrame.setLocation(this.getNextYellowStickyPosition());
            map.put(instance, jInternalFrame.getBounds());
        } else {
            jInternalFrame.setBounds(rectangle);
        }
        jInternalFrame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                InstanceDisplay.this.getYellowStickyMap().put(instance, componentEvent.getComponent().getBounds());
            }

            public void componentMoved(ComponentEvent componentEvent) {
                InstanceDisplay.this.getYellowStickyMap().put(instance, componentEvent.getComponent().getBounds());
            }
        });
        jInternalFrame.setFrameIcon(this.getNoteIcon());
        return jInternalFrame;
    }

    private Icon getNoteIcon() {
        Icon icon = this._currentInstance instanceof Cls ? Icons.getIcon(ResourceKey.CLASS_NOTE) : (this._currentInstance instanceof Slot ? Icons.getIcon(ResourceKey.SLOT_NOTE) : Icons.getIcon(ResourceKey.INSTANCE_NOTE));
        return icon;
    }

    private void reloadForm() {
        Instance instance = this._currentInstance;
        Cls cls = this._currentAssociatedCls;
        this.removeCurrentWidgets();
        this.setInstance(instance, cls);
    }

    private void removeAllStickies() {
        for (Component component : new ArrayList<Component>(Arrays.asList(this.getComponents()))) {
            if (!(component instanceof JInternalFrame)) continue;
            JInternalFrame jInternalFrame = (JInternalFrame)component;
            jInternalFrame.setVisible(false);
            jInternalFrame.dispose();
            this.remove(jInternalFrame);
        }
    }

    protected void removeCurrentWidgets() {
        for (ClsWidget clsWidget : this._currentWidgets) {
            clsWidget.getCls().removeClsListener(this._clsListener);
            clsWidget.getCls().removeFrameListener(this._frameListener);
            clsWidget.removeWidgetListener(this._widgetListener);
        }
        Component component = this._scrollPane.getViewport().getView();
        this._scrollPane.setViewportView(null);
        ComponentUtilities.dispose(component);
        this._currentWidgets.clear();
        if (this._currentInstance != null) {
            this._currentInstance.removeInstanceListener(this._instanceListener);
        }
        this._currentInstance = null;
        this._currentAssociatedCls = null;
        this.update();
    }

    private void removeSticky(Instance instance) {
        for (Component component : new ArrayList<Component>(Arrays.asList(this.getComponents()))) {
            JInternalFrame jInternalFrame;
            InstanceDisplay instanceDisplay;
            if (!(component instanceof JInternalFrame) || !InstanceDisplay.equals((instanceDisplay = (InstanceDisplay)(jInternalFrame = (JInternalFrame)component).getContentPane().getComponent(0)).getCurrentInstance(), instance)) continue;
            jInternalFrame.setVisible(false);
            jInternalFrame.dispose();
            this.remove(jInternalFrame);
            break;
        }
    }

    @Override
    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this._child.setBounds(0, 0, n3, n4);
    }

    public void setInstance(Instance instance) {
        this.setInstance(instance, null);
    }

    public void setInstance(Instance instance, Cls cls) {
        if (this._currentInstance != null) {
            this._currentInstance.removeInstanceListener(this._instanceListener);
        }
        if (instance == null) {
            this.removeCurrentWidgets();
        } else {
            if (this._currentWidgets.isEmpty()) {
                this.addRuntimeWidgets(instance, cls);
            } else if (this.typesMatchCurrentWidgets(instance)) {
                for (ClsWidget clsWidget : this._currentWidgets) {
                    clsWidget.setInstance(instance);
                    clsWidget.setAssociatedCls(cls);
                }
            } else {
                this.removeCurrentWidgets();
                this.addRuntimeWidgets(instance, cls);
            }
            instance.addInstanceListener(this._instanceListener);
        }
        this._currentInstance = instance;
        this._currentAssociatedCls = cls;
        if (this._header != null) {
            this.loadHeader();
        }
        this.updateStickies();
    }

    private boolean typesMatchCurrentWidgets(Instance instance) {
        boolean bl = false;
        HashSet hashSet = new HashSet(instance.getDirectTypes());
        if (hashSet.size() == this._currentWidgets.size()) {
            bl = true;
            for (ClsWidget clsWidget : this._currentWidgets) {
                if (hashSet.contains(clsWidget.getCls())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void showAllStickies() {
        if (this._currentInstance != null) {
            for (Instance instance : this.getStickyInstances()) {
                this.showYellowSticky(instance);
            }
        }
    }

    private void showYellowSticky(Instance instance) {
        JInternalFrame jInternalFrame = this.loadIntoFrame(instance);
        String string = (String)ModelUtilities.getDirectOwnSlotValue(instance, ":CREATOR");
        if (string == null || string.length() == 0) {
            string = "<unknown author>";
        }
        String string2 = InstanceDisplay.getTimeString(instance);
        String string3 = string;
        if (string2 != null) {
            string3 = string3 + ", " + string2;
        }
        jInternalFrame.setTitle(string3);
        jInternalFrame.setVisible(true);
        this.add(jInternalFrame);
        jInternalFrame.toFront();
        try {
            jInternalFrame.setSelected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getTimeString(Instance instance) {
        String string = null;
        String string2 = (String)ModelUtilities.getDirectOwnSlotValue(instance, ":CREATION-TIMESTAMP");
        if (string2 != null) {
            StandardDateFormat standardDateFormat = new StandardDateFormat();
            try {
                Date date = ((DateFormat)standardDateFormat).parse(string2);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                int n = gregorianCalendar.get(1);
                gregorianCalendar.setTime(date);
                int n2 = gregorianCalendar.get(1);
                String string3 = "MMM dd " + (n == n2 ? "" : "yyyy ") + "HH:mm";
                standardDateFormat.applyPattern(string3);
                string = standardDateFormat.format(date);
            }
            catch (ParseException parseException) {
                Log.getLogger().warning(parseException.toString());
                string = string2;
            }
        }
        return string;
    }

    private void update() {
        this.revalidate();
        this.repaint();
    }

    private void updateStickies() {
        this.removeAllStickies();
        if (this._hideNotesButton != null && !this._hideNotesButton.isSelected()) {
            this.showAllStickies();
        }
    }
}

