/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.FormDisplay;
import edu.stanford.smi.protege.ui.FormsPanel;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTree;

public class FormsTab
extends AbstractTabWidget {
    private static final long serialVersionUID = -6911540492963136661L;
    private FormsPanel _formsPanel;
    private FormDisplay _formDisplay;

    private JComponent createFormDisplay() {
        this._formDisplay = new FormDisplay(this.getProject());
        return this._formDisplay;
    }

    private JComponent createFormsWidget() {
        this._formsPanel = new FormsPanel(this.getProject());
        this._formsPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                FormsTab.this.transmitSelection();
            }
        });
        return this._formsPanel;
    }

    private JComponent createMainSplitter() {
        JSplitPane jSplitPane = this.createLeftRightSplitPane("FormsTab.left_right", 250);
        jSplitPane.setLeftComponent(this.createFormsWidget());
        jSplitPane.setRightComponent(this.createFormDisplay());
        return jSplitPane;
    }

    public void initialize() {
        this.setIcon(Icons.getFormIcon());
        this.setLabel(LocalizedText.getText(ResourceKey.FORMS_VIEW_TITLE));
        this.add(this.createMainSplitter());
        this.transmitSelection();
        this.setClsTree(this._formsPanel.getFormsTree());
    }

    public LabeledComponent getLabeledComponent() {
        return this._formsPanel.getLabeledComponent();
    }

    public void setSelectedCls(Cls cls) {
        JTree jTree = this._formsPanel.getFormsTree();
        List<Cls> list = ModelUtilities.getPathToRoot(cls);
        ComponentUtilities.setSelectedObjectPath(jTree, list);
    }

    private void transmitSelection() {
        Collection collection = this._formsPanel.getSelection();
        if (collection.size() == 1) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
            this._formDisplay.setWidgetCls(cls);
        } else {
            this._formDisplay.setWidgetCls(null);
        }
    }

    public static boolean isSuitable(Project project, Collection collection) {
        if (project.isMultiUserClient()) {
            collection.add("Forms don't work in multi-user client mode");
            return false;
        }
        return true;
    }
}

