/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.ArchiveManager;
import edu.stanford.smi.protege.util.ArchiveRecord;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ConfigureArchivePanel
extends JPanel {
    private Project _currentProject;

    public ConfigureArchivePanel(Project project) {
        super(new BorderLayout());
        this._currentProject = project;
        this.add((Component)this.createExistingArchiveVersionsPanel(), "Center");
        this.add((Component)ConfigureArchivePanel.createOptionsPanel(), "South");
    }

    private static JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(ConfigureArchivePanel.createAutoArchivePanel());
        jPanel.add(ConfigureArchivePanel.createNumberOfArchivedVersionsPanel());
        return jPanel;
    }

    private static JComponent createAutoArchivePanel() {
        return new JCheckBox("Automatically archive the current version on Save");
    }

    private static JComponent createNumberOfArchivedVersionsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(ComponentFactory.createLabel("Maximum number of archived versions"));
        jPanel.add(new JTextField(5));
        return jPanel;
    }

    private JComponent createExistingArchiveVersionsPanel() {
        JTable jTable = new JTable();
        jTable.setModel(this.createTableModel());
        LabeledComponent labeledComponent = new LabeledComponent("Archived Versions", ComponentFactory.createScrollPane(jTable));
        labeledComponent.addHeaderButton(ConfigureArchivePanel.createDeleteVersionButton());
        return labeledComponent;
    }

    private static Action createDeleteVersionButton() {
        return new AbstractAction("Delete Selected Version", Icons.getDeleteIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                Log.getLogger().info("delete selected version");
            }
        };
    }

    private TableModel createTableModel() {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Date and Time");
        defaultTableModel.addColumn("Comment");
        for (ArchiveRecord archiveRecord : ArchiveManager.getArchiveManager().getArchiveRecords(this._currentProject)) {
            Date date = archiveRecord.getTimestamp();
            String string = archiveRecord.getComment();
            defaultTableModel.addRow(new Object[]{date, string});
        }
        return defaultTableModel;
    }
}

