/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.JavaCodeGeneratorAction;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.plugin.ProjectPluginAdapter;
import edu.stanford.smi.protege.ui.ProjectMenuBar;
import edu.stanford.smi.protege.ui.ProjectToolBar;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class CodeGeneratorProjectPlugin
extends ProjectPluginAdapter {
    public static final String CODE_MENU = "Code";

    public void afterShow(ProjectView projectView, ProjectToolBar projectToolBar, ProjectMenuBar projectMenuBar) {
        KnowledgeBase knowledgeBase = projectView.getProject().getKnowledgeBase();
        if (knowledgeBase.getKnowledgeBaseFactory().getClass().getName().contains(".owl.")) {
            return;
        }
        this.insertCodeMenu(knowledgeBase, projectMenuBar);
    }

    private void insertCodeMenu(KnowledgeBase knowledgeBase, ProjectMenuBar projectMenuBar) {
        JMenu jMenu = ComponentUtilities.getMenu(projectMenuBar, CODE_MENU, true, projectMenuBar.getComponentCount() - 2);
        JMenuItem jMenuItem = ComponentFactory.createMenuItem("Generate Java Code...");
        jMenuItem.addActionListener(new JavaCodeGeneratorAction(knowledgeBase));
        jMenu.add(jMenuItem);
    }

    public void beforeHide(ProjectView projectView, ProjectToolBar projectToolBar, ProjectMenuBar projectMenuBar) {
        JMenu jMenu = ComponentUtilities.getMenu(projectMenuBar, CODE_MENU);
        if (jMenu == null) {
            return;
        }
        ComponentUtilities.removeMenuItem(jMenu, "Generate Java Code...");
    }
}

