/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.KnowledgeBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transaction<X> {
    public static final String APPLY_TO_TRAILER_STRING = " -- Apply to: ";
    private KnowledgeBase _knowledgeBase;
    private String applyTo;
    private String transactionName = "transaction";

    protected Transaction(KnowledgeBase knowledgeBase) {
        this._knowledgeBase = knowledgeBase;
    }

    protected Transaction(KnowledgeBase knowledgeBase, String string) {
        this._knowledgeBase = knowledgeBase;
        this.transactionName = string;
    }

    protected Transaction(KnowledgeBase knowledgeBase, String string, String string2) {
        this._knowledgeBase = knowledgeBase;
        this.transactionName = string;
        this.applyTo = string2;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._knowledgeBase;
    }

    public abstract boolean doOperations();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        boolean bl = false;
        KnowledgeBase knowledgeBase = this._knowledgeBase;
        synchronized (knowledgeBase) {
            boolean bl2 = false;
            try {
                this._knowledgeBase.beginTransaction(this.transactionName, this.applyTo);
                boolean bl3 = this.doOperations();
                if (bl3) {
                    bl = this._knowledgeBase.commitTransaction();
                } else {
                    this._knowledgeBase.rollbackTransaction();
                    bl = false;
                }
                bl2 = true;
            }
            finally {
                if (!bl2) {
                    this._knowledgeBase.rollbackTransaction();
                }
            }
        }
        return bl;
    }

    public X getResult() {
        return null;
    }

    public static String getApplyTo(String string) {
        int n = string.indexOf(APPLY_TO_TRAILER_STRING);
        if (n < 0) {
            return null;
        }
        return string.substring(n += APPLY_TO_TRAILER_STRING.length());
    }
}

