/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ServerProjectPanel
extends JPanel {
    private RemoteServer _server;
    private RemoteSession _session;
    private JTable _projectTable;
    private String _lastOpenedPrj = "";
    public static final String SERVER_LAST_OPENED_PROJECT_PROP = "server.last.opened.project";

    public ServerProjectPanel(RemoteServer remoteServer, RemoteSession remoteSession) {
        this._server = remoteServer;
        this._session = remoteSession;
        this._projectTable = ComponentFactory.createTable(null);
        this._lastOpenedPrj = ApplicationProperties.getString(SERVER_LAST_OPENED_PROJECT_PROP, "");
        this.setLayout(new BorderLayout());
        this.add(ComponentFactory.createScrollPane(this._projectTable));
        this.loadTable();
        this.setMinimumSize(new Dimension(400, 300));
    }

    private void loadTable() {
        try {
            Collection<String> collection = this._server.getAvailableProjectNames(this._session);
            Iterator<String> iterator = collection.iterator();
            Object[][] objectArray = new Object[collection.size()][2];
            int n = 0;
            for (int i = 0; i < collection.size(); ++i) {
                String string = iterator.next();
                if (string.equals(this._lastOpenedPrj)) {
                    n = i;
                }
                objectArray[i][0] = string;
                objectArray[i][1] = ServerProjectPanel.sessionsToString(this._server.getCurrentSessions(string, this._session));
            }
            Object[] objectArray2 = new Object[]{"Project", "Current Users"};
            this._projectTable.setModel(new DefaultTableModel(objectArray, objectArray2));
            this._projectTable.createDefaultColumnsFromModel();
            if (collection.size() > 0) {
                this._projectTable.setRowSelectionInterval(n, n);
            }
        }
        catch (RemoteException remoteException) {
            Log.getLogger().severe(Log.toString(remoteException));
        }
    }

    private static String sessionsToString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Session session : collection) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(session.getUserName() + " (" + session.getUserIpAddress() + ")");
        }
        return stringBuffer.toString();
    }

    public String getProjectName() {
        String string;
        int n = this._projectTable.getSelectedRow();
        if (n < 0) {
            string = null;
        } else {
            string = (String)this._projectTable.getValueAt(n, 0);
            ApplicationProperties.setString(SERVER_LAST_OPENED_PROJECT_PROP, string);
        }
        return string;
    }
}

