/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.socket.CompressionAspect;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import edu.stanford.smi.protege.server.socket.SocketWithAspects;
import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

public class RmiSocketFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory,
Serializable {
    private static final long serialVersionUID = -2237049150168090129L;
    public static final String SERVER_PORT = "protege.rmi.server.port";
    public static final String SERVER_SSL_PORT = "protege.rmi.server.ssl.port";
    public static final String REGISTRY_PORT = "protege.rmi.registry.port";
    private boolean useSSL = false;
    private boolean useCompression = CompressionAspect.useCompression();
    private static boolean portsReported = false;

    public RmiSocketFactory(SSLFactory.Context context) {
        this.useSSL = SSLFactory.useSSL(context);
        this.reportPorts();
    }

    public Socket createSocket(String string, int n) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(0);
        SocketWithAspects socketWithAspects = new SocketWithAspects(this.useCompression);
        socketWithAspects.setReuseAddress(true);
        socketWithAspects.bind(inetSocketAddress2);
        socketWithAspects.connect(inetSocketAddress);
        return socketWithAspects;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        return new ServerSocket(n){

            public Socket accept() throws IOException {
                SocketWithAspects socketWithAspects = new SocketWithAspects(RmiSocketFactory.this.useCompression);
                this.implAccept(socketWithAspects);
                return socketWithAspects;
            }
        };
    }

    public boolean equals(Object object) {
        if (!(object instanceof RmiSocketFactory)) {
            return false;
        }
        RmiSocketFactory rmiSocketFactory = (RmiSocketFactory)object;
        return this.useSSL == rmiSocketFactory.useSSL && this.useCompression == rmiSocketFactory.useCompression;
    }

    public int hashCode() {
        return (this.useSSL ? 1 : 0) + (this.useCompression ? 2 : 0);
    }

    private void reportPorts() {
        if (!portsReported) {
            int n = RmiSocketFactory.getPort(SERVER_PORT, 0);
            int n2 = RmiSocketFactory.getPort(REGISTRY_PORT, 1099);
            StringBuffer stringBuffer = new StringBuffer("Server port = ");
            stringBuffer.append(n);
            stringBuffer.append(", registry port = ");
            stringBuffer.append(n2);
            if (this.useCompression) {
                stringBuffer.append(", compressed stream");
            }
            if (this.useSSL) {
                stringBuffer.append(", SSL");
            }
            Log.getLogger().config(stringBuffer.toString());
            portsReported = true;
        }
    }

    private static int getPort(String string, int n) {
        Integer n2 = Integer.getInteger(string);
        return n2 == null ? n : n2;
    }
}

