/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.storage.clips.ClipsFileWriter;
import edu.stanford.smi.protege.storage.clips.ClipsUtil;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClsStorer
extends ClipsFileWriter {
    private static Map _typeStrings = new HashMap();
    private Collection _storedClses = new HashSet();
    private KnowledgeBase _kb;
    private Collection _errors;

    public ClsStorer(Writer writer) {
        super(writer);
    }

    protected static boolean isStorable(Cls cls) {
        return cls == null || !cls.isSystem() && !cls.isIncluded();
    }

    private void storeAccessorFacet() {
        this.println();
        this.print("\t\t(create-accessor read-write)");
    }

    private static ValueType getTemplateSlotValueType(Cls cls, Slot slot) {
        return cls == null ? slot.getValueType() : cls.getTemplateSlotValueType(slot);
    }

    private static Collection getTemplateSlotAllowedClses(Cls cls, Slot slot) {
        return cls == null ? slot.getAllowedClses() : cls.getTemplateSlotAllowedClses(slot);
    }

    private static Collection getTemplateSlotAllowedParents(Cls cls, Slot slot) {
        return cls == null ? slot.getAllowedParents() : cls.getTemplateSlotAllowedParents(slot);
    }

    private static Collection getTemplateSlotAllowedValues(Cls cls, Slot slot) {
        return cls == null ? slot.getAllowedValues() : cls.getTemplateSlotAllowedValues(slot);
    }

    private static Collection getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return cls == null ? Collections.EMPTY_LIST : cls.getDirectTemplateFacetValues(slot, facet);
    }

    private static Collection getTemplateFacets(Cls cls, Slot slot) {
        return cls == null ? Collections.EMPTY_LIST : cls.getTemplateFacets(slot);
    }

    private static boolean getTemplateSlotAllowsMultipleValues(Cls cls, Slot slot) {
        return cls == null ? slot.getAllowsMultipleValues() : cls.getTemplateSlotAllowsMultipleValues(slot);
    }

    private static Collection getTemplateSlotDefaultValues(Cls cls, Slot slot) {
        return cls == null ? slot.getDefaultValues() : cls.getTemplateSlotDefaultValues(slot);
    }

    private static Collection getTemplateSlotDocumentation(Cls cls, Slot slot) {
        return cls == null ? slot.getDocumentation() : cls.getTemplateSlotDocumentation(slot);
    }

    private static int getTemplateSlotMaximumCardinality(Cls cls, Slot slot) {
        return cls == null ? slot.getMaximumCardinality() : cls.getTemplateSlotMaximumCardinality(slot);
    }

    private static int getTemplateSlotMinimumCardinality(Cls cls, Slot slot) {
        return cls == null ? slot.getMinimumCardinality() : cls.getTemplateSlotMinimumCardinality(slot);
    }

    private static Number getTemplateSlotMaximumValue(Cls cls, Slot slot) {
        return cls == null ? (Number)slot.getMaximumValue() : (Number)cls.getTemplateSlotMaximumValue(slot);
    }

    private static Number getTemplateSlotMinimumValue(Cls cls, Slot slot) {
        return cls == null ? (Number)slot.getMinimumValue() : (Number)cls.getTemplateSlotMinimumValue(slot);
    }

    private static Collection getDirectSubclasses(Cls cls) {
        return cls == null ? Collections.EMPTY_LIST : cls.getDirectSubclasses();
    }

    private Collection<Cls> getDirectSuperclasses(Cls cls) {
        return cls == null ? this._kb.getRootClses() : cls.getDirectSuperclasses();
    }

    private static Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return cls == null ? slot.getValues() : cls.getTemplateSlotValues(slot);
    }

    private static boolean isAbstract(Cls cls) {
        return cls == null ? true : cls.isAbstract();
    }

    private static boolean hasDirectlyOverriddenTemplateFacet(Cls cls, Slot slot, Facet facet) {
        return cls == null ? false : cls.hasDirectlyOverriddenTemplateFacet(slot, facet);
    }

    private Cls getRootCls() {
        return this._kb.getRootCls();
    }

    private static String getComment(Cls cls) {
        return cls == null ? "Fake class to save top-level slot information" : (String)CollectionUtilities.getFirstItem(cls.getDocumentation());
    }

    private void storeAllowedClsesFacet(Cls cls, Slot slot) {
        ValueType valueType = ClsStorer.getTemplateSlotValueType(cls, slot);
        if (valueType == ValueType.INSTANCE) {
            Collection collection = ClsStorer.getTemplateSlotAllowedClses(cls, slot);
            this.storeCollectionFacet("allowed-classes", collection, true, ValueType.CLS, true);
        }
    }

    private void storeAllowedParentsFacet(Cls cls, Slot slot) {
        ValueType valueType = ClsStorer.getTemplateSlotValueType(cls, slot);
        if (valueType == ValueType.CLS) {
            Collection collection = ClsStorer.getTemplateSlotAllowedParents(cls, slot);
            this.storeCollectionFacet("allowed-parents", collection, true, valueType, true);
        }
    }

    private void storeAllowedValuesFacet(Cls cls, Slot slot) {
        ValueType valueType = ClsStorer.getTemplateSlotValueType(cls, slot);
        Collection<Boolean> collection = null;
        if (valueType == ValueType.BOOLEAN) {
            collection = new ArrayList<Boolean>();
            collection.add(Boolean.FALSE);
            collection.add(Boolean.TRUE);
        } else if (valueType == ValueType.SYMBOL) {
            collection = ClsStorer.getTemplateSlotAllowedValues(cls, slot);
        }
        this.storeCollectionFacet("allowed-values", collection, false, valueType, false);
    }

    private void storeAssociatedFacet(Slot slot) {
        Facet facet = slot.getAssociatedFacet();
        if (facet != null) {
            this.println();
            this.print(";+\t\t(associated-facet ");
            this.printFrame(facet);
            this.print(")");
        }
    }

    private void storeCardinalityFacet(Cls cls, Slot slot, boolean bl) {
        int n = ClsStorer.getTemplateSlotMinimumCardinality(cls, slot);
        int n2 = ClsStorer.getTemplateSlotMaximumCardinality(cls, slot);
        if (n != 0 || n2 != -1) {
            this.println();
            if (!bl) {
                this.print(";+");
            }
            this.print("\t\t(cardinality ");
            this.print(n);
            this.print(" ");
            if (n2 == -1) {
                this.print("?VARIABLE");
            } else {
                this.print(n2);
            }
            this.print(")");
        }
    }

    private void storeCls(Cls cls) {
        try {
            if (ClsStorer.isStorable(cls)) {
                this.printCls(cls);
            }
        }
        catch (Exception exception) {
            String string = "Errors at storing class " + cls;
            Log.getLogger().log(Level.WARNING, string, exception);
            this._errors.add(new MessageError(exception, string));
        }
    }

    private void printCls(Cls cls) {
        this.println();
        this.println();
        this.print("(defclass ");
        this.storeFrameName(cls);
        this.storeComment(cls);
        this.storeSuperclasses(cls);
        this.storeRole(cls);
        this.storeSlots(cls);
        this.print(")");
    }

    private void storeFrameName(Cls cls) {
        if (cls == null) {
            this.printFrameName(":CLIPS_TOP_LEVEL_SLOT_CLASS");
        } else {
            this.printFrame(cls);
        }
    }

    private void storeClsAndSubclasses(Cls cls) {
        this._storedClses.add(cls);
        this.storeCls(cls);
        this.storeSubclasses(cls);
    }

    public void storeClses(KnowledgeBase knowledgeBase, Collection collection) {
        this._kb = knowledgeBase;
        this._errors = collection;
        this.storeTopLevelSlots(knowledgeBase);
        Cls cls = knowledgeBase.getRootCls();
        this._storedClses.add(cls);
        this.storeSubclasses(cls);
        this.flush();
        if (!this.printSucceeded()) {
            collection.add(new MessageError("Store classes failed."));
            Log.getLogger().warning("Store classes failed.");
        }
        this._kb = null;
    }

    private void storeCollectionFacet(String string, Collection collection, boolean bl, ValueType valueType, boolean bl2) {
        if (collection != null && (bl2 || !collection.isEmpty())) {
            this.println();
            if (bl) {
                this.print(";+");
            }
            this.print("\t\t(");
            this.print(string);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.print(" ");
                Object e = iterator.next();
                if (e == null) {
                    Log.getLogger().warning("ignoring null facet value");
                    continue;
                }
                String string2 = e instanceof Cls || e instanceof Slot || e instanceof Facet ? ClsStorer.toExternalFrameName((Frame)e) : (e instanceof Instance ? "[" + ClsStorer.toExternalFrameName((Frame)e) + "]" : (e instanceof Boolean ? ((Boolean)e != false ? "TRUE" : "FALSE") : (valueType == ValueType.STRING ? ClipsUtil.toExternalString((String)e) : ClipsUtil.toExternalSymbol(e.toString()))));
                this.print(string2);
            }
            this.print(")");
        }
    }

    private void storeComment(Cls cls) {
        String string = ClsStorer.getComment(cls);
        if (string != null) {
            this.print(" ");
            this.print(ClipsUtil.toExternalString(string));
        }
    }

    private void storeDefaultValueFacet(Cls cls, Slot slot) {
        ValueType valueType = ClsStorer.getTemplateSlotValueType(cls, slot);
        this.storeCollectionFacet("default", ClsStorer.getTemplateSlotDefaultValues(cls, slot), false, valueType, false);
    }

    private void storeInverseProperty(Slot slot) {
        Slot slot2 = slot.getInverseSlot();
        if (slot2 != null) {
            this.println();
            this.print(";+\t\t(inverse-slot ");
            this.printFrame(slot2);
            this.print(")");
        }
    }

    private void storeRangeFacet(Cls cls, Slot slot) {
        ValueType valueType = ClsStorer.getTemplateSlotValueType(cls, slot);
        if (valueType == ValueType.INTEGER || valueType == ValueType.FLOAT) {
            Number number = ClsStorer.getTemplateSlotMinimumValue(cls, slot);
            Number number2 = ClsStorer.getTemplateSlotMaximumValue(cls, slot);
            if (number != null || number2 != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (valueType == ValueType.INTEGER) {
                    number = number == null ? (Number)null : (Number)new Integer(number.intValue());
                    number2 = number2 == null ? (Number)null : (Number)new Integer(number2.intValue());
                }
                arrayList.add(number == null ? "?VARIABLE" : number.toString());
                arrayList.add(number2 == null ? "?VARIABLE" : number2.toString());
                this.storeCollectionFacet("range", arrayList, false, valueType, false);
            }
        }
    }

    private void storeRole(Cls cls) {
        this.println();
        this.print("\t(role ");
        String string = ClsStorer.isAbstract(cls) ? "abstract" : "concrete";
        this.print(string);
        this.print(")");
    }

    private void storeSlot(Cls cls, Slot slot) {
        try {
            this.println();
            boolean bl = ClsStorer.getTemplateSlotAllowsMultipleValues(cls, slot);
            if (bl) {
                this.print("\t(multislot ");
            } else {
                this.print("\t(single-slot ");
            }
            String string = slot.getName();
            if (string.equals("name")) {
                this.print("name_");
            } else if (string.equals("is-a")) {
                this.print("is-a_");
            } else {
                this.printFrame(slot);
            }
            this.storeSlotDocumentation(cls, slot);
            this.storeTypeFacet(cls, slot);
            this.storeAllowedValuesFacet(cls, slot);
            this.storeAllowedParentsFacet(cls, slot);
            this.storeAllowedClsesFacet(cls, slot);
            this.storeRangeFacet(cls, slot);
            this.storeDefaultValueFacet(cls, slot);
            this.storeValueFacet(cls, slot);
            this.storeCardinalityFacet(cls, slot, bl);
            if (cls == null) {
                this.storeInverseProperty(slot);
                this.storeSuperslotProperty(slot);
                this.storeAssociatedFacet(slot);
            }
            this.storeConstraintsFacet(cls, slot);
            this.storeUserFacets(cls, slot);
            this.storeAccessorFacet();
            this.print(")");
        }
        catch (Exception exception) {
            String string = "Errors at storing slot " + slot + " at class " + cls;
            Log.getLogger().log(Level.WARNING, string, exception);
            this._errors.add(new MessageError(exception, string));
        }
    }

    private void storeSlotDocumentation(Cls cls, Slot slot) {
        String string = (String)CollectionUtilities.getFirstItem(ClsStorer.getTemplateSlotDocumentation(cls, slot));
        if (string != null) {
            this.println();
            this.print(";+\t\t(comment ");
            this.print(ClipsUtil.toExternalString(string));
            this.print(")");
        }
    }

    private void storeSlots(Cls cls) {
        Collection collection = this.getSlotsToStore(cls);
        for (Slot slot : collection) {
            this.storeSlot(cls, slot);
        }
    }

    private Collection getSlotsToStore(Cls cls) {
        HashSet<Slot> hashSet;
        if (cls == null) {
            hashSet = this.getDirectSlots();
        } else {
            hashSet = new HashSet<Slot>(cls.getDirectTemplateSlots());
            hashSet.addAll(this._kb.getDirectlyOverriddenTemplateSlots(cls));
        }
        return hashSet;
    }

    private Collection getDirectSlots() {
        HashSet hashSet = new HashSet(this._kb.getSlots());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)iterator.next();
            if (!slot.isIncluded()) continue;
            iterator.remove();
        }
        return hashSet;
    }

    private void storeSubclasses(Cls cls) {
        for (Cls cls2 : ClsStorer.getDirectSubclasses(cls)) {
            if (this._storedClses.contains(cls2) || !this.superclassesStored(cls2)) continue;
            this.storeClsAndSubclasses(cls2);
        }
    }

    private void storeSuperclasses(Cls cls) {
        this.println();
        this.print("\t(is-a");
        Collection<Cls> collection = this.getDirectSuperclasses(cls);
        Cls cls2 = this.getRootCls();
        for (Cls cls3 : collection) {
            if (ClsStorer.equals(cls3, cls2)) {
                this.print(" USER");
                continue;
            }
            this.print(" ");
            this.printFrame(cls3);
        }
        this.print(")");
    }

    private void storeSuperslotProperty(Slot slot) {
        Collection collection = slot.getDirectSuperslots();
        if (!collection.isEmpty()) {
            this.println();
            this.print(";+\t\t(subslot-of ");
            boolean bl = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    this.print(" ");
                }
                Slot slot2 = (Slot)iterator.next();
                this.printFrame(slot2);
            }
            this.print(")");
        }
    }

    private void storeTopLevelSlots(KnowledgeBase knowledgeBase) {
        this.printCls(null);
    }

    private void storeTypeFacet(Cls cls, Slot slot) {
        this.println();
        ValueType valueType = ClsStorer.getTemplateSlotValueType(cls, slot);
        if (valueType == ValueType.ANY) {
            this.print(";+");
        }
        this.print("\t\t(type ");
        String string = (String)_typeStrings.get(valueType);
        this.print(string);
        this.print(")");
    }

    private void storeConstraintsFacet(Cls cls, Slot slot) {
        Facet facet = this._kb.getFacet(":CONSTRAINTS");
        this.storeUserFacet(cls, slot, facet);
    }

    private void storeUserFacet(Cls cls, Slot slot, Facet facet) {
        if (ClsStorer.hasDirectlyOverriddenTemplateFacet(cls, slot, facet)) {
            Collection collection = ClsStorer.getDirectTemplateFacetValues(cls, slot, facet);
            ValueType valueType = facet.getValueType();
            this.storeCollectionFacet("user-facet " + facet.getName(), collection, true, valueType, true);
        }
    }

    private void storeUserFacets(Cls cls, Slot slot) {
        for (Facet facet : ClsStorer.getTemplateFacets(cls, slot)) {
            if (facet.isSystem()) continue;
            this.storeUserFacet(cls, slot, facet);
        }
    }

    private void storeValueFacet(Cls cls, Slot slot) {
        ValueType valueType = ClsStorer.getTemplateSlotValueType(cls, slot);
        this.storeCollectionFacet("value", ClsStorer.getTemplateSlotValues(cls, slot), true, valueType, false);
    }

    private boolean superclassesStored(Cls cls) {
        boolean bl = true;
        for (Cls cls2 : cls.getDirectSuperclasses()) {
            if (this._storedClses.contains(cls2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static {
        _typeStrings.put(ValueType.ANY, "ANY");
        _typeStrings.put(ValueType.BOOLEAN, "SYMBOL");
        _typeStrings.put(ValueType.CLS, "SYMBOL");
        _typeStrings.put(ValueType.FLOAT, "FLOAT");
        _typeStrings.put(ValueType.INSTANCE, "INSTANCE");
        _typeStrings.put(ValueType.INTEGER, "INTEGER");
        _typeStrings.put(ValueType.STRING, "STRING");
        _typeStrings.put(ValueType.SYMBOL, "SYMBOL");
    }
}

