/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.ClsReferencersAction;
import edu.stanford.smi.protege.action.CreateClsAction;
import edu.stanford.smi.protege.action.DeleteClsAction;
import edu.stanford.smi.protege.action.ViewClsAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.Transaction;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ConfigureAction;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.RelationshipPane;
import edu.stanford.smi.protege.ui.SubclassPane;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.StandardAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public class ClsesPanel
extends SelectableContainer {
    protected Project _project;
    protected LabeledComponent _labeledComponent;
    protected AllowableAction _createAction;
    protected Action _viewAction;
    protected AllowableAction _deleteAction;
    protected SubclassPane _subclassPane;
    protected RelationshipPane _relationshipPane;
    protected HeaderComponent _clsBrowserHeader;
    protected static final String ResourcesKey = null;

    public ClsesPanel(Project project) {
        this._project = project;
        this._viewAction = this.getViewClsAction();
        this._createAction = this.getCreateClsAction();
        this._deleteAction = this.getDeleteClsAction();
        this.createPanes();
        String string = LocalizedText.getText(ResourceKey.CLASS_BROWSER_HIERARCHY_LABEL);
        this._labeledComponent = new LabeledComponent(string, this._subclassPane, true);
        this._labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this._labeledComponent.addHeaderButton(this._viewAction);
        this._labeledComponent.addHeaderButton(new ClsReferencersAction(this));
        this._labeledComponent.addHeaderButton(this._createAction);
        this._labeledComponent.addHeaderButton(this._deleteAction);
        this._labeledComponent.addHeaderButton(this.createConfigureAction());
        this.add((Component)this._labeledComponent, "Center");
        this.add((Component)this.createClsBrowserHeader(), "North");
        this.setSelectable(this._subclassPane);
        this.updateDeleteActionState();
    }

    public LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    protected HeaderComponent createClsBrowserHeader() {
        JLabel jLabel = ComponentFactory.createLabel(this._project.getName(), Icons.getProjectIcon(), 2);
        String string = LocalizedText.getText(ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        String string2 = LocalizedText.getText(ResourceKey.CLASS_BROWSER_TITLE);
        return new HeaderComponent(string2, string, jLabel);
    }

    protected void createPanes() {
        this._subclassPane = this.createSubclassPane(this._viewAction, this.getKnowledgeBase().getRootCls(), this._createAction, this._deleteAction);
        this._relationshipPane = this.createRelationshipPane(this._viewAction);
    }

    protected RelationshipPane createRelationshipPane(Action action) {
        return new RelationshipPane(action);
    }

    protected SubclassPane createSubclassPane(Action action, Cls cls, Action action2, Action action3) {
        return new SubclassPane(action, cls, action2, action3);
    }

    protected void enableButton(AllowableAction allowableAction, boolean bl) {
        if (allowableAction != null) {
            allowableAction.setAllowed(bl);
        }
    }

    protected void enableButtons(boolean bl) {
        this.enableButton(this._createAction, bl);
    }

    public JTree getClsesTree() {
        return (JTree)this._subclassPane.getDropComponent();
    }

    protected AllowableAction getCreateClsAction() {
        return new CreateClsAction(){

            public void onCreate() {
                final Collection collection = ClsesPanel.this._subclassPane.getSelection();
                if (!collection.isEmpty()) {
                    Transaction<Cls> transaction = new Transaction<Cls>(ClsesPanel.this.getKnowledgeBase(), "Create Cls (random name)"){
                        private Cls cls;

                        @Override
                        public boolean doOperations() {
                            this.cls = this.getKnowledgeBase().createCls(null, collection);
                            return true;
                        }

                        @Override
                        public Cls getResult() {
                            return this.cls;
                        }
                    };
                    transaction.execute();
                    Cls cls = (Cls)transaction.getResult();
                    ClsesPanel.this._subclassPane.extendSelection(cls);
                }
            }
        };
    }

    protected AllowableAction getDeleteClsAction() {
        DeleteClsAction deleteClsAction = new DeleteClsAction((Selectable)this){

            public void onAboutToDelete(Object object) {
                ClsesPanel.this._subclassPane.removeSelection();
            }

            public void onSelectionChange() {
                ClsesPanel.this.updateDeleteActionState();
            }
        };
        deleteClsAction.setEnabled(true);
        return deleteClsAction;
    }

    protected Action createConfigureAction() {
        return new ConfigureAction(){

            public void loadPopupMenu(JPopupMenu jPopupMenu) {
                jPopupMenu.add(ClsesPanel.this.createShowSubclassesAction());
                jPopupMenu.add(ClsesPanel.this.createShowAllRelationsAction());
                for (Slot slot : ClsesPanel.this.getRelationSlots()) {
                    jPopupMenu.add(ClsesPanel.this.createShowRelationAction(slot));
                }
            }
        };
    }

    public Collection getRelationSlots() {
        HashSet<Slot> hashSet = new HashSet<Slot>();
        Collection collection = this.getSelection();
        if (collection.size() == 1) {
            Frame frame = (Frame)collection.iterator().next();
            if (frame instanceof Cls) {
                Cls cls = (Cls)frame;
                for (Comparable<Frame> comparable : cls.getTemplateSlots()) {
                    ValueType valueType = cls.getTemplateSlotValueType((Slot)comparable);
                    if (valueType != ValueType.INSTANCE && valueType != ValueType.CLS) continue;
                    hashSet.add((Slot)comparable);
                }
            }
            for (Slot slot : frame.getOwnSlots()) {
                Comparable<Frame> comparable;
                comparable = frame.getOwnSlotValueType(slot);
                if (slot.isSystem() || comparable != ValueType.INSTANCE && comparable != ValueType.CLS) continue;
                hashSet.add(slot);
            }
        }
        return hashSet;
    }

    protected Action createShowSubclassesAction() {
        return new StandardAction(ResourceKey.CLASS_BROWSER_SHOW_CLASS_HIERARCHY_MENU_ITEM){

            public void actionPerformed(ActionEvent actionEvent) {
                ClsesPanel.this._subclassPane.setSelectedClses(ClsesPanel.this.getSelection());
                ClsesPanel.this.loadComponent((Selectable)ClsesPanel.this._subclassPane, ResourceKey.CLASS_BROWSER_HIERARCHY_LABEL);
                ClsesPanel.this.enableButtons(true);
            }
        };
    }

    protected Action createShowAllRelationsAction() {
        return new StandardAction(ResourceKey.CLASS_BROWSER_SHOW_ALL_RELATIONS_MENU_ITEM){

            public void actionPerformed(ActionEvent actionEvent) {
                ClsesPanel.this._relationshipPane.load((Frame)ClsesPanel.this.getSoleSelection(), null);
                ClsesPanel.this.loadComponent((Selectable)ClsesPanel.this._relationshipPane, ResourceKey.CLASS_BROWSER_ALL_RELATIONS_LABEL);
                ClsesPanel.this.enableButtons(false);
            }
        };
    }

    protected Action createShowRelationAction(final Slot slot) {
        String string = LocalizedText.getText(ResourceKey.CLASS_BROWSER_SHOW_RELATION_MENU_ITEM, slot.getBrowserText());
        return new StandardAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                ClsesPanel.this._relationshipPane.load((Frame)ClsesPanel.this.getSoleSelection(), slot);
                ClsesPanel.this.loadComponent((Selectable)ClsesPanel.this._relationshipPane, slot.getBrowserText());
                ClsesPanel.this.enableButtons(false);
            }
        };
    }

    protected JComponent getDisplayedComponent() {
        return (JComponent)this._labeledComponent.getCenterComponent();
    }

    public Cls getDisplayParent() {
        return this._subclassPane.getDisplayParent();
    }

    public JComponent getDropComponent() {
        return this._subclassPane.getDropComponent();
    }

    protected KnowledgeBase getKnowledgeBase() {
        return this._project.getKnowledgeBase();
    }

    public Project getProject() {
        return this._project;
    }

    protected Selectable getRelationshipPane() {
        return this._relationshipPane;
    }

    public Collection getSelection() {
        return ((Selectable)((Object)this.getDisplayedComponent())).getSelection();
    }

    public SubclassPane getSubclassPane() {
        return this._subclassPane;
    }

    protected Action getViewClsAction() {
        return new ViewClsAction((Selectable)this){

            public void onView(Object object) {
                ClsesPanel.this.showInstance((Cls)object);
            }
        };
    }

    protected boolean isDisplayingSubclasses() {
        return this._labeledComponent.getCenterComponent() == this._subclassPane;
    }

    protected void loadComponent(Selectable selectable) {
        this.loadComponent(selectable, "");
    }

    protected void loadComponent(Selectable selectable, ResourceKey resourceKey) {
        this.loadComponent(selectable, LocalizedText.getText(resourceKey));
    }

    protected void loadComponent(Selectable selectable, String string) {
        this._labeledComponent.setCenterComponent((JComponent)((Object)selectable));
        this._labeledComponent.setHeaderLabel(string);
        this.setSelectable(selectable);
    }

    private Component getView() {
        return this._labeledComponent.getCenterComponent();
    }

    public void setDisplayParent(Cls cls) {
        if (this.isDisplayingSubclasses()) {
            this._subclassPane.setDisplayParent(cls);
        }
    }

    public void setExpandedCls(Cls cls, boolean bl) {
        if (this.isDisplayingSubclasses()) {
            this._subclassPane.setExpandedCls(cls, bl);
        }
    }

    public void setFinderComponent(JComponent jComponent) {
        this._subclassPane.setFinderComponent(jComponent);
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this._subclassPane.setRenderer(defaultRenderer);
    }

    public void setSelectedCls(Cls cls) {
        if (this.isDisplayingSubclasses()) {
            this._subclassPane.setSelectedCls(cls);
        }
    }

    protected void showInstance(Instance instance) {
        this._project.show(instance);
    }

    protected void updateDeleteActionState() {
        if (this._deleteAction != null) {
            boolean bl = true;
            for (Frame frame : this.getSelection()) {
                if (frame.isEditable()) continue;
                bl = false;
                break;
            }
            boolean bl2 = this.getView() == this._subclassPane;
            this._deleteAction.setAllowed(bl && bl2);
        }
    }
}

