/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.AbstractSelectableComponent;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;

public class FileList
extends AbstractSelectableComponent {
    private JList _fileList;
    private String _description;
    private String _extension;

    public FileList(String string, Collection collection, String string2, String string3) {
        this._description = string3;
        this._extension = string2;
        this.setLayout(new BorderLayout());
        LabeledComponent labeledComponent = new LabeledComponent(string, this.createComponent(collection));
        labeledComponent.addHeaderButton(this.newAddAction());
        labeledComponent.addHeaderButton(this.newRemoveAction());
        this.add(labeledComponent);
        this.setPreferredSize(new Dimension(300, 200));
    }

    private void browse() {
        JFileChooser jFileChooser = ComponentFactory.createFileChooser(this._description, this._extension);
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(this);
        switch (n) {
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                File[] fileArray = jFileChooser.getSelectedFiles();
                if (fileArray == null) break;
                for (int i = 0; i < fileArray.length; ++i) {
                    ComponentUtilities.addSelectedListValue(this._fileList, fileArray[i].getPath());
                }
                break;
            }
            default: {
                Assert.fail("bad result: " + n);
            }
        }
    }

    public void clearSelection() {
        this._fileList.clearSelection();
    }

    private JComponent createComponent(Collection collection) {
        this._fileList = ComponentFactory.createList(this.newAddAction());
        this._fileList.addListSelectionListener(new ListSelectionListenerAdapter(this));
        if (collection != null) {
            ComponentUtilities.setListValues(this._fileList, collection);
        }
        return ComponentFactory.createScrollPane(this._fileList);
    }

    public Collection getPaths() {
        return ComponentUtilities.getListValues(this._fileList);
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._fileList);
    }

    private Action newAddAction() {
        return new AddAction(ResourceKey.VALUE_ADD){

            public void onAdd() {
                FileList.this.browse();
            }
        };
    }

    private Action newRemoveAction() {
        return new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){

            public void onRemove(Collection collection) {
                ComponentUtilities.removeListValues(FileList.this._fileList, collection);
            }
        };
    }
}

