/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.ResizingLayout;
import edu.stanford.smi.protege.util.UnaryFunction;
import edu.stanford.smi.protege.widget.AbstractClsWidget;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.DefaultWidgetLayoutStrategy;
import edu.stanford.smi.protege.widget.FormWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.Widget;
import edu.stanford.smi.protege.widget.WidgetLayoutStrategy;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class FormWidget
extends AbstractClsWidget {
    public static final String STRETCH_ALL = "<<all>>";
    public static final String STRETCH_NONE = "<<none>>";
    private static final String PROPERTY_LAYOUT_PROPERTIES = "layout properties";
    private static final String PROPERTY_HORIZONTAL_STRETCHER = "horizontal_stretcher";
    private static final String PROPERTY_VERTICAL_STRETCHER = "vertical_stretcher";
    private static final int RESIZE_NONE = 0;
    private static final int RESIZE_NW = 6;
    private static final int RESIZE_N = 8;
    private static final int RESIZE_NE = 7;
    private static final int RESIZE_E = 11;
    private static final int RESIZE_SE = 5;
    private static final int RESIZE_S = 9;
    private static final int RESIZE_SW = 4;
    private static final int RESIZE_W = 10;
    private WidgetLayoutStrategy _cachedLayoutStrategy = new DefaultWidgetLayoutStrategy();
    private AbstractSlotWidget _selectedWidget;
    private Dimension _cursorOffset;
    private int _resizeDirection = 0;
    private int _gridSize = 10;
    private boolean _isDragging;
    private KeyListener _widgetKeyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            Component component = keyEvent.getComponent();
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 37: {
                    FormWidget.this.translate(component, -1, 0);
                    break;
                }
                case 39: {
                    FormWidget.this.translate(component, 1, 0);
                    break;
                }
                case 38: {
                    FormWidget.this.translate(component, 0, -1);
                    break;
                }
                case 40: {
                    FormWidget.this.translate(component, 0, 1);
                    break;
                }
            }
        }
    };
    private MouseListener _formMouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            FormWidget.this.mousePressedOnForm(mouseEvent.getPoint());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                FormWidget.this.configure();
            }
        }
    };
    private MouseMotionListener _formMouseMotionListener = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent mouseEvent) {
            FormWidget.this.mouseMovedOnForm(mouseEvent.getPoint());
        }
    };
    private MouseListener _widgetMouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            FormWidget.this.mousePressedOnWidget(mouseEvent.getComponent(), mouseEvent.getPoint());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            FormWidget.this.mouseReleasedOnWidget(mouseEvent.getComponent(), mouseEvent.getPoint());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            FormWidget.this.mouseClickedOnWidget(mouseEvent.getComponent(), mouseEvent.getPoint(), mouseEvent.getClickCount());
        }
    };
    private MouseMotionListener _widgetMouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent mouseEvent) {
            FormWidget.this.mouseDraggedOnWidget(mouseEvent.getComponent(), mouseEvent.getPoint());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            FormWidget.this.mouseMovedOnWidget(mouseEvent.getComponent(), mouseEvent.getPoint());
        }
    };
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateSlotAdded(ClsEvent clsEvent) {
            if (FormWidget.this.canChangeThisClass(clsEvent.getCls())) {
                FormWidget.this.onTemplateSlotAdded(clsEvent.getCls(), clsEvent.getSlot());
            }
        }

        public void templateSlotRemoved(ClsEvent clsEvent) {
            if (FormWidget.this.canChangeThisClass(clsEvent.getCls())) {
                FormWidget.this.onTemplateSlotRemoved(clsEvent.getCls(), clsEvent.getSlot());
            }
        }

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            if (FormWidget.this.canChangeThisClass(clsEvent.getCls())) {
                FormWidget.this.onTemplateFacetValueChanged(clsEvent.getCls(), clsEvent.getSlot(), clsEvent.getFacet());
            }
        }
    };
    private KnowledgeBaseListener _kbListener = new KnowledgeBaseAdapter(){

        public void frameReplaced(KnowledgeBaseEvent knowledgeBaseEvent) {
            Frame frame = knowledgeBaseEvent.getFrame();
            if (frame instanceof Slot) {
                Slot slot = (Slot)frame;
                WidgetDescriptor widgetDescriptor = FormWidget.this.getPropertyList().getWidgetDescriptor(knowledgeBaseEvent.getOldName());
                if (widgetDescriptor != null) {
                    widgetDescriptor.setName(knowledgeBaseEvent.getNewFrame().getName());
                    FormWidget.this.reload();
                }
            }
        }
    };

    protected void onTemplateSlotAdded(Cls cls, Slot slot) {
        this.reload();
    }

    protected void onTemplateSlotRemoved(Cls cls, Slot slot) {
        this.reload();
    }

    protected void onTemplateFacetValueChanged(Cls cls, Slot slot, Facet facet) {
        this.reload();
    }

    private boolean canChangeThisClass(Cls cls) {
        Cls cls2 = this.getCls();
        return cls2.equals(cls) || cls2.hasSuperclass(cls);
    }

    private static void adjustEast(Rectangle rectangle, Point point) {
        rectangle.width -= rectangle.x + rectangle.width - point.x;
    }

    private static void adjustNorth(Rectangle rectangle, Point point) {
        rectangle.height += rectangle.y - point.y;
        rectangle.y = point.y;
    }

    private static void adjustSouth(Rectangle rectangle, Point point) {
        rectangle.height -= rectangle.y + rectangle.height - point.y;
    }

    private static void adjustWest(Rectangle rectangle, Point point) {
        rectangle.width += rectangle.x - point.x;
        rectangle.x = point.x;
    }

    private boolean canRemoveCustomizations() {
        FrameID frameID = this.getCls().getFrameID();
        return !FormWidget.equals(frameID, Model.ClsID.STANDARD_CLASS) && !FormWidget.equals(frameID, Model.ClsID.STANDARD_SLOT);
    }

    public void clearSelection() {
        if (this._selectedWidget != null) {
            this._selectedWidget.setNormalBorder();
            this._selectedWidget = null;
            this.notifySelectionListeners();
        }
    }

    public boolean configure() {
        boolean bl;
        FormWidgetConfigurationPanel formWidgetConfigurationPanel = new FormWidgetConfigurationPanel(this);
        int n = ModalDialog.showDialog(this, formWidgetConfigurationPanel, "Configure form for " + this.getCls().getName(), 11);
        boolean bl2 = bl = n == 1;
        if (bl) {
            this.setModified(true);
        }
        return bl;
    }

    public void createDescriptorsAndWidgets(Collection collection) {
        for (Slot slot : collection) {
            this.createWidget(slot);
        }
    }

    private Widget createWidget(Slot slot) {
        return this.createWidget(slot, null);
    }

    private Widget createWidget(Slot slot, String string) {
        WidgetDescriptor widgetDescriptor = this.createWidgetDescriptor(slot);
        if (string != null) {
            widgetDescriptor.setWidgetClassName(string);
        }
        return this.createWidget(widgetDescriptor);
    }

    private SlotWidget createWidget(WidgetDescriptor widgetDescriptor) {
        SlotWidget slotWidget;
        if (widgetDescriptor.isNull()) {
            slotWidget = null;
        } else {
            KnowledgeBase knowledgeBase = this.getKnowledgeBase();
            String string = widgetDescriptor.getName();
            Slot slot = knowledgeBase.getSlot(string);
            slotWidget = WidgetUtilities.createSlotWidget(widgetDescriptor, this.isDesignTime(), this.getProject(), this.getCls(), slot);
            this.setupWidget(slotWidget);
        }
        return slotWidget;
    }

    public WidgetDescriptor createWidgetDescriptor(Slot slot) {
        WidgetDescriptor widgetDescriptor = this.getProject().createWidgetDescriptor(this.getCls(), slot, null);
        this.getPropertyList().setWidgetDescriptor(widgetDescriptor);
        return widgetDescriptor;
    }

    protected Collection getClsSlots() {
        Slot slot;
        Collection collection = this.getCls().getVisibleTemplateSlots();
        if (this.getProject().getAddNameOnInstanceForm() && !collection.contains(slot = this.getKnowledgeBase().getNameSlot())) {
            collection.add(slot);
        }
        return collection;
    }

    protected void createWidgets() {
        HashSet hashSet = new HashSet(this.getClsSlots());
        for (String string : this.getPropertyList().getNames()) {
            WidgetDescriptor widgetDescriptor;
            if (string == null) {
                Log.getLogger().warning("null widget name");
                continue;
            }
            if (!FormWidget.isSlotName(string) || (widgetDescriptor = this.getPropertyList().getWidgetDescriptor(string)) == null) continue;
            String string2 = widgetDescriptor.getName();
            if (!string.equals(string2)) {
                Log.getLogger().warning("Mismatched slot names: " + string + " - " + string2);
            }
            boolean bl = true;
            if (string2 != null) {
                Slot slot = this.getKnowledgeBase().getSlot(string2);
                if (slot != null) {
                    bl = this.isSuitable(widgetDescriptor, this.getCls(), slot);
                }
                if (bl) {
                    bl = hashSet.remove(slot);
                }
            }
            if (bl) {
                this.createWidget(widgetDescriptor);
                continue;
            }
            this.getPropertyList().remove(string);
        }
        int n = this.getCustomizedComponentCount();
        this.createDescriptorsAndWidgets(hashSet);
        this.layoutWidgets(n);
        this.doLayoutSanityCheck();
    }

    public void dispose() {
        super.dispose();
        this.getKnowledgeBase().removeKnowledgeBaseListener(this._kbListener);
        if (this.isDesignTime()) {
            this.removeMouseListener(this._formMouseListener);
            this.removeMouseMotionListener(this._formMouseMotionListener);
            this.getKnowledgeBase().removeClsListener(this._clsListener);
        }
    }

    private void doLayoutSanityCheck() {
        boolean bl = false;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            Point point = component.getLocation();
            if (point.x != 0 || point.y != 0) continue;
            if (bl) {
                component.setLocation(0, this.getPreferredSize().height);
                this.revalidate();
                continue;
            }
            bl = true;
        }
    }

    private void dragWidget(JComponent jComponent, Point point) {
        point.translate(this._cursorOffset.width, this._cursorOffset.height);
        Point point2 = this.gridPoint(point);
        if (!point2.equals(jComponent.getLocation())) {
            jComponent.setLocation(point2);
        }
    }

    private Component getComponent(Slot slot) {
        Component component = null;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            SlotWidget slotWidget;
            Component component2 = this.getComponent(i);
            if (!(component2 instanceof SlotWidget) || !FormWidget.equals((slotWidget = (SlotWidget)((Object)component2)).getSlot(), slot)) continue;
            component = component2;
            break;
        }
        return component;
    }

    private int getCustomizedComponentCount() {
        return this.getComponentCount();
    }

    protected Cls getCustomizedParent(Cls cls) {
        Cls cls2;
        block0: {
            Project project = cls.getProject();
            cls2 = null;
            Iterator<Cls> iterator = cls.getDirectSuperclasses().iterator();
            if (!iterator.hasNext() || cls2 != null) break block0;
            Cls cls3 = iterator.next();
            cls2 = project.hasCustomizedDescriptor(cls3) ? cls3 : this.getCustomizedParent(cls3);
        }
        return cls2;
    }

    public String getHorizontalStretcher() {
        return this.getLayout(PROPERTY_HORIZONTAL_STRETCHER);
    }

    public String getLabel() {
        String string;
        if (this.isDesignTime()) {
            string = this.getCls().getBrowserText();
        } else {
            String string2;
            Instance instance = this.getInstance();
            string = string2 = instance.getBrowserText();
            Cls cls = this.getAssociatedCls();
            if (instance instanceof Slot && cls != null) {
                string = string + " at class " + cls.getBrowserText();
            }
            string = string + "   (instance of " + instance.getDirectType().getBrowserText();
            String string3 = instance.getName();
            if (!string3.equals(string2)) {
                string = string + ", internal name is " + string3;
            }
            string = string + ")";
        }
        return string;
    }

    private PropertyList getLayoutProperties() {
        return this.getPropertyList().getPropertyList(PROPERTY_LAYOUT_PROPERTIES);
    }

    private String getLayout(String string) {
        return this.getLayoutProperties().getString(string);
    }

    private Point getParentPoint(Point point) {
        return SwingUtilities.convertPoint(this, point, this.getParent());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        for (WidgetDescriptor widgetDescriptor : this.getPropertyList().getLiveWidgetDescriptors()) {
            String string = widgetDescriptor.getName();
            if (!FormWidget.isSlotName(string) || widgetDescriptor.isNull()) continue;
            Rectangle rectangle = widgetDescriptor.getBounds();
            if (rectangle == null) {
                Log.getLogger().warning("null rectangle: " + string);
                continue;
            }
            dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width);
            dimension.height = Math.max(dimension.height, rectangle.y + rectangle.height);
        }
        return dimension;
    }

    private static int getResizeDirection(Component component, Point point) {
        int n;
        Rectangle rectangle = component.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n2 = AbstractSlotWidget.getSelectionBorderSize();
        rectangle2.grow(-n2, -n2);
        if (rectangle2.contains(point)) {
            n = 0;
        } else if (point.x <= rectangle2.x) {
            n = point.y <= rectangle2.y ? 6 : (point.y >= rectangle2.y + rectangle2.height ? 4 : 10);
        } else if (point.x >= rectangle2.x + rectangle2.width) {
            n = point.y <= rectangle2.y ? 7 : (point.y >= rectangle2.y + rectangle2.height ? 5 : 11);
        } else if (point.y <= rectangle2.y) {
            n = 8;
        } else if (point.y >= rectangle2.y + rectangle2.height) {
            n = 9;
        } else {
            throw new IllegalStateException("Logic error on resize direction");
        }
        return n;
    }

    public Collection getSelection() {
        return CollectionUtilities.createCollection(this._selectedWidget);
    }

    public String getVerticalStretcher() {
        return this.getLayout(PROPERTY_VERTICAL_STRETCHER);
    }

    public SlotWidget getSlotWidget(Slot slot) {
        int n = this.getComponentCount();
        SlotWidget slotWidget = null;
        for (int i = 0; i < n; ++i) {
            SlotWidget slotWidget2;
            Component component = this.getComponent(i);
            if (!(component instanceof Widget) || !FormWidget.equals((slotWidget2 = (SlotWidget)((Object)component)).getSlot(), slot)) continue;
            slotWidget = slotWidget2;
            break;
        }
        return slotWidget;
    }

    public void highlightSlot(Slot slot, Color color) {
        AbstractSlotWidget abstractSlotWidget = (AbstractSlotWidget)this.getSlotWidget(slot);
        if (abstractSlotWidget != null) {
            if (color == null) {
                abstractSlotWidget.setNormalBorder();
            } else {
                abstractSlotWidget.setSelectedBorder(color);
            }
        }
    }

    private JComponent getWidget(Component component) {
        JComponent jComponent = null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JComponent jComponent2 = (JComponent)this.getComponent(i);
            if (!FormWidget.equals(jComponent2, component) && !jComponent2.isAncestorOf(component)) continue;
            jComponent = jComponent2;
            break;
        }
        Assert.assertNotNull("widget", jComponent);
        return jComponent;
    }

    public WidgetDescriptor getWidgetDescriptor(Slot slot) {
        return this.getPropertyList().getWidgetDescriptor(slot.getName());
    }

    private Point getWidgetPoint(Component component, Point point) {
        return SwingUtilities.convertPoint(component, point, this);
    }

    private Point gridPoint(Point point) {
        Point point2 = new Point(point);
        point2.x -= point2.x % this._gridSize;
        point2.y -= point2.y % this._gridSize;
        return point2;
    }

    public boolean hasWidgetDescriptor(Slot slot) {
        return this.getWidgetDescriptor(slot) != null;
    }

    public boolean hasWidgetDescriptors() {
        boolean bl = !this.getPropertyList().getNames().isEmpty();
        return bl;
    }

    public void setResizeVertically(boolean bl) {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof ResizingLayout) {
            ((ResizingLayout)layoutManager).setResizeVertically(bl);
        }
    }

    public void initialize() {
        this.setLayout(null);
        this.initializeStretching();
        this.initializeWidgets();
        this.getKnowledgeBase().addKnowledgeBaseListener(this._kbListener);
        if (this.isDesignTime()) {
            this.addMouseListener(this._formMouseListener);
            this.addMouseMotionListener(this._formMouseMotionListener);
            this.getKnowledgeBase().addClsListener(this._clsListener);
        } else {
            this.setLayout(new ResizingLayout());
        }
    }

    public void reload() {
        Component[] componentArray = this.getComponents();
        this.removeAll();
        for (int i = 0; i < componentArray.length; ++i) {
            ComponentUtilities.dispose(componentArray[i]);
        }
        this.initializeWidgets();
    }

    private void initializeStretching() {
        String string = this.getHorizontalStretcher();
        this.putStretchingClientProperty("filling_horizontally", string, true);
        String string2 = this.getVerticalStretcher();
        this.putStretchingClientProperty("filling_vertically", string2, false);
    }

    private void putStretchingClientProperty(String string, String string2, boolean bl) {
        boolean bl2 = string2 == null ? bl : !STRETCH_NONE.equals(string2);
        this.putClientProperty(string, bl2);
    }

    private void initializeWidgets() {
        if (this.isDesignTime() && !this.isModified()) {
            Cls cls = this.getCustomizedParent(this.getCls());
            if (cls != null) {
                this.layoutLikeCls(cls);
                this.setModified(false);
            } else {
                this.createWidgets();
            }
        } else {
            this.createWidgets();
        }
    }

    private boolean isModified() {
        return this.getDescriptor().isDirectlyCustomizedByUser();
    }

    private static boolean isSlotName(String string) {
        return !string.equals(PROPERTY_LAYOUT_PROPERTIES);
    }

    protected boolean isSuitable(WidgetDescriptor widgetDescriptor, Cls cls, Slot slot) {
        String string = widgetDescriptor.getWidgetClassName();
        return string == null || this.getProject().isSuitableWidget(cls, slot, null, widgetDescriptor);
    }

    public void layoutLikeCls(Cls cls) {
        this.removeAllSlotWidgets();
        PropertyList propertyList = this.getProject().getClsWidgetPropertyList(cls);
        this.setPropertyList((PropertyList)propertyList.clone());
        this.setModified(true);
        this.createWidgets();
        this.revalidate();
        this.repaint();
    }

    public void layoutLikeParent() {
        Cls cls = this.getCustomizedParent(this.getCls());
        this.layoutLikeCls(cls);
        this.setModified(false);
    }

    private void layoutWidgets(int n) {
        if (n < this.getComponentCount()) {
            this._cachedLayoutStrategy.layout(this, n);
        }
        this.revalidate();
        this.repaint();
    }

    private void mouseClickedOnWidget(Component component, Point point, int n) {
        Widget widget;
        boolean bl;
        if (n == 2 && (bl = (widget = (Widget)((Object)this.getWidget(component))).configure())) {
            this.rebuildWidget(widget);
        }
    }

    private void mouseDrag(JComponent jComponent, Point point) {
        if (this._resizeDirection == 0) {
            this.dragWidget(jComponent, point);
        } else {
            this.resizeWidget(jComponent, point);
        }
        this.updateSize();
    }

    public void mouseDraggedOnWidget(Component component, Point point) {
        JComponent jComponent = this.getWidget(component);
        Point point2 = this.getWidgetPoint(component, point);
        this.mouseDrag(jComponent, point2);
        this._isDragging = true;
    }

    private void mouseMove(JComponent jComponent, Point point) {
        this.setCursor(jComponent, point);
    }

    private void mouseMovedOnForm(Point point) {
        int n;
        Point point2 = this.getParentPoint(point);
        this._resizeDirection = n = FormWidget.getResizeDirection(this, point2);
        this.setCursor((Component)this, n);
    }

    public void mouseMovedOnWidget(Component component, Point point) {
        JComponent jComponent = this.getWidget(component);
        Point point2 = this.getWidgetPoint(component, point);
        this.mouseMove(jComponent, point2);
    }

    private void mousePress(JComponent jComponent, Point point) {
        if (jComponent != this._selectedWidget) {
            this.clearSelection();
            this.setSelection(jComponent);
        }
        Point point2 = jComponent.getLocation();
        this._cursorOffset = new Dimension(point2.x - point.x, point2.y - point.y);
        this._resizeDirection = FormWidget.getResizeDirection(jComponent, point);
        jComponent.requestFocus();
    }

    private void mousePressedOnForm(Point point) {
        this.clearSelection();
        this.repaint();
    }

    private void mousePressedOnWidget(Component component, Point point) {
        JComponent jComponent = this.getWidget(component);
        Point point2 = this.getWidgetPoint(component, point);
        this.mousePress(jComponent, point2);
    }

    private void mouseRelease(JComponent jComponent, Point point) {
        this._resizeDirection = 0;
        this.setCursor(jComponent, point);
    }

    private void mouseReleasedOnWidget(Component component, Point point) {
        JComponent jComponent = this.getWidget(component);
        Point point2 = this.getWidgetPoint(component, point);
        this.mouseRelease(jComponent, point2);
        if (this._isDragging) {
            this._isDragging = false;
            this.setModified(true);
        }
    }

    private void propagateSetAssociatedClsToWidgets(Cls cls) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof Widget)) continue;
            SlotWidget slotWidget = (SlotWidget)((Object)component);
            slotWidget.setAssociatedCls(cls);
        }
    }

    private void propagateSetInstanceToWidgets(Instance instance) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof Widget)) continue;
            SlotWidget slotWidget = (SlotWidget)((Object)component);
            slotWidget.setInstance(instance);
        }
    }

    private void rebuildWidget(Widget widget) {
        this.replaceWidget((Component)((Object)widget), widget.getClass().getName());
        this.setModified(true);
    }

    public void relayout() {
        this.layoutWidgets(0);
        this.setModified(true);
    }

    public void removeCustomizations() {
        if (this.canRemoveCustomizations()) {
            this.getPropertyList().clear();
            this.setModified(false);
            this.removeAll();
            this.initializeWidgets();
            this.revalidate();
            this.repaint();
        } else {
            Log.getLogger().warning("cannot remove customizations for " + this.getCls());
        }
    }

    private void removeAllSlotWidgets() {
        ArrayList<Component> arrayList = new ArrayList<Component>(Arrays.asList(this.getComponents()));
        for (Component component : arrayList) {
            if (!(component instanceof Widget)) continue;
            SlotWidget slotWidget = (SlotWidget)((Object)component);
            this.removeSlotWidget(slotWidget);
        }
        this.removeAll();
    }

    private void removeSlotWidget(SlotWidget slotWidget) {
        Component component = (Component)((Object)slotWidget);
        this.remove(component);
        if (this._selectedWidget == slotWidget) {
            this.clearSelection();
        }
        if (this.isDesignTime()) {
            component.removeMouseListener(this._widgetMouseListener);
            component.removeMouseMotionListener(this._widgetMouseMotionListener);
            component.removeKeyListener(this._widgetKeyListener);
        }
        slotWidget.dispose();
    }

    public void removeWidgetDescriptor(String string) {
        this.getPropertyList().remove(string);
    }

    public void replaceSelectedWidget(String string) {
        this.replaceWidget(this._selectedWidget, string);
        this.setModified(true);
    }

    public void replaceWidget(Slot slot, String string) {
        WidgetDescriptor widgetDescriptor = this.getWidgetDescriptor(slot);
        if (widgetDescriptor == null) {
            if (string != null) {
                this.createWidget(slot, string);
            }
        } else {
            String string2 = widgetDescriptor.getWidgetClassName();
            if (string2 == null) {
                if (string != null) {
                    int n = this.getCustomizedComponentCount();
                    widgetDescriptor.setWidgetClassName(string);
                    widgetDescriptor.setBounds(new Rectangle());
                    this.createWidget(widgetDescriptor);
                    this.layoutWidgets(n);
                }
            } else if (!string2.equals(string)) {
                this.replaceWidget(this.getComponent(slot), string);
            }
        }
    }

    private void replaceWidget(Component component, String string) {
        if (component == null) {
            return;
        }
        Rectangle rectangle = component.getBounds();
        Dimension dimension = component.getPreferredSize();
        this.remove(component);
        SlotWidget slotWidget = (SlotWidget)((Object)component);
        WidgetDescriptor widgetDescriptor = slotWidget.getDescriptor();
        widgetDescriptor.setWidgetClassName(string);
        widgetDescriptor.setBounds(new Rectangle());
        ComponentUtilities.dispose(component);
        if (string == null) {
            if (this._selectedWidget == component) {
                this.clearSelection();
                this.revalidate();
                this.repaint();
            }
        } else {
            Dimension dimension2;
            SlotWidget slotWidget2 = WidgetUtilities.createSlotWidget(widgetDescriptor, true, this.getProject(), this.getCls(), slotWidget.getSlot());
            this.setupWidget(slotWidget2);
            if (this._selectedWidget == component) {
                this.setSelection(slotWidget2);
            }
            if ((dimension2 = ((JComponent)((Object)slotWidget2)).getPreferredSize()).equals(dimension) || slotWidget.getClass().getName().equals(string)) {
                ((JComponent)((Object)slotWidget2)).setBounds(rectangle);
            } else {
                ((JComponent)((Object)slotWidget2)).setBounds(new Rectangle(rectangle.getLocation(), dimension2));
            }
            ((JComponent)((Object)slotWidget2)).revalidate();
        }
    }

    private void resizeWidget(Component component, Point point) {
        point = this.gridPoint(point);
        Rectangle rectangle = component.getBounds();
        switch (this._resizeDirection) {
            case 8: {
                FormWidget.adjustNorth(rectangle, point);
                break;
            }
            case 9: {
                FormWidget.adjustSouth(rectangle, point);
                break;
            }
            case 11: {
                FormWidget.adjustEast(rectangle, point);
                break;
            }
            case 10: {
                FormWidget.adjustWest(rectangle, point);
                break;
            }
            case 6: {
                FormWidget.adjustNorth(rectangle, point);
                FormWidget.adjustWest(rectangle, point);
                break;
            }
            case 7: {
                FormWidget.adjustNorth(rectangle, point);
                FormWidget.adjustEast(rectangle, point);
                break;
            }
            case 4: {
                FormWidget.adjustSouth(rectangle, point);
                FormWidget.adjustWest(rectangle, point);
                break;
            }
            case 5: {
                FormWidget.adjustSouth(rectangle, point);
                FormWidget.adjustEast(rectangle, point);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid resize direction");
            }
        }
        component.setBounds(rectangle);
        component.validate();
        component.repaint();
    }

    public void setAssociatedCls(Cls cls) {
        super.setAssociatedCls(cls);
        this.propagateSetAssociatedClsToWidgets(cls);
    }

    private void setCursor(Component component, int n) {
        component.setCursor(Cursor.getPredefinedCursor(n));
        this.repaint();
    }

    private void setCursor(JComponent jComponent, Point point) {
        if (jComponent == this._selectedWidget) {
            int n = FormWidget.getResizeDirection(jComponent, point);
            this.setCursor((Component)jComponent, n);
        } else {
            this.setCursor((Component)jComponent, 0);
        }
    }

    public void setEditable(boolean bl) {
    }

    public void setHorizontalStretcher(String string) {
        this.setLayout(PROPERTY_HORIZONTAL_STRETCHER, string);
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        this.propagateSetInstanceToWidgets(instance);
    }

    private void setLayout(String string, String string2) {
        this.getLayoutProperties().setString(string, string2);
    }

    public void setModified(boolean bl) {
        this.getDescriptor().setDirectlyCustomizedByUser(bl);
        this.getDescriptor().setIncluded(false);
        this.getProject().postFormChangeEvent(this.getDescriptor());
    }

    public void setSelection(Object object) {
        this._selectedWidget = (AbstractSlotWidget)object;
        this.remove(this._selectedWidget);
        this.add((Component)this._selectedWidget, 0);
        this._selectedWidget.setSelectedBorder();
        this.notifySelectionListeners();
        this.repaint();
    }

    private void setupWidget(final SlotWidget slotWidget) {
        JComponent jComponent = (JComponent)((Object)slotWidget);
        if (this.isDesignTime()) {
            ComponentUtilities.apply(jComponent, new UnaryFunction(){

                public Object apply(Object object) {
                    Component component = (Component)object;
                    if (component != slotWidget) {
                        component.setEnabled(false);
                    }
                    component.addMouseListener(FormWidget.this._widgetMouseListener);
                    component.addMouseMotionListener(FormWidget.this._widgetMouseMotionListener);
                    component.addKeyListener(FormWidget.this._widgetKeyListener);
                    return null;
                }
            });
        } else {
            String string = slotWidget.getSlot().getName();
            if (FormWidget.equals(string, this.getHorizontalStretcher())) {
                this.putClientProperty("horizonal_stretcher", jComponent);
            }
            if (FormWidget.equals(string, this.getVerticalStretcher())) {
                this.putClientProperty("vertical_strecher", jComponent);
            }
        }
        this.add(jComponent);
    }

    public void setVerticalStretcher(String string) {
        this.setLayout(PROPERTY_VERTICAL_STRETCHER, string);
    }

    public void setWidgetValues() {
    }

    private void translate(Component component, int n, int n2) {
        Point point = component.getLocation();
        point.x += n * this._gridSize;
        point.y += n2 * this._gridSize;
        component.setLocation(point);
        this.setModified(true);
    }

    private void updateSize() {
    }

    private void updateWidget(Slot slot) {
        SlotWidget slotWidget = this.getSlotWidget(slot);
        if (slotWidget != null) {
            if (!this.getProject().isSuitableWidget(this.getCls(), slot, null, slotWidget.getDescriptor())) {
                String string = this.getProject().getDefaultWidgetClassName(this.getCls(), slot, null);
                this.replaceWidget((Component)((Object)slotWidget), string);
            } else {
                this.replaceWidget((Component)((Object)slotWidget), slotWidget.getClass().getName());
            }
            this.getProject().postFormChangeEvent(this.getDescriptor());
        }
    }
}

