/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.test.APITestCase;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelUtilities_Test
extends APITestCase {
    public void testGetPathToRootWithHiddenSuperclass() {
        Cls cls = this.createCls();
        Cls cls2 = this.createSubCls(cls);
        cls2.setVisible(false);
        Cls cls3 = this.createSubCls(cls);
        Cls cls4 = this.createSubCls(cls2);
        cls4.addDirectSuperclass(cls3);
        List<Cls> list = ModelUtilities.getPathToRoot(cls4);
        Iterator<Cls> iterator = list.iterator();
        ModelUtilities_Test.assertEquals((Object)this.getDomainKB().getRootCls(), (Object)iterator.next());
        ModelUtilities_Test.assertEquals((Object)cls, (Object)iterator.next());
        ModelUtilities_Test.assertEquals((Object)cls3, (Object)iterator.next());
        ModelUtilities_Test.assertEquals((Object)cls4, (Object)iterator.next());
        ModelUtilities_Test.assertFalse((boolean)iterator.hasNext());
    }

    public void testGetPropertyValuesOnAllSuperclasses() {
        Cls cls = this.createCls();
        Cls cls2 = this.createSubCls(cls);
        Cls cls3 = this.createSubCls(cls2);
        Cls cls4 = this.createSubCls(cls2);
        cls4.addDirectSuperclass(cls);
        Cls cls5 = this.createSubCls(cls4);
        Cls cls6 = this.createSubCls(cls4);
        Cls cls7 = this.createSubCls(cls6);
        cls7.addDirectSuperclass(cls);
        Cls cls8 = this.createSubCls(cls7);
        Slot slot = this.createSlot();
        cls.addOwnSlotValue(slot, "n");
        cls2.addOwnSlotValue(slot, "h");
        cls3.addOwnSlotValue(slot, "k");
        cls4.addOwnSlotValue(slot, "e");
        cls5.addOwnSlotValue(slot, "e");
        cls6.addOwnSlotValue(slot, "e");
        cls7.addOwnSlotValue(slot, "n");
        cls7.addOwnSlotValue(slot, "ny");
        cls7.addOwnSlotValue(slot, "tk");
        cls8.addOwnSlotValue(slot, "o");
        cls8.addOwnSlotValue(slot, "h");
        Map<Object, List<Instance>> map = ModelUtilities.getPropertyValuesOnAllSuperclasses(cls8, slot);
        Set<Object> set = map.keySet();
        String[] stringArray = new String[]{"n", "h", "e", "ny", "tk", "o"};
        ModelUtilities_Test.assertEquals((int)stringArray.length, (int)set.size());
        for (String string : stringArray) {
            ModelUtilities_Test.assertTrue((boolean)set.contains(string));
        }
        Object object = map.get("n");
        ModelUtilities_Test.assertEquals((int)2, (int)object.size());
        ModelUtilities_Test.assertTrue((boolean)object.contains(cls));
        ModelUtilities_Test.assertTrue((boolean)object.contains(cls7));
        object = map.get("h");
        ModelUtilities_Test.assertEquals((int)2, (int)object.size());
        ModelUtilities_Test.assertTrue((boolean)object.contains(cls2));
        ModelUtilities_Test.assertTrue((boolean)object.contains(cls8));
        object = map.get("e");
        ModelUtilities_Test.assertEquals((int)2, (int)object.size());
        ModelUtilities_Test.assertTrue((boolean)object.contains(cls6));
        ModelUtilities_Test.assertTrue((boolean)object.contains(cls4));
        object = map.get("ny");
        ModelUtilities_Test.assertEquals((int)1, (int)object.size());
        ModelUtilities_Test.assertTrue((boolean)object.contains(cls7));
        object = map.get("tk");
        ModelUtilities_Test.assertEquals((int)1, (int)object.size());
        ModelUtilities_Test.assertTrue((boolean)object.contains(cls7));
        object = map.get("o");
        ModelUtilities_Test.assertEquals((int)1, (int)object.size());
        ModelUtilities_Test.assertTrue((boolean)object.contains(cls8));
    }
}

