/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.ArgumentCheckingFrameStore;
import edu.stanford.smi.protege.model.framestore.CallCachingFrameStore;
import edu.stanford.smi.protege.model.framestore.ChangeMonitorFrameStore;
import edu.stanford.smi.protege.model.framestore.DeleteSimplificationFrameStore;
import edu.stanford.smi.protege.model.framestore.EventDispatchFrameStore;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.EventSinkFrameStore;
import edu.stanford.smi.protege.model.framestore.FacetCheckingFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.ImmutableNamesFrameStore;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameStore;
import edu.stanford.smi.protege.model.framestore.JournalingFrameStoreHandler;
import edu.stanford.smi.protege.model.framestore.ModificationRecordFrameStore;
import edu.stanford.smi.protege.model.framestore.ReadOnlyFrameStoreHandler;
import edu.stanford.smi.protege.model.framestore.TraceFrameStoreHandler;
import edu.stanford.smi.protege.model.framestore.cleandispatch.CleanDispatchFrameStore;
import edu.stanford.smi.protege.model.framestore.undo.UndoFrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameStoreManager {
    private static transient Logger log = Log.getLogger(FrameStoreManager.class);
    private FrameStore immutableNamesFrameStore;
    private FrameStore deleteSimplificationFrameStore;
    private FrameStore argumentCheckingFrameStore;
    private FrameStore cachingFrameStore;
    private FrameStore cleanDispatchFrameStore;
    private EventDispatchFrameStore eventDispatchFrameStore;
    private EventGeneratorFrameStore eventGeneratorFrameStore;
    private FrameStore eventSinkFrameStore;
    private FrameStore facetCheckingFrameStore;
    private FrameStore journalingFrameStore;
    private ModificationRecordFrameStore modificationRecordFrameStore;
    private FrameStore readonlyFrameStore;
    private UndoFrameStore undoFrameStore;
    private ChangeMonitorFrameStore changeMonitorFrameStore;
    private FrameStore traceFrameStore;
    private FrameStore terminalFrameStore;
    private FrameStore headFrameStore;
    private List<FrameStore> frameStores = new LinkedList<FrameStore>();
    private KnowledgeBase kb;

    public FrameStoreManager(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.createSystemFrameStores();
        this.headFrameStore = this.terminalFrameStore = this.create(InMemoryFrameStore.class);
        this.addSystemFrameStores();
    }

    public FrameStore getHeadFrameStore() {
        return this.headFrameStore;
    }

    public <X> X getFrameStoreFromClass(Class<? extends X> clazz) {
        for (FrameStore frameStore = this.headFrameStore; frameStore != null; frameStore = frameStore.getDelegate()) {
            Object object = frameStore;
            Class<?> clazz2 = frameStore.getClass();
            if (Proxy.isProxyClass(clazz2)) {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(frameStore);
                clazz2 = invocationHandler.getClass();
                object = invocationHandler;
            }
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return clazz.cast(object);
        }
        return null;
    }

    protected FrameStore create(Class clazz) {
        FrameStore frameStore = null;
        try {
            frameStore = FrameStoreManager.isHandlerClass(clazz) ? AbstractFrameStoreInvocationHandler.newInstance(clazz, this.kb) : (FrameStore)AbstractFrameStoreInvocationHandler.getInstance(clazz, this.kb);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
        return frameStore;
    }

    private static boolean isHandlerClass(Class clazz) {
        return AbstractFrameStoreInvocationHandler.class.isAssignableFrom(clazz);
    }

    private boolean isMultiUserClient() {
        return this.kb.getProject() != null && this.kb.getProject().isMultiUserClient();
    }

    private void addSystemFrameStores() {
        this.add(this.cachingFrameStore, false);
        this.add(this.eventGeneratorFrameStore, true);
        this.add(this.eventSinkFrameStore, false);
        this.add(this.journalingFrameStore, false);
        this.add(this.modificationRecordFrameStore, false);
        this.add(this.eventDispatchFrameStore, true);
        this.add(this.undoFrameStore, false);
        this.add(this.facetCheckingFrameStore, false);
        this.add(this.argumentCheckingFrameStore, true);
        this.add(this.readonlyFrameStore, false);
        this.add(this.changeMonitorFrameStore, true);
        this.add(this.cleanDispatchFrameStore, true);
        this.add(this.deleteSimplificationFrameStore, true);
        this.add(this.immutableNamesFrameStore, true);
        this.add(this.traceFrameStore, false);
    }

    private void add(FrameStore frameStore, boolean bl) {
        Assert.assertNotNull("frame store", frameStore);
        this.frameStores.add(0, frameStore);
        if (bl) {
            this.connect(null, frameStore);
        }
    }

    private FrameStore getPreceedingEnabledFrameStore(FrameStore frameStore) {
        int n = this.frameStores.indexOf(frameStore);
        return this.getPreceedingEnabledFrameStore(n);
    }

    private FrameStore getPreceedingEnabledFrameStore(int n) {
        FrameStore frameStore = null;
        ListIterator<FrameStore> listIterator = this.frameStores.listIterator(n);
        while (listIterator.hasPrevious()) {
            FrameStore frameStore2 = listIterator.previous();
            if (!FrameStoreManager.isEnabled(frameStore2)) continue;
            frameStore = frameStore2;
            break;
        }
        return frameStore;
    }

    private boolean enable(FrameStore frameStore) {
        boolean bl;
        FrameStore frameStore2 = this.getPreceedingEnabledFrameStore(frameStore);
        boolean bl2 = bl = frameStore2 == null ? this.headFrameStore.equals(frameStore) : frameStore2.getDelegate().equals(frameStore);
        if (!bl) {
            this.connect(frameStore2, frameStore);
            frameStore.reinitialize();
        }
        return bl;
    }

    private boolean disable(FrameStore frameStore) {
        boolean bl = FrameStoreManager.isEnabled(frameStore);
        if (bl) {
            FrameStore frameStore2 = this.getPreceedingEnabledFrameStore(frameStore);
            if (frameStore2 == null) {
                this.headFrameStore = frameStore.getDelegate();
                frameStore.setDelegate(null);
            } else {
                this.disconnect(frameStore2, frameStore);
            }
            frameStore.reinitialize();
        }
        return bl;
    }

    public static boolean isEnabled(FrameStore frameStore) {
        return frameStore.getDelegate() != null;
    }

    public void close() {
        this.eventDispatchFrameStore.clearListeners();
        this.closeFrameStores();
        this.frameStores = null;
        this.kb = null;
        this.immutableNamesFrameStore = null;
        this.deleteSimplificationFrameStore = null;
        this.argumentCheckingFrameStore = null;
        this.cachingFrameStore = null;
        this.cleanDispatchFrameStore = null;
        this.eventDispatchFrameStore = null;
        this.eventGeneratorFrameStore = null;
        this.eventSinkFrameStore = null;
        this.facetCheckingFrameStore = null;
        this.journalingFrameStore = null;
        this.modificationRecordFrameStore = null;
        this.readonlyFrameStore = null;
        this.undoFrameStore = null;
        this.changeMonitorFrameStore = null;
        this.traceFrameStore = null;
        this.terminalFrameStore = null;
        this.headFrameStore = null;
    }

    private void closeFrameStores() {
        for (FrameStore frameStore : this.frameStores) {
            frameStore.close();
        }
        this.frameStores.clear();
        this.terminalFrameStore.close();
    }

    public boolean getDispatchEventsEnabled() {
        return FrameStoreManager.isEnabled(this.eventDispatchFrameStore);
    }

    public boolean getGenerateEventsEnabled() {
        if (!this.isMultiUserClient()) {
            return FrameStoreManager.isEnabled(this.eventGeneratorFrameStore);
        }
        return !FrameStoreManager.isEnabled(this.eventSinkFrameStore);
    }

    public boolean getFacetCheckingEnabled() {
        return FrameStoreManager.isEnabled(this.facetCheckingFrameStore);
    }

    public UndoFrameStore getUndoFrameStore() {
        return this.undoFrameStore;
    }

    public void insertFrameStore(FrameStore frameStore, int n) {
        this.frameStores.add(n, frameStore);
        FrameStore frameStore2 = this.getPreceedingEnabledFrameStore(n);
        this.connect(frameStore2, frameStore);
    }

    private void connect(FrameStore frameStore, FrameStore frameStore2) {
        if (frameStore == null) {
            frameStore2.setDelegate(this.headFrameStore);
            this.headFrameStore = frameStore2;
        } else {
            frameStore2.setDelegate(frameStore.getDelegate());
            frameStore.setDelegate(frameStore2);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("connected " + frameStore2);
            this.dumpFrameStores();
        }
    }

    private void disconnect(FrameStore frameStore, FrameStore frameStore2) {
        if (frameStore == null) {
            this.headFrameStore = frameStore2.getDelegate();
        } else {
            frameStore.setDelegate(frameStore2.getDelegate());
        }
        frameStore2.setDelegate(null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("disconnected " + frameStore2);
            this.dumpFrameStores();
        }
    }

    public void removeFrameStore(FrameStore frameStore) {
        int n = this.frameStores.indexOf(frameStore);
        FrameStore frameStore2 = this.getPreceedingEnabledFrameStore(n);
        this.disconnect(frameStore2, frameStore);
        frameStore.close();
        this.frameStores.remove(frameStore);
    }

    public void insertFrameStore(FrameStore frameStore) {
        this.insertFrameStore(frameStore, 0);
    }

    public boolean isUndoEnabled() {
        return FrameStoreManager.isEnabled(this.undoFrameStore);
    }

    public boolean isCallCachingEnabled() {
        return FrameStoreManager.isEnabled(this.cachingFrameStore);
    }

    public boolean setEnabled(FrameStore frameStore, boolean bl) {
        return bl ? this.enable(frameStore) : this.disable(frameStore);
    }

    public boolean setArgumentCheckingEnabled(boolean bl) {
        return this.setEnabled(this.argumentCheckingFrameStore, bl);
    }

    public boolean setCallCachingEnabled(boolean bl) {
        return this.setEnabled(this.cachingFrameStore, bl);
    }

    public boolean setCleanDispatchEnabled(boolean bl) {
        return this.setEnabled(this.cleanDispatchFrameStore, bl);
    }

    public boolean setEventDispatchEnabled(boolean bl) {
        return this.setEnabled(this.eventDispatchFrameStore, bl);
    }

    public boolean setChangeMonitorEnabled(boolean bl) {
        return this.setEnabled(this.changeMonitorFrameStore, bl);
    }

    public boolean setFacetCheckingEnabled(boolean bl) {
        return this.setEnabled(this.facetCheckingFrameStore, bl);
    }

    public boolean setGenerateEventsEnabled(boolean bl) {
        if (!this.isMultiUserClient()) {
            return this.setEnabled(this.eventGeneratorFrameStore, bl);
        }
        return !this.setEnabled(this.eventSinkFrameStore, !bl);
    }

    public boolean setJournalingEnabled(boolean bl) {
        return this.setEnabled(this.journalingFrameStore, bl);
    }

    public boolean isJournalingEnabled() {
        return FrameStoreManager.isEnabled(this.journalingFrameStore);
    }

    public boolean setModificationRecordUpdatingEnabled(boolean bl) {
        return this.setEnabled(this.modificationRecordFrameStore, bl);
    }

    public boolean setUndoEnabled(boolean bl) {
        return this.setEnabled(this.undoFrameStore, bl);
    }

    public void setPollForEvents(boolean bl) {
        this.eventDispatchFrameStore.setPollForEvents(bl);
    }

    public void setDispatchEventsPassThrough(boolean bl) {
        this.eventDispatchFrameStore.setPassThrough(bl);
    }

    public void flushEvents() throws ProtegeException {
        try {
            this.eventDispatchFrameStore.flushEvents();
        }
        catch (InterruptedException interruptedException) {
            throw new ProtegeIOException(interruptedException);
        }
    }

    public void removeListener(Class clazz, Object object, EventListener eventListener) {
        this.eventDispatchFrameStore.removeListener(clazz, object, eventListener);
    }

    public void notifyInstancesOfBrowserTextChange(Cls cls) {
        this.eventDispatchFrameStore.notifyInstancesOfBrowserTextChange(cls);
    }

    public void addListener(Class clazz, Object object, EventListener eventListener) {
        this.eventDispatchFrameStore.addListener(clazz, object, eventListener);
    }

    public List<FrameStore> getFrameStores() {
        return Collections.unmodifiableList(this.frameStores);
    }

    private void createSystemFrameStores() {
        this.immutableNamesFrameStore = this.create(ImmutableNamesFrameStore.class);
        this.deleteSimplificationFrameStore = this.create(DeleteSimplificationFrameStore.class);
        this.argumentCheckingFrameStore = this.create(ArgumentCheckingFrameStore.class);
        this.cachingFrameStore = this.create(CallCachingFrameStore.class);
        this.cleanDispatchFrameStore = this.create(CleanDispatchFrameStore.class);
        this.eventDispatchFrameStore = (EventDispatchFrameStore)this.create(EventDispatchFrameStore.class);
        this.eventGeneratorFrameStore = (EventGeneratorFrameStore)this.create(EventGeneratorFrameStore.class);
        this.eventSinkFrameStore = this.create(EventSinkFrameStore.class);
        this.facetCheckingFrameStore = this.create(FacetCheckingFrameStore.class);
        this.journalingFrameStore = this.create(JournalingFrameStoreHandler.class);
        this.modificationRecordFrameStore = (ModificationRecordFrameStore)this.create(ModificationRecordFrameStore.class);
        this.readonlyFrameStore = this.create(ReadOnlyFrameStoreHandler.class);
        this.undoFrameStore = (UndoFrameStore)this.create(UndoFrameStore.class);
        this.changeMonitorFrameStore = (ChangeMonitorFrameStore)this.create(ChangeMonitorFrameStore.class);
        this.traceFrameStore = this.create(TraceFrameStoreHandler.class);
    }

    public void setTerminalFrameStore(FrameStore frameStore) {
        FrameStore frameStore2 = this.getPreceedingEnabledFrameStore(this.frameStores.size());
        frameStore2.setDelegate(frameStore);
        if (this.terminalFrameStore != frameStore) {
            this.terminalFrameStore.close();
        }
        this.terminalFrameStore = frameStore;
    }

    public void reinitialize() {
        for (FrameStore frameStore : this.frameStores) {
            frameStore.reinitialize();
        }
        this.terminalFrameStore.reinitialize();
    }

    public boolean setCaching(RemoteSession remoteSession, boolean bl) {
        return ((InMemoryFrameStore)this.terminalFrameStore).getHelper().setCaching(remoteSession, bl);
    }

    public FrameStore getTerminalFrameStore() {
        return this.terminalFrameStore;
    }

    public void setAuthor(String string) {
        this.modificationRecordFrameStore.setAuthor(string);
    }

    public void clearAllListeners() {
        this.eventDispatchFrameStore.clearListeners();
    }

    public boolean hasChanged() {
        return this.changeMonitorFrameStore.isChanged();
    }

    public void setChanged(boolean bl) {
        this.changeMonitorFrameStore.setChanged(bl);
    }

    private static InvocationHandler getHandler(FrameStore frameStore) {
        return Proxy.getInvocationHandler(frameStore);
    }

    public void startJournaling(URI uRI) {
        this.setJournalingEnabled(true);
        JournalingFrameStoreHandler journalingFrameStoreHandler = (JournalingFrameStoreHandler)FrameStoreManager.getHandler(this.journalingFrameStore);
        journalingFrameStoreHandler.start(uRI);
    }

    public void stopJournaling() {
        JournalingFrameStoreHandler journalingFrameStoreHandler = (JournalingFrameStoreHandler)FrameStoreManager.getHandler(this.journalingFrameStore);
        journalingFrameStoreHandler.stop();
    }

    public boolean setGenerateDeletingFrameEventsEnabled(boolean bl) {
        return this.eventGeneratorFrameStore.setDeletingFrameEventsEnabled(bl);
    }

    public void dumpFrameStores() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+-+-+-+-+-+-+-+-+-+-+-+-Dumping Frame Stores+-+-+-+-+-+-+-+-+-+-+-+-");
            log.fine("Knowledge base = " + this.kb);
        }
        if (log.isLoggable(Level.FINE)) {
            for (FrameStore frameStore = this.headFrameStore; frameStore != null; frameStore = frameStore.getDelegate()) {
                Class<?> clazz = frameStore.getClass();
                if (Proxy.isProxyClass(clazz)) {
                    clazz = Proxy.getInvocationHandler(frameStore).getClass();
                }
                log.fine("Frame store: " + clazz);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("+-+-+-+-+-+-+-+-+-+-+-+-End Frame Store Dump+-+-+-+-+-+-+-+-+-+-+-+-");
        }
    }
}

