/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import java.util.Collection;

public class ImmutableNamesFrameStore
extends FrameStoreAdapter {
    private KnowledgeBase kb;
    private int nextName;

    public ImmutableNamesFrameStore(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    public FrameID adjustFrameId(FrameID frameID) {
        if (frameID == null || frameID.getName() == null) {
            return new FrameID(this.generateUniqueName("Class"));
        }
        this.checkUniqueness(frameID.getName());
        return frameID;
    }

    protected void checkUniqueness(String string) {
        if (this.getFrame(string) != null) {
            throw new IllegalArgumentException(string + " not unique");
        }
    }

    protected String generateUniqueName(String string) {
        String string2 = null;
        string = this.kb.getName() + "_" + string;
        while (string2 == null) {
            String string3 = string + this.nextName;
            if (this.getFrame(string3) == null) {
                string2 = string3;
                ++this.nextName;
                continue;
            }
            this.nextName += 10000;
        }
        return string2;
    }

    public String getFrameName(Frame frame) {
        return frame.getFrameID().getName();
    }

    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        frameID = this.adjustFrameId(frameID);
        Cls cls = this.getDelegate().createCls(frameID, collection, collection2, bl);
        return cls;
    }

    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        frameID = this.adjustFrameId(frameID);
        Slot slot = this.getDelegate().createSlot(frameID, collection, collection2, bl);
        return slot;
    }

    public Facet createFacet(FrameID frameID, Collection collection, boolean bl) {
        frameID = this.adjustFrameId(frameID);
        Facet facet = this.getDelegate().createFacet(frameID, collection, bl);
        return facet;
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        frameID = this.adjustFrameId(frameID);
        SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(frameID, collection, bl);
        return simpleInstance;
    }
}

