/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;

class MoveDirectSubslotCommand
extends AbstractCommand {
    private Slot slot;
    private int index;
    private Slot subslot;
    private int oldIndex;

    MoveDirectSubslotCommand(FrameStore frameStore, Slot slot, int n, Slot slot2) {
        super(frameStore);
        this.slot = slot;
        this.index = n;
        this.subslot = slot2;
        this.oldIndex = this.getDelegate().getDirectSubslots(slot).indexOf(slot2);
        this.setDescription("Move subslot " + MoveDirectSubslotCommand.getText(slot2) + " of slot " + MoveDirectSubslotCommand.getText(slot) + " to index " + n);
    }

    public Object doIt() {
        this.getDelegate().moveDirectSubslot(this.slot, this.subslot, this.index);
        return null;
    }

    public void undoIt() {
        this.getDelegate().moveDirectSubslot(this.slot, this.subslot, this.oldIndex);
    }

    public void redoIt() {
        this.getDelegate().moveDirectSubslot(this.slot, this.subslot, this.index);
    }
}

