/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.RemoteClientStats;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.socket.SimulateDelayAspect;
import edu.stanford.smi.protege.server.update.DeferredOperationCache;
import edu.stanford.smi.protege.server.update.OntologyUpdate;
import edu.stanford.smi.protege.server.update.RemoteResponse;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheFactory;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheBeginTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheCommitTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheDelete;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheModify;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRollbackTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteClientFrameStore
implements FrameStore {
    private static transient Logger log = Log.getLogger(RemoteClientFrameStore.class);
    private static transient Logger cacheLog = ServerFrameStore.cacheLog;
    private static Method executeProtegeJobMethod;
    private KnowledgeBase kb;
    private ClassLoader kbClassLoader;
    private SystemFrames systemFrames;
    private RemoteSession session;
    private RemoteServer server;
    private RemoteServerFrameStore proxiedDelegate;
    private RemoteServerFrameStore remoteDelegate;
    private final FifoWriter<SerializedCacheUpdate<RemoteSession, Sft, List>> deferredTransactionsWriter = new FifoWriter();
    private final Map<Frame, DeferredOperationCache> cacheMap = new HashMap<Frame, DeferredOperationCache>();
    private TransactionIsolationLevel transactionLevel;
    private int transactionNesting = 0;
    private final Map<String, Frame> frameNameToFrameMap = new HashMap<String, Frame>();
    private final RemoteClientStatsImpl stats = new RemoteClientStatsImpl();
    private Set<Operation> allowedOps;
    private Set<Operation> knownOps;

    public RemoteClientFrameStore(String string, String string2, String string3, String string4, KnowledgeBase knowledgeBase, boolean bl) {
        try {
            this.server = (RemoteServer)Naming.lookup("//" + string + "/" + Server.getBoundName());
            String string5 = SystemUtilities.getMachineIpAddress();
            this.session = this.server.openSession(string2, string5, string3);
            RemoteServerProject remoteServerProject = this.server.openProject(string4, this.session);
            this.remoteDelegate = remoteServerProject.getDomainKbFrameStore(this.session);
            this.kb = knowledgeBase;
            this.initialize(bl);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            log.log(Level.FINE, "Exception caught", exception);
        }
    }

    public RemoteClientFrameStore(RemoteServer remoteServer, RemoteServerFrameStore remoteServerFrameStore, RemoteSession remoteSession, KnowledgeBase knowledgeBase, boolean bl) {
        try {
            this.server = remoteServer;
            this.session = remoteSession;
            this.kb = knowledgeBase;
            this.remoteDelegate = remoteServerFrameStore;
            this.initialize(bl);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
            log.log(Level.FINE, "Exception caught", exception);
        }
    }

    public void initialize(boolean bl) throws RemoteException {
        this.systemFrames = this.kb.getSystemFrames();
        this.kbClassLoader = this.kb.getClass().getClassLoader();
        this.startHeartbeatThread();
        this.preload(bl);
    }

    private static RemoteClientFrameStore getMeFromKb(KnowledgeBase knowledgeBase) {
        if (!(knowledgeBase instanceof DefaultKnowledgeBase)) {
            return null;
        }
        DefaultKnowledgeBase defaultKnowledgeBase = (DefaultKnowledgeBase)knowledgeBase;
        for (FrameStore frameStore = defaultKnowledgeBase.getHeadFrameStore(); frameStore != null; frameStore = frameStore.getDelegate()) {
            if (!(frameStore instanceof RemoteClientFrameStore)) continue;
            return (RemoteClientFrameStore)frameStore;
        }
        return null;
    }

    public static boolean isCached(Frame frame, Slot slot, Facet facet, boolean bl) {
        RemoteClientFrameStore remoteClientFrameStore = RemoteClientFrameStore.getMeFromKb(frame.getKnowledgeBase());
        if (remoteClientFrameStore == null) {
            return true;
        }
        return remoteClientFrameStore.isCachedInternal(frame, slot, facet, bl);
    }

    public static boolean isCacheComplete(Frame frame) {
        RemoteClientFrameStore remoteClientFrameStore = RemoteClientFrameStore.getMeFromKb(frame.getKnowledgeBase());
        if (remoteClientFrameStore == null) {
            return true;
        }
        Cache cache = remoteClientFrameStore.cacheMap.get(frame);
        if (cache == null) {
            return false;
        }
        return cache.isCacheComplete();
    }

    public static RemoteSession getCurrentSession(KnowledgeBase knowledgeBase) {
        FrameStoreManager frameStoreManager = ((DefaultKnowledgeBase)knowledgeBase).getFrameStoreManager();
        RemoteClientFrameStore remoteClientFrameStore = frameStoreManager.getFrameStoreFromClass(RemoteClientFrameStore.class);
        if (remoteClientFrameStore == null) {
            return null;
        }
        return remoteClientFrameStore.getSession();
    }

    private void startHeartbeatThread() {
        if (ServerProperties.heartbeatDisabled()) {
            return;
        }
        new Thread("Heartbeat thread [" + this.kb + "]"){

            public void run() {
                try {
                    while (true) {
                        RemoteServerFrameStore remoteServerFrameStore;
                        if ((remoteServerFrameStore = RemoteClientFrameStore.this.getRemoteDelegate()) != null) {
                            remoteServerFrameStore.heartBeat(RemoteClientFrameStore.this.session);
                        }
                        Thread.sleep(3000L);
                    }
                }
                catch (ServerSessionLost serverSessionLost) {
                    Log.emptyCatchBlock(serverSessionLost);
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.SEVERE, "Heartbeat thread died - can't survive the heart for long...", exception);
                }
            }
        }.start();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public synchronized RemoteServerFrameStore getRemoteDelegate() {
        if (this.proxiedDelegate == null) {
            this.fixLoader();
            InvocationHandler invocationHandler = new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    RemoteClientFrameStore remoteClientFrameStore = RemoteClientFrameStore.this;
                    synchronized (remoteClientFrameStore) {
                        if (!method.equals(executeProtegeJobMethod)) {
                            RemoteClientFrameStore.this.fixLoader();
                        } else {
                            ((ProtegeJob)objectArray[0]).fixLoader();
                        }
                        try {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Remote invoke: " + method.getName() + " Args:");
                                if (objectArray != null) {
                                    for (Object object2 : objectArray) {
                                        log.fine("\t" + (object2 instanceof Frame ? ((Frame)object2).getFrameID() : object2));
                                    }
                                }
                            }
                            long l = System.currentTimeMillis();
                            SimulateDelayAspect.delayForLatency();
                            Object object3 = method.invoke((Object)RemoteClientFrameStore.this.remoteDelegate, objectArray);
                            LocalizeUtils.localize(object3, RemoteClientFrameStore.this.kb);
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Invocation took " + (System.currentTimeMillis() - l) + " ms");
                                RemoteClientFrameStore.this.logSize(log, Level.FINEST, object3);
                            }
                            return object3;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw invocationTargetException.getCause();
                        }
                    }
                }
            };
            this.proxiedDelegate = (RemoteServerFrameStore)Proxy.newProxyInstance(this.kbClassLoader, new Class[]{RemoteServerFrameStore.class}, invocationHandler);
        }
        return this.proxiedDelegate;
    }

    private void logSize(Logger logger, Level level, Object object) {
        if (object instanceof OntologyUpdate) {
            OntologyUpdate ontologyUpdate = (OntologyUpdate)object;
            int n = 0;
            int n2 = 0;
            for (ValueUpdate valueUpdate : ontologyUpdate.getValueUpdates()) {
                n += RemoteClientFrameStore.getSerializedSize(valueUpdate);
                ++n2;
            }
            logger.log(level, "" + n + " bytes of " + n2 + " value updates");
            if (ontologyUpdate instanceof RemoteResponse) {
                logger.log(level, "" + RemoteClientFrameStore.getSerializedSize(((RemoteResponse)ontologyUpdate).getResponse()) + " bytes of included object");
            }
        } else {
            logger.log(level, "" + RemoteClientFrameStore.getSerializedSize(object) + " bytes for object of type " + object.getClass());
        }
    }

    public static int getSerializedSize(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return byteArrayOutputStream.size();
        }
        catch (IOException iOException) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("trouble calculating size");
            }
            return 0;
        }
    }

    public Map<RemoteSession, Boolean> getUserInfo() {
        try {
            return this.getRemoteDelegate().getUserInfo();
        }
        catch (RemoteException remoteException) {
            Log.getLogger().log(Level.WARNING, "Exception caught retrieving user data from remote server", remoteException);
            return new HashMap<RemoteSession, Boolean>();
        }
    }

    public FrameCalculatorStats getServerStats() {
        try {
            return this.getRemoteDelegate().getStats();
        }
        catch (RemoteException remoteException) {
            Log.getLogger().log(Level.INFO, "Remote exception getting server stats", remoteException);
            return null;
        }
    }

    public synchronized RemoteClientStats getClientStats() {
        return this.stats;
    }

    private void fixLoader() {
        ClassLoader classLoader;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 != (classLoader = this.kbClassLoader)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Changing loader from " + classLoader2 + " to " + classLoader);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Override
    public void setDelegate(FrameStore frameStore) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FrameStore getDelegate() {
        return null;
    }

    @Override
    public void reinitialize() {
        this.flushCache();
    }

    private static RuntimeException convertException(Exception exception) {
        return new RuntimeException(exception);
    }

    @Override
    public int getClsCount() {
        try {
            return this.getRemoteDelegate().getClsCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getSlotCount() {
        try {
            return this.getRemoteDelegate().getSlotCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getFacetCount() {
        try {
            return this.getRemoteDelegate().getFacetCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getSimpleInstanceCount() {
        try {
            return this.getRemoteDelegate().getSimpleInstanceCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getFrameCount() {
        try {
            return this.getRemoteDelegate().getFrameCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Cls> getClses() {
        try {
            Set<Cls> set = this.getRemoteDelegate().getClses(this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Slot> getSlots() {
        Cls cls = this.getSystemFrames().getRootSlotMetaCls();
        return this.getInstances(cls);
    }

    @Override
    public Set<Facet> getFacets() {
        try {
            Set<Facet> set = this.getRemoteDelegate().getFacets(this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Frame> getFrames() {
        try {
            Set<Frame> set = this.getRemoteDelegate().getFrames(this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        try {
            Frame frame = this.getRemoteDelegate().getFrame(frameID, this.session);
            return frame;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Frame getFrame(String string) {
        try {
            boolean bl = true;
            Frame frame = this.frameNameToFrameMap.get(string);
            if (frame == null) {
                bl = this.frameNameToFrameMap.containsKey(string);
            } else if (!this.isCachedInternal(frame, this.systemFrames.getNameSlot(), null, false)) {
                frame = null;
                this.frameNameToFrameMap.remove(string);
                bl = false;
            }
            if (frame == null && !bl) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Cache miss for frame named " + string);
                }
                RemoteResponse<Frame> remoteResponse = this.getRemoteDelegate().getFrame(string, this.session);
                this.processValueUpdate(remoteResponse);
                frame = remoteResponse.getResponse();
            }
            if (this.transactionNesting == 0) {
                this.frameNameToFrameMap.put(string, frame);
            }
            return frame;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized String getFrameName(Frame frame) {
        try {
            List list = this.getCacheDirectOwnSlotValues(frame, this.getSystemFrames().getNameSlot());
            return (String)CollectionUtilities.getFirstItem(list);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        try {
            RemoteResponse<Cls> remoteResponse = this.getRemoteDelegate().createCls(frameID, collection, collection2, bl, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        try {
            RemoteResponse<Slot> remoteResponse = this.getRemoteDelegate().createSlot(frameID, collection, collection2, bl, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Facet createFacet(FrameID frameID, Collection collection, boolean bl) {
        try {
            RemoteResponse<Facet> remoteResponse = this.getRemoteDelegate().createFacet(frameID, collection, bl, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        try {
            RemoteResponse<SimpleInstance> remoteResponse = this.getRemoteDelegate().createSimpleInstance(frameID, collection, bl, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void deleteCls(Cls cls) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().deleteCls(cls, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void deleteSlot(Slot slot) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().deleteSlot(slot, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void deleteFacet(Facet facet) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().deleteFacet(facet, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void deleteSimpleInstance(SimpleInstance simpleInstance) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().deleteSimpleInstance(simpleInstance, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set<Slot> getOwnSlots(Frame frame) {
        return this.getCacheOwnSlots(frame);
    }

    @Override
    public synchronized Collection getOwnSlotValues(Frame frame, Slot slot) {
        return this.getCacheOwnSlotValues(frame, slot);
    }

    @Override
    public synchronized List getDirectOwnSlotValues(Frame frame, Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(frame, slot);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(frame, slot).size();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectOwnSlotValue(frame, slot, n, n2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().setDirectOwnSlotValues(frame, slot, collection, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getOwnFacets(Frame frame, Slot slot) {
        return this.getCacheOwnFacets(frame, slot);
    }

    @Override
    public synchronized Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getCacheOwnFacetValues(frame, slot, facet);
    }

    @Override
    public synchronized Set getTemplateSlots(Cls cls) {
        return this.getCacheTemplateSlots(cls);
    }

    @Override
    public synchronized List getDirectTemplateSlots(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectTemplateSlotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List getDirectDomain(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectDomainSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getDomain(Slot slot) {
        try {
            return this.getCacheDomain(slot);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getOverriddenTemplateSlots(Cls cls) {
        try {
            Set set = this.getRemoteDelegate().getOverriddenTemplateSlots(cls, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls) {
        try {
            Set set = this.getRemoteDelegate().getDirectlyOverriddenTemplateSlots(cls, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void addDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().addDirectTemplateSlot(cls, slot, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectTemplateSlot(cls, slot, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectTemplateSlot(cls, slot, n, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return this.getCacheTemplateSlotValues(cls, slot);
    }

    @Override
    public synchronized List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        try {
            return this.getCacheValues(cls, slot, this.getSystemFrames().getValuesFacet(), true);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().setDirectTemplateSlotValues(cls, slot, collection, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot) {
        try {
            Set<Facet> set = this.getRemoteDelegate().getTemplateFacets(cls, slot, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getOverriddenTemplateFacets(cls, slot, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getDirectlyOverriddenTemplateFacets(cls, slot, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectTemplateFacetOverrides(cls, slot, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getCacheTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public synchronized List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        try {
            return this.getCacheValues(cls, slot, facet, true);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List<Cls> getDirectSuperclasses(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getSuperclasses(Cls cls) {
        try {
            return this.getCacheOwnSlotValueClosure(cls, this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    private SystemFrames getSystemFrames() {
        return this.systemFrames;
    }

    @Override
    public synchronized List<Cls> getDirectSubclasses(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectSubclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set<Cls> getSubclasses(Cls cls) {
        try {
            return this.getCacheOwnSlotValueClosure(cls, this.getSystemFrames().getDirectSubclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void addDirectSuperclass(Cls cls, Cls cls2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().addDirectSuperclass(cls, cls2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectSuperclass(Cls cls, Cls cls2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectSuperclass(cls, cls2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectSubclass(cls, cls2, n, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List getDirectSuperslots(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectSuperslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getSuperslots(Slot slot) {
        try {
            return this.getCacheOwnSlotValueClosure(slot, this.getSystemFrames().getDirectSuperslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List getDirectSubslots(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectSubslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getSubslots(Slot slot) {
        try {
            return this.getCacheOwnSlotValueClosure(slot, this.getSystemFrames().getDirectSubslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void addDirectSuperslot(Slot slot, Slot slot2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().addDirectSuperslot(slot, slot2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectSuperslot(Slot slot, Slot slot2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectSuperslot(slot, slot2, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectSubslot(slot, slot2, n, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List getDirectTypes(Instance instance) {
        try {
            return this.getCacheDirectOwnSlotValues(instance, this.getSystemFrames().getDirectTypesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getTypes(Instance instance) {
        try {
            return this.getCacheOwnSlotValueClosure(this.getDirectTypes(instance), this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List<Instance> getDirectInstances(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectInstancesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set<Instance> getInstances(Cls cls) {
        RemoteResponse<Set<Instance>> remoteResponse;
        HashSet<Cls> hashSet = new HashSet<Cls>();
        hashSet.addAll(this.getSubclasses(cls));
        hashSet.add(cls);
        HashSet<Instance> hashSet2 = new HashSet<Instance>();
        HashSet<Cls> hashSet3 = new HashSet<Cls>();
        for (Cls cls2 : hashSet) {
            if (this.isCachedInternal(cls2, this.getSystemFrames().getDirectInstancesSlot(), null, false)) {
                hashSet2.addAll(this.getDirectInstances(cls2));
                continue;
            }
            hashSet3.add(cls2);
        }
        if (hashSet3.isEmpty()) {
            return hashSet2;
        }
        if (hashSet3.size() == 1) {
            remoteResponse = (Cls)hashSet3.iterator().next();
            hashSet2.addAll(this.getDirectInstances((Cls)((Object)remoteResponse)));
            return hashSet2;
        }
        try {
            remoteResponse = this.getRemoteDelegate().getInstances(cls, this.session);
            this.processValueUpdate(remoteResponse);
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void addDirectType(Instance instance, Cls cls) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().addDirectType(instance, cls, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void removeDirectType(Instance instance, Cls cls) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().removeDirectType(instance, cls, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized void moveDirectType(Instance instance, Cls cls, int n) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().moveDirectType(instance, cls, n, this.session);
            this.processValueUpdate(ontologyUpdate);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized List<AbstractEvent> getEvents() {
        if (this.transactionNesting > 0) {
            return new ArrayList<AbstractEvent>();
        }
        List<AbstractEvent> list = null;
        try {
            RemoteResponse<List<AbstractEvent>> remoteResponse = this.getRemoteDelegate().getEvents(this.session);
            this.processValueUpdate(remoteResponse);
            list = remoteResponse.getResponse();
            return list;
        }
        catch (RemoteException remoteException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught - local cache may be out of date", remoteException);
            throw new RuntimeException(remoteException);
        }
    }

    @Override
    public void executeQuery(final Query query, final QueryCallback queryCallback) {
        new Thread("Remote Client Callback thread"){

            public void run() {
                try {
                    RemoteResponse<Collection<Frame>> remoteResponse = RemoteClientFrameStore.this.getRemoteDelegate().executeQuery(query, RemoteClientFrameStore.this.session);
                    RemoteClientFrameStore.this.processValueUpdate(remoteResponse);
                    queryCallback.provideQueryResults(remoteResponse.getResponse());
                }
                catch (OntologyException ontologyException) {
                    queryCallback.handleError(ontologyException);
                }
                catch (ProtegeIOException protegeIOException) {
                    queryCallback.handleError(protegeIOException);
                }
                catch (RemoteException remoteException) {
                    Log.getLogger().log(Level.WARNING, "Exception accessing remote host", remoteException);
                    queryCallback.handleError(new ProtegeIOException(remoteException));
                }
                catch (ProtegeError protegeError) {
                    queryCallback.handleError(protegeError);
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.WARNING, "Developer error", throwable);
                    queryCallback.handleError(new ProtegeError(throwable));
                }
            }
        }.start();
    }

    @Override
    public synchronized Set<Reference> getReferences(Object object) {
        try {
            Set<Reference> set = this.getRemoteDelegate().getReferences(object, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Cls> getClsesWithMatchingBrowserText(String string, Collection collection, int n) {
        try {
            Set<Cls> set = this.getRemoteDelegate().getClsesWithMatchingBrowserText(string, collection, n, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        try {
            Set<Reference> set = this.getRemoteDelegate().getMatchingReferences(string, n, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Frame> getFramesWithDirectOwnSlotValue(Slot slot, Object object) {
        try {
            Set<Frame> set = this.getRemoteDelegate().getFramesWithDirectOwnSlotValue(slot, object, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Frame> getFramesWithAnyDirectOwnSlotValue(Slot slot) {
        try {
            Set<Frame> set = this.getRemoteDelegate().getFramesWithAnyDirectOwnSlotValue(slot, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        try {
            Set<Frame> set = this.getRemoteDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, string, n, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object object) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithDirectTemplateSlotValue(slot, object, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set<Cls> getClsesWithAnyDirectTemplateSlotValue(Slot slot) {
        try {
            Set<Cls> set = this.getRemoteDelegate().getClsesWithAnyDirectTemplateSlotValue(slot, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, string, n, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object object) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, object, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, string, n, this.session);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        try {
            return this.getCacheClosure(frame, slot);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized boolean beginTransaction(String string) {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Begin Transaction");
        }
        try {
            RemoteResponse<Boolean> remoteResponse = this.getRemoteDelegate().beginTransaction(string, this.session);
            this.processValueUpdate(remoteResponse);
            ++this.transactionNesting;
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized boolean commitTransaction() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Commit Transaction");
        }
        try {
            RemoteResponse<Boolean> remoteResponse = this.getRemoteDelegate().commitTransaction(this.session);
            this.processValueUpdate(remoteResponse);
            --this.transactionNesting;
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public synchronized boolean rollbackTransaction() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Rollback Transaction");
        }
        try {
            RemoteResponse<Boolean> remoteResponse = this.getRemoteDelegate().rollbackTransaction(this.session);
            this.processValueUpdate(remoteResponse);
            --this.transactionNesting;
            return remoteResponse.getResponse();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        throw new UnsupportedOperationException("Shouldn't be doing this on the client side");
    }

    public static TransactionIsolationLevel getTransactionIsolationLevel(KnowledgeBase knowledgeBase) throws TransactionException {
        RemoteClientFrameStore remoteClientFrameStore = RemoteClientFrameStore.getMeFromKb(knowledgeBase);
        if (remoteClientFrameStore == null) {
            return TransactionIsolationLevel.NONE;
        }
        return remoteClientFrameStore.getTransactionIsolationLevel();
    }

    public synchronized TransactionIsolationLevel getTransactionIsolationLevel() throws TransactionException {
        if (this.transactionLevel != null) {
            return this.transactionLevel;
        }
        try {
            this.transactionLevel = this.getRemoteDelegate().getTransactionIsolationLevel();
            return this.transactionLevel;
        }
        catch (RemoteException remoteException) {
            throw new TransactionException(remoteException);
        }
    }

    public static boolean setTransactionIsolationLevel(KnowledgeBase knowledgeBase, TransactionIsolationLevel transactionIsolationLevel) throws TransactionException {
        RemoteClientFrameStore remoteClientFrameStore = RemoteClientFrameStore.getMeFromKb(knowledgeBase);
        if (remoteClientFrameStore == null) {
            return false;
        }
        return remoteClientFrameStore.setTransactionIsolationLevel(transactionIsolationLevel);
    }

    public synchronized boolean setTransactionIsolationLevel(TransactionIsolationLevel transactionIsolationLevel) throws TransactionException {
        try {
            this.transactionLevel = null;
            return this.getRemoteDelegate().setTransactionIsolationLevel(transactionIsolationLevel);
        }
        catch (RemoteException remoteException) {
            throw new TransactionException(remoteException);
        }
    }

    @Override
    public synchronized void close() {
        try {
            if (this.server != null) {
                this.server.closeSession(this.session);
                this.server = null;
            }
            this.remoteDelegate = null;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    public synchronized void preload(boolean bl) throws RemoteException {
        boolean bl2 = ServerProperties.skipPreload();
        if (bl2) {
            return;
        }
        Log.getLogger().config("Preloading frame values: " + this.kb);
        Set<String> set = ServerProperties.preloadUserFrames();
        OntologyUpdate ontologyUpdate = this.getRemoteDelegate().preload(set, bl, this.session);
        this.processValueUpdate(ontologyUpdate);
    }

    private Set getCacheOwnSlotValueClosure(Frame frame, Slot slot) throws RemoteException {
        return this.getCacheClosure(frame, slot);
    }

    private Set getCacheOwnSlotValueClosure(Collection<Frame> collection, Slot slot) throws RemoteException {
        return this.getCacheClosure(collection, slot);
    }

    private Set getCacheClosure(Frame frame, Slot slot) throws RemoteException {
        Set set = new LinkedHashSet();
        HashSet<Frame> hashSet = new HashSet<Frame>();
        this.calculateClosureFromCacheOnly(frame, slot, set, hashSet);
        if (!hashSet.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("not in closure cache: " + frame.getFrameID() + ", " + slot.getFrameID());
            }
            ++this.stats.closureMiss;
            RemoteResponse<Set> remoteResponse = this.getRemoteDelegate().getDirectOwnSlotValuesClosure(frame, slot, hashSet, this.session);
            this.processValueUpdate(remoteResponse);
            set = remoteResponse.getResponse();
            if (log.isLoggable(Level.FINE)) {
                for (Object e : set) {
                    if (e instanceof Frame) {
                        log.fine("\t closure frame = " + ((Frame)e).getFrameID());
                        continue;
                    }
                    log.fine("other closure " + e);
                }
            }
        } else {
            ++this.stats.closureHit;
        }
        return set;
    }

    private void calculateClosureFromCacheOnly(Frame frame, Slot slot, Set set, Set<Frame> set2) throws RemoteException {
        if (this.isCachedInternal(frame, slot, null, false)) {
            List list = this.getCacheValues(frame, slot, null, false);
            for (Object e : list) {
                boolean bl = set.add(e);
                if (!bl || !(e instanceof Frame)) continue;
                this.calculateClosureFromCacheOnly((Frame)e, slot, set, set2);
            }
        } else {
            set2.add(frame);
        }
    }

    private Set getCacheClosure(Collection<Frame> collection, Slot slot) throws RemoteException {
        Set<Frame> set = new LinkedHashSet<Frame>(collection);
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (Frame frame : collection) {
            this.calculateClosureFromCacheOnly(frame, slot, set, hashSet);
        }
        if (!hashSet.isEmpty()) {
            ++this.stats.closureMiss;
            RemoteResponse<Set> remoteResponse = this.getRemoteDelegate().getDirectOwnSlotValuesClosure(collection, slot, hashSet, this.session);
            this.processValueUpdate(remoteResponse);
            set = (Set)remoteResponse.getResponse();
            set.addAll(collection);
            return set;
        }
        ++this.stats.closureHit;
        return set;
    }

    private List getCacheDirectOwnSlotValues(Frame frame, Slot slot) throws RemoteException {
        return this.getCacheValues(frame, slot, null, false);
    }

    public Collection getCacheOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        Collection collection = new ArrayList();
        for (Cls cls : this.getDirectTypes((Instance)frame)) {
            Collection collection2 = this.getTemplateFacetValues(cls, slot, facet);
            collection = RemoteClientFrameStore.resolveValues(collection, collection2, facet);
        }
        return collection;
    }

    private Collection getCacheTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        List list;
        Instance instance2;
        Collection collection = new ArrayList(this.getDirectTemplateFacetValues(cls, slot, facet));
        for (Instance instance2 : this.getSuperclasses(cls)) {
            list = this.getDirectTemplateFacetValues((Cls)instance2, slot, facet);
            collection = RemoteClientFrameStore.resolveValues(collection, list, facet);
        }
        instance2 = (Slot)this.getDirectOwnSlotValue(facet, this.getSystemFrames().getAssociatedSlotSlot());
        if (instance2 != null) {
            list = this.getDirectOwnSlotValues(slot, (Slot)instance2);
            collection = RemoteClientFrameStore.resolveValues(collection, list, facet);
        }
        return collection;
    }

    private Object getDirectOwnSlotValue(Frame frame, Slot slot) {
        List list = this.getDirectOwnSlotValues(frame, slot);
        return CollectionUtilities.getFirstItem(list);
    }

    private static Collection resolveValues(Collection arrayList, Collection collection, Facet facet) {
        if (!collection.isEmpty()) {
            if (arrayList.isEmpty()) {
                arrayList.addAll(collection);
            } else if ((arrayList = facet.resolveValues(arrayList, collection)) == collection) {
                arrayList = new ArrayList(arrayList);
            }
        }
        return arrayList;
    }

    public Collection getCacheOwnSlotValues(Frame frame, Slot slot) {
        ArrayList arrayList = new ArrayList();
        this.addOwnSlotValues(frame, slot, arrayList);
        return arrayList;
    }

    private void addOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        collection.addAll(this.getDirectOwnSlotValues(frame, slot));
        this.addInheritedTemplateSlotValues(frame, slot, collection);
        this.addSubslotValues(frame, slot, collection);
        if (frame instanceof Slot && collection.isEmpty() && this.isInheritedSuperslotSlot(slot)) {
            this.addInheritedSuperslotValues((Slot)frame, slot, collection);
        }
    }

    private boolean isInheritedSuperslotSlot(Slot slot) {
        return slot.equals(this.getSystemFrames().getDirectDomainSlot()) || slot.equals(this.getSystemFrames().getValueTypeSlot()) || slot.equals(this.getSystemFrames().getMaximumCardinalitySlot()) || slot.equals(this.getSystemFrames().getMinimumValueSlot()) || slot.equals(this.getSystemFrames().getMaximumValueSlot());
    }

    private void addInheritedSuperslotValues(Slot slot, Slot slot2, Collection collection) {
        Facet facet = (Facet)this.getDirectOwnSlotValue(slot2, this.getSystemFrames().getAssociatedFacetSlot());
        for (Slot slot3 : this.getSuperslots(slot)) {
            List list = this.getDirectOwnSlotValues(slot3, slot2);
            if (facet == null) {
                collection.addAll(list);
                continue;
            }
            Collection collection2 = facet.resolveValues(collection, list);
            if (((Object)collection2).equals(collection)) continue;
            collection.clear();
            collection.addAll(collection2);
        }
    }

    private void addInheritedTemplateSlotValues(Frame frame, Slot slot, Collection collection) {
        if (frame instanceof Instance) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Instance instance = (Instance)frame;
            for (Cls cls : this.getTypes(instance)) {
                linkedHashSet.addAll(this.getDirectTemplateSlotValues(cls, slot));
            }
            collection.addAll(linkedHashSet);
        }
    }

    private void addSubslotValues(Frame frame, Slot slot, Collection collection) {
        for (Slot slot2 : this.getSubslots(slot)) {
            collection.addAll(this.getDirectOwnSlotValues(frame, slot2));
        }
    }

    private Set getCacheOwnFacets(Frame frame, Slot slot) {
        HashSet<Facet> hashSet = new HashSet<Facet>();
        for (Slot slot2 : this.getOwnSlots(slot)) {
            Facet facet = (Facet)this.getDirectOwnSlotValue(slot2, this.getSystemFrames().getAssociatedFacetSlot());
            if (facet == null) continue;
            hashSet.add(facet);
        }
        return hashSet;
    }

    private Collection getCacheTemplateSlotValues(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this.getSystemFrames().getValuesFacet());
    }

    private Set<Slot> getCacheOwnSlots(Frame frame) {
        Set set = this.getTypes((Instance)frame);
        Set<Slot> set2 = this.collectOwnSlotValues(set, this.getSystemFrames().getDirectTemplateSlotsSlot());
        set2.add(this.getSystemFrames().getNameSlot());
        set2.add(this.getSystemFrames().getDirectTypesSlot());
        return set2;
    }

    private Set<Slot> collectOwnSlotValues(Collection collection, Slot slot) {
        LinkedHashSet<Slot> linkedHashSet = new LinkedHashSet<Slot>();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Frame frame = (Frame)objectArray[i];
            linkedHashSet.addAll(this.getDirectOwnSlotValues(frame, slot));
        }
        return linkedHashSet;
    }

    private Set getCacheTemplateSlots(Cls cls) {
        LinkedHashSet<Cls> linkedHashSet = new LinkedHashSet<Cls>(this.getSuperclasses(cls));
        linkedHashSet.add(cls);
        Set<Slot> set = this.collectOwnSlotValues(linkedHashSet, this.getSystemFrames().getDirectTemplateSlotsSlot());
        return set;
    }

    private Set getCacheDomain(Slot slot) throws RemoteException {
        return this.getCacheOwnSlotValueClosure(this.getDirectDomain(slot), this.getSystemFrames().getDirectSubclassesSlot());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getCacheValues(Frame frame, Slot slot, Facet facet, boolean bl) throws RemoteException {
        void var5_10;
        void var5_8;
        Object var5_5 = null;
        CacheResult<List> cacheResult = this.readCache(frame, slot, facet, bl);
        if (cacheResult.isValid()) {
            List list = cacheResult.getResult();
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("cache miss for frame " + frame.getFrameID() + " slot " + slot.getFrameID() + (facet == null ? "null" : "" + facet.getFrameID()) + " template " + bl);
            }
            RemoteResponse<List> remoteResponse = null;
            if (facet != null) {
                if (!bl) throw new UnsupportedOperationException("We don't cache this information...");
                remoteResponse = this.getRemoteDelegate().getDirectTemplateFacetValues((Cls)frame, slot, facet, this.session);
            } else {
                remoteResponse = bl ? this.getRemoteDelegate().getDirectTemplateSlotValues((Cls)frame, slot, this.session) : this.getRemoteDelegate().getDirectOwnSlotValues(frame, slot, this.session);
            }
            this.processValueUpdate(remoteResponse);
            List list = remoteResponse.getResponse();
        }
        if (var5_8 != null) return var5_10;
        ArrayList arrayList = new ArrayList();
        return var5_10;
    }

    private boolean isCachedInternal(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this.readCache(frame, slot, facet, bl).isValid();
    }

    private CacheResult<List> readCache(Frame frame, Slot slot, Facet facet, boolean bl) {
        CacheResult<List> cacheResult;
        Cache cache = this.cacheMap.get(frame);
        if (cacheLog.isLoggable(Level.FINEST) && cache != null) {
            cacheLog.finest("Using cache " + cache.getCacheId() + " for " + frame.getFrameID().getName());
        }
        if (cache == null) {
            cacheResult = CacheResult.getInvalid();
        } else if (cache.isInvalid()) {
            if (cacheLog.isLoggable(Level.FINEST)) {
                cacheLog.finest("Cache is deleted");
            }
            this.cacheMap.remove(frame);
            cache = null;
            cacheResult = CacheResult.getInvalid();
        } else {
            cacheResult = cache.readCache(this.session, new Sft(slot, facet, bl));
        }
        if (cacheLog.isLoggable(Level.FINEST)) {
            cacheLog.finest("Cache Result for " + frame.getFrameID().getName() + ", " + slot.getFrameID().getName() + ", " + (facet == null ? "null" : facet.getFrameID().getName()) + ", " + bl + " returns = " + cacheResult);
        }
        if (cacheResult.isValid()) {
            ++this.stats.hit;
        } else {
            ++this.stats.miss;
        }
        return cacheResult;
    }

    private void processValueUpdate(OntologyUpdate ontologyUpdate) {
        if (cacheLog.isLoggable(Level.FINE) && ontologyUpdate.getValueUpdates().size() != 0) {
            cacheLog.fine("received " + ontologyUpdate.getValueUpdates().size() + " value updates for Knowledge base " + this.kb);
        }
        FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>> fifoReader = new FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>>(this.deferredTransactionsWriter);
        for (ValueUpdate valueUpdate : ontologyUpdate.getValueUpdates()) {
            SerializedCacheUpdate<RemoteSession, Sft, List> serializedCacheUpdate;
            if (cacheLog.isLoggable(Level.FINER)) {
                cacheLog.finer("processing " + valueUpdate);
            }
            if ((serializedCacheUpdate = valueUpdate.getUpdate()) instanceof CacheBeginTransaction || serializedCacheUpdate instanceof CacheCommitTransaction || serializedCacheUpdate instanceof CacheRollbackTransaction) {
                this.deferredTransactionsWriter.write(serializedCacheUpdate);
                continue;
            }
            Frame frame = valueUpdate.getFrame();
            if (frame == null && serializedCacheUpdate instanceof CacheDelete) {
                this.deferredTransactionsWriter.write(serializedCacheUpdate);
                continue;
            }
            if (this.frameNameToFrameMap.get(frame.getName()) == null || serializedCacheUpdate instanceof CacheDelete || serializedCacheUpdate instanceof CacheModify) {
                this.frameNameToFrameMap.remove(frame.getName());
            }
            try {
                DeferredOperationCache deferredOperationCache = this.cacheMap.get(frame);
                if (deferredOperationCache != null && deferredOperationCache.isInvalid()) {
                    deferredOperationCache = null;
                    this.cacheMap.remove(frame);
                }
                if (deferredOperationCache == null) {
                    deferredOperationCache = CacheFactory.createEmptyCache(this.getTransactionIsolationLevel());
                    FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>> fifoReader2 = new FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>>(fifoReader);
                    deferredOperationCache = new DeferredOperationCache(deferredOperationCache, fifoReader2);
                    this.cacheMap.put(frame, deferredOperationCache);
                    if (cacheLog.isLoggable(Level.FINEST)) {
                        cacheLog.finest("Created cache " + deferredOperationCache.getCacheId() + " for frame " + frame.getFrameID().getName());
                    }
                }
                serializedCacheUpdate.performUpdate(deferredOperationCache);
            }
            catch (Throwable throwable) {
                this.cacheMap.remove(frame);
                log.log(Level.WARNING, "Exception caught processing cache for " + frame.getFrameID().getName(), throwable);
            }
        }
    }

    public synchronized void flushCache() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Flushing client cache");
        }
        this.frameNameToFrameMap.clear();
        for (DeferredOperationCache deferredOperationCache : this.cacheMap.values()) {
            deferredOperationCache.flush();
        }
    }

    public Object executeProtegeJob(ProtegeJob protegeJob) throws ProtegeException {
        try {
            Object object = this.getRemoteDelegate().executeProtegeJob(protegeJob, this.session);
            LocalizeUtils.localize(object, this.kb);
            return object;
        }
        catch (RemoteException remoteException) {
            throw new ProtegeIOException(remoteException);
        }
    }

    public Set<Operation> getAllowedOperations() throws ProtegeIOException {
        if (this.allowedOps == null) {
            try {
                this.allowedOps = this.getRemoteDelegate().getAllowedOperations(this.session);
            }
            catch (RemoteException remoteException) {
                throw new ProtegeIOException(remoteException);
            }
        }
        return this.allowedOps;
    }

    public Set<Operation> getKnownOperations() throws ProtegeIOException {
        if (this.knownOps == null) {
            try {
                this.knownOps = this.getRemoteDelegate().getKnownOperations(this.session);
            }
            catch (RemoteException remoteException) {
                throw new ProtegeIOException(remoteException);
            }
        }
        return this.knownOps;
    }

    public static boolean isOperationAllowed(KnowledgeBase knowledgeBase, Operation operation) throws ProtegeIOException {
        DefaultKnowledgeBase defaultKnowledgeBase = (DefaultKnowledgeBase)knowledgeBase;
        FrameStore frameStore = defaultKnowledgeBase.getTerminalFrameStore();
        if (!(frameStore instanceof RemoteClientFrameStore)) {
            return true;
        }
        RemoteClientFrameStore remoteClientFrameStore = (RemoteClientFrameStore)frameStore;
        return !remoteClientFrameStore.getKnownOperations().contains(operation) || remoteClientFrameStore.getAllowedOperations().contains(operation);
    }

    public RemoteServer getRemoteServer() {
        return this.server;
    }

    public RemoteSession getSession() {
        return this.session;
    }

    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        try {
            OntologyUpdate ontologyUpdate = this.getRemoteDelegate().replaceFrame(frame, frame2, this.session);
            this.processValueUpdate(ontologyUpdate);
            DeferredOperationCache deferredOperationCache = this.cacheMap.get(frame2);
            if (deferredOperationCache != null) {
                deferredOperationCache.invalidate(this.session);
            }
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    static {
        try {
            executeProtegeJobMethod = RemoteServerFrameStore.class.getDeclaredMethod("executeProtegeJob", ProtegeJob.class, RemoteSession.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.getLogger().log(Level.SEVERE, "No such method ", noSuchMethodException);
        }
    }

    public class RemoteClientStatsImpl
    implements RemoteClientStats {
        int miss = 0;
        int hit = 0;
        int closureMiss = 0;
        int closureHit = 0;

        public int getCacheHits() {
            return this.hit;
        }

        public int getCacheMisses() {
            return this.miss;
        }

        public int getClosureCacheHits() {
            return this.closureHit;
        }

        public int getClosureCacheMisses() {
            return this.closureMiss;
        }
    }
}

