/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.job;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.util.ProtegeJob;

public class CacheControlJob
extends ProtegeJob {
    private static final long serialVersionUID = 8617813426801936579L;
    private final boolean disableFrameCalculator;
    private final boolean disableDatabaseCache;

    public CacheControlJob(KnowledgeBase knowledgeBase, boolean bl, boolean bl2) {
        super(knowledgeBase);
        this.disableFrameCalculator = bl;
        this.disableDatabaseCache = bl2;
    }

    public static void setCacheStatus(KnowledgeBase knowledgeBase, boolean bl, boolean bl2) {
        new CacheControlJob(knowledgeBase, bl, bl2).execute();
    }

    public Object run() throws ProtegeException {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this.getKnowledgeBase().getFrameStoreManager().setCaching(remoteSession, !this.disableDatabaseCache);
        if (this.getKnowledgeBase().getProject().isMultiUserServer()) {
            ServerProject serverProject = Server.getInstance().getServerProject(this.getKnowledgeBase().getProject());
            FrameCalculator frameCalculator = ((ServerFrameStore)serverProject.getDomainKbFrameStore(remoteSession)).getFrameCalculator();
            frameCalculator.setDisabled(this.disableFrameCalculator, remoteSession);
        }
        return true;
    }
}

