/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.FrameTreeFinder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClsTreeFinder
extends FrameTreeFinder {
    private static final long serialVersionUID = 4059780789067261580L;

    public ClsTreeFinder(KnowledgeBase knowledgeBase, JTree jTree) {
        this(knowledgeBase, jTree, ResourceKey.CLASS_SEARCH_FOR);
    }

    public ClsTreeFinder(KnowledgeBase knowledgeBase, JTree jTree, ResourceKey resourceKey) {
        super(knowledgeBase, jTree, resourceKey);
    }

    public ClsTreeFinder(KnowledgeBase knowledgeBase, JTree jTree, String string) {
        this(knowledgeBase, jTree, string, Icons.getFindClsIcon());
    }

    public ClsTreeFinder(KnowledgeBase knowledgeBase, JTree jTree, String string, Icon icon) {
        super(knowledgeBase, jTree, string, icon);
    }

    @Override
    protected Collection getParents(Frame frame) {
        return ((Cls)frame).getDirectSuperclasses();
    }

    @Override
    protected Collection getAncestors(Frame frame) {
        return ((Cls)frame).getSuperclasses();
    }

    @Override
    protected boolean isCorrectType(Frame frame) {
        return frame instanceof Cls;
    }

    @Override
    protected Slot getBrowserSlot(KnowledgeBase knowledgeBase) {
        Cls cls = knowledgeBase.getDefaultClsMetaCls();
        Slot slot = cls == null ? knowledgeBase.getNameSlot() : cls.getBrowserSlotPattern().getFirstSlot();
        return slot;
    }

    @Override
    protected Set<Frame> getMatchingFrames(String string, int n) {
        if (!string.endsWith("*")) {
            string = string + '*';
        }
        return new HashSet<Frame>(this.getKnowledgeBase().getClsesWithMatchingBrowserText(string, Collections.EMPTY_LIST, n));
    }
}

