/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.RedoAction;
import edu.stanford.smi.protege.action.UndoAction;
import edu.stanford.smi.protege.model.CommandManager;
import edu.stanford.smi.protege.model.framestore.undo.Command;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SimpleListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CommandHistoryPanel
extends JPanel
implements Disposable {
    private static final long serialVersionUID = -5242899916645126654L;
    private static final String LINE = "------------------------------";
    private static final String INSERT_POINT = "------------------------------ Current Command Position ------------------------------";
    private CommandManager _manager;
    private JList _list;
    private JButton _undoButton;
    private JButton _redoButton;
    private ChangeListener _changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            CommandHistoryPanel.this.updateModel();
        }
    };

    public CommandHistoryPanel(CommandManager commandManager) {
        this._manager = commandManager;
        this._manager.addChangeListener(this._changeListener);
        this._list = CommandHistoryPanel.createList();
        this._list.setCellRenderer(new CommandRenderer());
        this._undoButton = CommandHistoryPanel.createUndoButton();
        this._redoButton = CommandHistoryPanel.createRedoButton();
        this.layoutWidgets();
        this.setPreferredSize(new Dimension(800, 400));
        this.updateModel();
    }

    public void dispose() {
        this._manager.removeChangeListener(this._changeListener);
    }

    private static JList createList() {
        return ComponentFactory.createList(null);
    }

    private static JButton createRedoButton() {
        JButton jButton = ComponentFactory.createButton(new RedoAction(true));
        jButton.setText("Redo");
        return jButton;
    }

    private static JButton createUndoButton() {
        JButton jButton = ComponentFactory.createButton(new UndoAction(true));
        jButton.setText("Undo");
        return jButton;
    }

    public String getTitle() {
        return "Command History";
    }

    private void layoutWidgets() {
        JPanel jPanel = ComponentFactory.createPanel();
        jPanel.setLayout(new GridLayout(1, 2, 10, 10));
        jPanel.add(this._undoButton);
        jPanel.add(this._redoButton);
        JPanel jPanel2 = ComponentFactory.createPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(jPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)ComponentFactory.createScrollPane(this._list), "Center");
        this.add((Component)jPanel2, "South");
    }

    private void updateModel() {
        SimpleListModel simpleListModel = new SimpleListModel();
        simpleListModel.addValues(this._manager.getDoneCommands());
        simpleListModel.addValue(INSERT_POINT);
        simpleListModel.addValues(this._manager.getUndoneCommands());
        this._list.setModel(simpleListModel);
    }

    private static class CommandRenderer
    extends DefaultRenderer {
        private static final long serialVersionUID = -8428061618792898673L;

        private CommandRenderer() {
        }

        public void load(Object object) {
            if (object instanceof Command) {
                this.setMainText(((Command)object).getDescription());
            } else {
                this.setMainText(object.toString());
            }
        }
    }
}

