/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ConfigureOptionsPanel;
import edu.stanford.smi.protege.ui.ConfigureTabsPanel;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.ValidatableTabComponent;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;

public class ConfigureProjectPanel
extends ValidatableTabComponent {
    private static final long serialVersionUID = 7204453275303618585L;
    private static ArrayList userDefinedConfigTabs = new ArrayList();
    private Project _project;

    public ConfigureProjectPanel(Project project) {
        this._project = project;
        this.addTab("Tab Widgets", new ConfigureTabsPanel(project));
        this.addTab("Options", new ConfigureOptionsPanel(project));
        this.addUserDefinedConfigTabs();
    }

    private void addUserDefinedConfigTabs() {
        for (TabNameClsPair tabNameClsPair : userDefinedConfigTabs) {
            this.addConfigTab(tabNameClsPair.getTabName(), tabNameClsPair.getTabClsName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConfigTab(String string, String string2) {
        Component component;
        block25: {
            Class clazz = SystemUtilities.forName("edu.stanford.smi.protege.model.Project");
            if (clazz == null) {
                Log.getLogger().warning("Cannot find class Project");
                return;
            }
            Class clazz2 = SystemUtilities.forName(string2, true);
            if (clazz2 == null) {
                Log.getLogger().warning("Cannot find class: " + string2);
                return;
            }
            component = null;
            try {
                Constructor constructor = clazz2.getConstructor(clazz);
                component = (Component)constructor.newInstance(this._project);
            }
            catch (Exception exception) {
                if (component != null) break block25;
                try {
                    component = (Component)clazz2.newInstance();
                }
                catch (Exception exception2) {
                }
                finally {
                    if (component == null) {
                        Log.getLogger().warning("Cannot initialize constructor for class " + string2);
                    }
                }
            }
            finally {
                if (component == null) {
                    try {
                        component = (Component)clazz2.newInstance();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (component == null) {
                            Log.getLogger().warning("Cannot initialize constructor for class " + string2);
                        }
                    }
                }
            }
        }
        if (component != null) {
            this.addTab(string, component);
        }
    }

    public static void registerConfigureTab(String string, String string2) {
        userDefinedConfigTabs.add(new TabNameClsPair(string, string2));
    }

    public static void unregisterConfigureTab(String string) {
        boolean bl = false;
        Iterator iterator = userDefinedConfigTabs.iterator();
        while (iterator.hasNext() && !bl) {
            TabNameClsPair tabNameClsPair = (TabNameClsPair)iterator.next();
            if (!tabNameClsPair.getTabName().equals(string)) continue;
            userDefinedConfigTabs.remove(tabNameClsPair);
            bl = true;
        }
    }

    static class TabNameClsPair {
        private String _tabName;
        private String _tabClsName;

        public TabNameClsPair(String string, String string2) {
            this._tabName = string;
            this._tabClsName = string2;
        }

        public String getTabName() {
            return this._tabName;
        }

        public String getTabClsName() {
            return this._tabClsName;
        }
    }
}

