/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class Finder
extends JComponent {
    private static final long serialVersionUID = 5434797981046601159L;
    private static List searchedForStrings = new ArrayList();
    private JComboBox _comboBox;
    private Action _findButtonAction;
    private static final int MAX_MATCHES = ApplicationProperties.getIntegerProperty(Finder.class.getName() + ".max_matches", 100);
    private static final int DEFAULT_MAX_MATCHES = 100;
    private ListCellRenderer cellRenderer;

    protected Finder(String string) {
        this(string, Icons.getFindIcon());
    }

    protected Finder(String string, Icon icon) {
        this._findButtonAction = new StandardAction(string, icon){
            private static final long serialVersionUID = 8031258886171785419L;

            public void actionPerformed(ActionEvent actionEvent) {
                Finder.this.doFind();
            }
        };
        this.initialize();
    }

    protected Finder(ResourceKey resourceKey) {
        this._findButtonAction = new StandardAction(resourceKey){
            private static final long serialVersionUID = 3573450038349614433L;

            public void actionPerformed(ActionEvent actionEvent) {
                Finder.this.doFind();
            }
        };
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTextField(), "Center");
        this.add((Component)this.createFindButton(), "East");
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private JComponent createFindButton() {
        JToolBar jToolBar = ComponentFactory.createToolBar();
        ComponentFactory.addToolBarButton(jToolBar, this._findButtonAction);
        return jToolBar;
    }

    private JComponent createTextField() {
        this._comboBox = ComponentFactory.createComboBox();
        this._comboBox.setEditable(true);
        this._comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                int n = actionEvent.getModifiers();
                if (string.equals("comboBoxChanged") && (n & 0x10) != 0) {
                    Finder.this.doFind();
                }
            }
        });
        this._comboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    Finder.this.doFind();
                }
            }
        });
        this._comboBox.addPopupMenuListener(this.createPopupMenuListener());
        return this._comboBox;
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Finder.this._comboBox.setModel(new DefaultComboBoxModel<Object>(searchedForStrings.toArray()));
            }
        };
    }

    private static void recordItem(String string) {
        searchedForStrings.remove(string);
        searchedForStrings.add(0, string);
    }

    private void doFind() {
        String string = (String)this._comboBox.getSelectedItem();
        if (string != null && string.length() != 0) {
            List list = this.getMatches(string, MAX_MATCHES);
            if (list.isEmpty()) {
                this.getToolkit().beep();
                ModalDialog.showMessageDialog(this, "No matches found");
            } else if (list.size() == 1) {
                WaitCursor waitCursor = new WaitCursor(this);
                Finder.recordItem(string);
                this.select(list.get(0));
                waitCursor.hide();
            } else {
                Finder.recordItem(string);
                if (list.size() == MAX_MATCHES) {
                    ModalDialog.showMessageDialog(this, "Search results limited to " + MAX_MATCHES);
                }
                String string2 = "Select from search results (" + list.size() + " matches)";
                int n = this.getBestMatch(list, string);
                Instance instance = DisplayUtilities.pickInstanceFromCollection(this, list, n, string2, this.cellRenderer);
                if (instance != null) {
                    WaitCursor waitCursor = new WaitCursor(this);
                    this.select(instance);
                    waitCursor.hide();
                }
            }
        }
    }

    protected abstract int getBestMatch(List var1, String var2);

    protected abstract List getMatches(String var1, int var2);

    protected abstract void select(Object var1);

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._comboBox.setEnabled(bl);
        this._findButtonAction.setEnabled(bl);
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.cellRenderer = listCellRenderer;
    }
}

