/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.DoubleClickActionAdapter;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class InstanceField
extends SelectableContainer {
    private static final long serialVersionUID = -103319789201403123L;
    private LabeledComponent _labeledComponent;
    private SelectableList _listComponent;
    private AllowableAction _viewAction;
    private AllowableAction _createAction;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private AllowableAction _deleteAction;
    private Collection _allowedClses;
    private Project _project;
    private FrameListener _instanceListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent frameEvent) {
            InstanceField.this._listComponent.repaint();
        }
    };

    public InstanceField(String string, Collection collection) {
        this._allowedClses = new ArrayList(collection);
        Iterator iterator = this._allowedClses.iterator();
        if (iterator.hasNext()) {
            Cls cls = (Cls)iterator.next();
            this._project = cls.getProject();
        }
        this._listComponent = ComponentFactory.createSingleItemList(null);
        this.setSelectable(this._listComponent);
        this._listComponent.setCellRenderer(FrameRenderer.createInstance());
        this._labeledComponent = new LabeledComponent(string, this._listComponent);
        this.setLayout(new BorderLayout());
        this.add(this._labeledComponent);
    }

    public void createCreateInstanceAction() {
        this._createAction = new CreateAction(ResourceKey.INSTANCE_CREATE){
            private static final long serialVersionUID = 8030442148042692501L;

            public void onCreate() {
                Cls cls = DisplayUtilities.pickConcreteCls((Component)InstanceField.this, InstanceField.this.getKnowledgeBase(), InstanceField.this._allowedClses);
                if (cls != null) {
                    Instance instance = InstanceField.this.getKnowledgeBase().createInstance(null, cls);
                    InstanceField.this._project.show(instance);
                    InstanceField.this.setInstance(instance);
                }
            }
        };
        this._labeledComponent.addHeaderButton(this._createAction);
    }

    public void createDeleteInstancesAction() {
        this._deleteAction = new DeleteInstancesAction(this);
        this._labeledComponent.addHeaderButton(this._deleteAction);
    }

    public void createRemoveInstanceAction() {
        this._removeAction = new RemoveAction(ResourceKey.INSTANCE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -1657976558917409719L;

            public void onRemove(Object object) {
                InstanceField.this.setInstance(null);
            }
        };
        this._labeledComponent.addHeaderButton(this._removeAction);
    }

    public void createSelectInstanceAction() {
        this._addAction = new AddAction(ResourceKey.INSTANCE_ADD){
            private static final long serialVersionUID = 1655533054275289305L;

            public void onAdd() {
                Instance instance = DisplayUtilities.pickInstance((Component)InstanceField.this, InstanceField.this._allowedClses);
                if (instance != null) {
                    InstanceField.this.setInstance(instance);
                }
            }
        };
        this._labeledComponent.addHeaderButton(this._addAction);
    }

    public void createViewInstanceAction() {
        this._viewAction = new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){
            private static final long serialVersionUID = 9128249468794341888L;

            public void onView(Object object) {
                InstanceField.this._project.show((Instance)object);
            }
        };
        this._labeledComponent.addHeaderButton(this._viewAction);
        this._listComponent.addMouseListener(new DoubleClickActionAdapter(this._viewAction));
    }

    public void dispose() {
        super.dispose();
        Instance instance = this.getInstance();
        if (instance != null) {
            instance.removeFrameListener(this._instanceListener);
        }
    }

    public Instance getInstance() {
        return (Instance)CollectionUtilities.getFirstItem(ComponentUtilities.getListValues(this._listComponent));
    }

    private KnowledgeBase getKnowledgeBase() {
        return this._project.getKnowledgeBase();
    }

    public void setEditable(boolean bl) {
        this._createAction.setAllowed(bl);
        this._addAction.setAllowed(bl);
        this._removeAction.setAllowed(bl);
        this._deleteAction.setAllowed(bl);
    }

    public void setInstance(Instance instance) {
        Instance instance2 = this.getInstance();
        if (instance2 != null) {
            instance2.removeFrameListener(this._instanceListener);
        }
        if (instance != null) {
            instance.addFrameListener(this._instanceListener);
        }
        ComponentUtilities.setListValues(this._listComponent, CollectionUtilities.createCollection(instance));
        this.notifySelectionListeners();
    }
}

