/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ConsoleFormatter;
import edu.stanford.smi.protege.util.FileFormatter;
import edu.stanford.smi.protege.util.LegacyLoggerImpl;
import edu.stanford.smi.protege.util.MessageError;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    private static boolean debug = false;
    private static boolean displayedIOWarning = false;
    private static Logger logger;
    private static LegacyLogger legacyLogger;
    private static Handler consoleHandler;
    private static Handler fileHandler;
    private static boolean configuredByFile;

    private Log() {
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("protege.system");
            if (!configuredByFile) {
                try {
                    logger.setUseParentHandlers(false);
                    logger.setLevel(Level.ALL);
                    Log.addConsoleHandler();
                    Log.addFileHandler();
                }
                catch (Throwable throwable) {
                    System.out.println("Exception configuring logger");
                }
            }
        }
        return logger;
    }

    public static void emptyCatchBlock(Throwable throwable) {
        if (Log.getLogger().isLoggable(Level.FINE)) {
            Log.getLogger().log(Level.FINE, "Exception Caught", throwable);
        }
    }

    public static Logger getLogger(Class clazz) {
        Logger logger;
        block4: {
            logger = Logger.getLogger(clazz.getName());
            if (!configuredByFile) {
                try {
                    logger.addHandler(Log.getFileHandler());
                    Handler handler = Log.getConsoleHandler();
                    if (logger != null && handler != null) {
                        logger.addHandler(handler);
                    }
                }
                catch (Throwable throwable) {
                    if (displayedIOWarning) break block4;
                    System.err.println("Warning: IO exception getting logger. " + throwable.getMessage());
                    displayedIOWarning = true;
                }
            }
        }
        return logger;
    }

    public static void makeInheritedLoggersLocal(Logger logger) {
        Handler[] handlerArray;
        logger.setUseParentHandlers(false);
        if (logger.getHandlers() != null && logger.getHandlers().length > 0) {
            return;
        }
        for (Handler handler : handlerArray = Log.getInheritedHandlers(logger)) {
            logger.addHandler(handler);
        }
    }

    private static Handler[] getInheritedHandlers(Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        while (handlerArray.length == 0) {
            Logger logger2 = logger.getParent();
            if (logger2 == null) {
                return handlerArray;
            }
            logger = logger2;
            handlerArray = logger2.getHandlers();
        }
        return handlerArray;
    }

    public static void setLoggingLevel(Class<?> clazz, Level level) {
        Logger.getLogger(clazz.getName()).setLevel(level);
    }

    public static void handleErrors(Logger logger, Level level, Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        logger.log(level, "Errors found performing operation.\n\n");
        for (Object e : collection) {
            Object object;
            if (e instanceof MessageError) {
                object = (MessageError)e;
                logger.log(level, ((MessageError)object).getMessage(), ((MessageError)object).getException());
                continue;
            }
            if (e instanceof Throwable) {
                object = (Throwable)e;
                logger.log(level, "Exception caught", (Throwable)object);
                continue;
            }
            logger.log(level, e == null ? "(missing error message)" : e.toString());
        }
    }

    public static String toString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return ((Object)stringWriter).toString();
    }

    private static void addConsoleHandler() {
        Handler handler = Log.getConsoleHandler();
        if (logger != null && handler != null) {
            logger.addHandler(handler);
        }
    }

    private static Handler getConsoleHandler() {
        try {
            if (consoleHandler == null) {
                consoleHandler = new ConsoleHandler();
                consoleHandler.setFormatter(new ConsoleFormatter());
                consoleHandler.setLevel(Level.ALL);
            }
            return consoleHandler;
        }
        catch (Throwable throwable) {
            System.err.println("Warning: Cannot set console log debugger handler.");
            return null;
        }
    }

    private static void addFileHandler() {
        try {
            Handler handler = Log.getFileHandler();
            logger.addHandler(handler);
            handler.publish(new LogRecord(Level.INFO, "*** SYSTEM START ***"));
        }
        catch (Throwable throwable) {
            System.err.println("Error adding file handler to logger");
        }
    }

    private static Handler getFileHandler() throws IOException {
        if (fileHandler == null) {
            File file = ApplicationProperties.getLogFileDirectory();
            String string = file == null ? "%t" : file.getPath();
            fileHandler = new FileHandler(string + File.separatorChar + "protege_%u.log", true);
            fileHandler.setFormatter(new FileFormatter());
            fileHandler.setLevel(Level.ALL);
        }
        return fileHandler;
    }

    private static File getApplicationDirectory() {
        String string = Log.getSystemProperty("protege.dir");
        if (string == null) {
            string = Log.getSystemProperty("user.dir");
        }
        return string == null ? null : new File(string);
    }

    private static String getSystemProperty(String string) {
        String string2;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        return string2;
    }

    private static LegacyLogger getLegacyLogger() {
        if (legacyLogger == null) {
            legacyLogger = new LegacyLoggerImpl(Log.getLogger());
        }
        return legacyLogger;
    }

    @Deprecated
    public static void enter(Object object, String string) {
        Log.getLegacyLogger().enter(object, string, new Object[0]);
    }

    @Deprecated
    public static void enter(Object object, String string, Object object2) {
        Log.getLegacyLogger().enter(object, string, new Object[]{object2});
    }

    @Deprecated
    public static void enter(Object object, String string, Object object2, Object object3) {
        Log.getLegacyLogger().enter(object, string, new Object[]{object2, object3});
    }

    @Deprecated
    public static void enter(Object object, String string, Object object2, Object object3, Object object4) {
        Log.getLegacyLogger().enter(object, string, new Object[]{object2, object3, object4});
    }

    @Deprecated
    public static void enter(Object object, String string, Object object2, Object object3, Object object4, Object object5) {
        Log.getLegacyLogger().enter(object, string, new Object[]{object2, object3, object4, object5});
    }

    @Deprecated
    public static void enter(Object object, String string, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Log.getLegacyLogger().enter(object, string, new Object[]{object2, object3, object4, object5, object6});
    }

    @Deprecated
    public static void error(String string, Object object, String string2) {
        Log.getLegacyLogger().error(string, object, string2, new Object[0]);
    }

    @Deprecated
    public static void error(String string, Object object, String string2, Object object2) {
        Log.getLegacyLogger().error(string, object, string2, new Object[]{object2});
    }

    @Deprecated
    public static void error(String string, Object object, String string2, Object object2, Object object3) {
        Log.getLegacyLogger().error(string, object, string2, new Object[]{object2, object3});
    }

    @Deprecated
    public static void error(String string, Object object, String string2, Object object2, Object object3, Object object4) {
        Log.getLegacyLogger().error(string, object, string2, new Object[]{object2, object3, object4});
    }

    @Deprecated
    public static void error(String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5) {
        Log.getLegacyLogger().error(string, object, string2, new Object[]{object2, object3, object4, object5});
    }

    @Deprecated
    public static void error(String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Log.getLegacyLogger().error(string, object, string2, new Object[]{object2, object3, object4, object5, object6});
    }

    @Deprecated
    public static void exception(Throwable throwable, Object object, String string) {
        Log.getLegacyLogger().exception(throwable, object, string, new Object[0]);
    }

    @Deprecated
    public static void exception(Throwable throwable, Object object, String string, Object object2) {
        Log.getLegacyLogger().exception(throwable, object, string, new Object[]{object2});
    }

    @Deprecated
    public static void exception(Throwable throwable, Object object, String string, Object object2, Object object3) {
        Log.getLegacyLogger().exception(throwable, object, string, new Object[]{object2, object3});
    }

    @Deprecated
    public static void exception(Throwable throwable, Object object, String string, Object object2, Object object3, Object object4) {
        Log.getLegacyLogger().exception(throwable, object, string, new Object[]{object2, object3, object4});
    }

    @Deprecated
    public static void exception(Throwable throwable, Object object, String string, Object object2, Object object3, Object object4, Object object5) {
        Log.getLegacyLogger().exception(throwable, object, string, new Object[]{object2, object3, object4, object5});
    }

    @Deprecated
    public static void exception(Throwable throwable, Object object, String string, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Log.getLegacyLogger().exception(throwable, object, string, new Object[]{object2, object3, object4, object5, object6});
    }

    @Deprecated
    public static void exit(Object object, String string) {
        Log.getLegacyLogger().exit(object, string, new Object[0]);
    }

    @Deprecated
    public static void stack(String string, Object object, String string2) {
        Log.getLegacyLogger().stack(string, object, string2, new Object[0]);
    }

    @Deprecated
    public static void stack(String string, Object object, String string2, Object object2) {
        Log.getLegacyLogger().stack(string, object, string2, new Object[]{object2});
    }

    @Deprecated
    public static void stack(String string, Object object, String string2, Object object2, Object object3) {
        Log.getLegacyLogger().stack(string, object, string2, new Object[]{object2, object3});
    }

    @Deprecated
    public static void stack(String string, Object object, String string2, Object object2, Object object3, Object object4) {
        Log.getLegacyLogger().stack(string, object, string2, new Object[]{object2, object3, object4});
    }

    @Deprecated
    public static void stack(String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5) {
        Log.getLegacyLogger().stack(string, object, string2, new Object[]{object2, object3, object4, object5});
    }

    @Deprecated
    public static void trace(String string, Object object, String string2) {
        Log.getLegacyLogger().trace(string, object, string2, new Object[0]);
    }

    @Deprecated
    public static void trace(String string, Object object, String string2, Object object2) {
        Log.getLegacyLogger().trace(string, object, string2, new Object[]{object2});
    }

    @Deprecated
    public static void trace(String string, Object object, String string2, Object object2, Object object3) {
        Log.getLegacyLogger().trace(string, object, string2, new Object[]{object2, object3});
    }

    @Deprecated
    public static void trace(String string, Object object, String string2, Object object2, Object object3, Object object4) {
        Log.getLegacyLogger().trace(string, object, string2, new Object[]{object2, object3, object4});
    }

    @Deprecated
    public static void trace(String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5) {
        Log.getLegacyLogger().trace(string, object, string2, new Object[]{object2, object3, object4, object5});
    }

    @Deprecated
    public static void trace(String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Log.getLegacyLogger().trace(string, object, string2, new Object[]{object2, object3, object4, object5, object6});
    }

    @Deprecated
    public static void warning(String string, Object object, String string2) {
        Log.getLegacyLogger().warning(string, object, string2, new Object[0]);
    }

    @Deprecated
    public static void warning(String string, Object object, String string2, Object object2) {
        Log.getLegacyLogger().warning(string, object, string2, new Object[]{object2});
    }

    @Deprecated
    public static void warning(String string, Object object, String string2, Object object2, Object object3) {
        Log.getLegacyLogger().warning(string, object, string2, new Object[]{object2, object3});
    }

    @Deprecated
    public static void warning(String string, Object object, String string2, Object object2, Object object3, Object object4) {
        Log.getLegacyLogger().warning(string, object, string2, new Object[]{object2, object3, object4});
    }

    @Deprecated
    public static void warning(String string, Object object, String string2, Object object2, Object object3, Object object4, Object object5) {
        Log.getLegacyLogger().warning(string, object, string2, new Object[]{object2, object3, object4, object5});
    }

    static {
        String string = "log.config.debug";
        try {
            if (System.getProperty(string) != null) {
                debug = true;
            }
        }
        catch (Throwable throwable) {
            debug = false;
        }
        configuredByFile = false;
        boolean bl = false;
        String string2 = "java.util.logging.config.file";
        try {
            String string3 = Log.getApplicationDirectory().getAbsolutePath();
            if (System.getProperty(string2) != null) {
                if (debug) {
                    System.out.println("Logger already configured...");
                }
                configuredByFile = true;
                bl = true;
            } else if (string3 != null) {
                File file = new File(string3 + File.separator + "logging.properties");
                if (debug) {
                    System.out.println("Logging file = " + file);
                }
                if (file.canRead()) {
                    if (debug) {
                        System.out.println("Logging file readable");
                    }
                    System.setProperty(string2, file.getAbsolutePath());
                    LogManager.getLogManager().readConfiguration();
                    configuredByFile = true;
                    bl = true;
                    if (debug) {
                        System.out.println("Configuration done by util.Log class ");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("Could not set up class specific logging");
        }
        if (!bl) {
            if (debug) {
                System.out.println("using default configuration.");
            }
            try {
                Log.getLogger().setLevel(Level.CONFIG);
            }
            catch (Throwable throwable) {
                System.out.println("Could not set logger level");
            }
        }
    }

    static interface LegacyLogger {
        public void enter(Object var1, String var2, Object[] var3);

        public void exit(Object var1, String var2, Object[] var3);

        public void trace(String var1, Object var2, String var3, Object[] var4);

        public void warning(String var1, Object var2, String var3, Object[] var4);

        public void error(String var1, Object var2, String var3, Object[] var4);

        public void exception(Throwable var1, Object var2, String var3, Object[] var4);

        public void stack(String var1, Object var2, String var3, Object[] var4);
    }
}

