/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.LookAndFeelUtil;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEventDispatcher;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.TreeSelectionListenerAdapter;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public class SelectableTree
extends JTree
implements Selectable,
Disposable,
Autoscroll {
    private static final long serialVersionUID = -97980195042663048L;
    private ListenerCollection _selectionListeners = new ListenerList(new SelectionEventDispatcher());
    private static final int SCROLL_BORDER = 8;
    private TreeModelListener listener = new TreeModelListener(){

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            SelectableTree.this.expandRow(0);
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    };

    public SelectableTree(Action action) {
        this(action, null);
    }

    public SelectableTree(Action action, LazyTreeRoot lazyTreeRoot) {
        super(new LazyTreeModel(lazyTreeRoot));
        ComponentFactory.configureTree(this, action);
        this.getModel().addTreeModelListener(this.listener);
        this.expandRow(0);
        this.addMouseListener(new TreePopupMenuMouseListener(this){

            public JPopupMenu getPopupMenu() {
                return SelectableTree.this.getPopupMenu();
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListenerAdapter(this));
        try {
            LookAndFeelUtil.setTreeLineStyle(this);
        }
        catch (Throwable throwable) {
            Log.emptyCatchBlock(throwable);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this._selectionListeners.add(this, selectionListener);
    }

    public void dispose() {
        TreeModel treeModel = this.getModel();
        if (treeModel != null) {
            treeModel.removeTreeModelListener(this.listener);
            if (treeModel instanceof LazyTreeModel) {
                LazyTreeModel lazyTreeModel = (LazyTreeModel)treeModel;
                lazyTreeModel.dispose();
            }
        }
        this.setCellRenderer(null);
    }

    public JPopupMenu getPopupMenu() {
        return null;
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this);
    }

    public void notifySelectionListeners() {
        this._selectionListeners.postEvent(this, 1);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this._selectionListeners.remove(this, selectionListener);
    }

    public void setRoot(LazyTreeRoot lazyTreeRoot) {
        LazyTreeModel lazyTreeModel = (LazyTreeModel)this.getModel();
        lazyTreeModel.setRoot(lazyTreeRoot);
        this.expandRow(0);
    }

    public String toString() {
        return "SelectableTree";
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        if (this.getParent() != null) {
            super.processFocusEvent(focusEvent);
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getVisibleRect();
        Dimension dimension = this.getSize();
        Insets insets = new Insets(rectangle.y + 8, rectangle.x + 8, dimension.height - rectangle.y - rectangle.height + 8, dimension.width - rectangle.x - rectangle.width + 8);
        return insets;
    }

    public void autoscroll(Point point) {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (jScrollPane != null) {
            JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
            Rectangle rectangle = this.getVisibleRect();
            if (point.x <= rectangle.x + 8) {
                SelectableTree.scroll(jScrollBar, -1);
            }
            if (point.y <= rectangle.y + 8) {
                SelectableTree.scroll(jScrollBar2, -1);
            }
            if (point.x >= rectangle.x + rectangle.width - 8) {
                SelectableTree.scroll(jScrollBar, 1);
            }
            if (point.y >= rectangle.y + rectangle.height - 8) {
                SelectableTree.scroll(jScrollBar2, 1);
            }
        }
    }

    private static void scroll(JScrollBar jScrollBar, int n) {
        int n2 = n < 0 ? -1 : 1;
        jScrollBar.setValue(jScrollBar.getValue() + n2 * jScrollBar.getUnitIncrement(n));
    }
}

