/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.Widget;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class GeneralWidgetConfigurationPanel
extends AbstractValidatableComponent {
    private static final long serialVersionUID = -3148523589303750172L;
    private JTextField _labelField;
    private JTextField _tooltipField;
    private SlotWidget _widget;

    public GeneralWidgetConfigurationPanel(SlotWidget slotWidget) {
        this._widget = slotWidget;
        this.setLayout(new GridLayout(0, 1, 10, 10));
        this.add(this.createClsNameField(slotWidget));
        this.add(this.createSlotNameField(slotWidget));
        this.add(this.createLabelNameField(slotWidget));
        this.add(this.createToolTipNameField(slotWidget));
    }

    private JComponent createClsNameField(SlotWidget slotWidget) {
        return this.createFrameField("Class", slotWidget.getCls());
    }

    private JTextField createField(String string) {
        JTextField jTextField = ComponentFactory.createTextField();
        jTextField.setText(string);
        return jTextField;
    }

    private JComponent createFrameField(String string, Instance instance) {
        String string2 = instance == null ? "" : instance.getName();
        JTextField jTextField = this.createField(string2);
        jTextField.setEditable(false);
        return new LabeledComponent(string, jTextField);
    }

    private JComponent createLabelNameField(Widget widget) {
        this._labelField = this.createField(widget.getLabel());
        return new LabeledComponent("Label", this._labelField);
    }

    private JComponent createSlotNameField(SlotWidget slotWidget) {
        return this.createFrameField("Slot", slotWidget.getSlot());
    }

    private JComponent createToolTipNameField(SlotWidget slotWidget) {
        this._tooltipField = this.createField(slotWidget.getDefaultToolTip());
        return new LabeledComponent("Default Tool Tip", this._tooltipField);
    }

    public String getLabel() {
        return this._labelField.getText();
    }

    public void saveContents() {
        this._widget.setLabel(this._labelField.getText());
        this._widget.setDefaultToolTip(this._tooltipField.getText());
    }

    public boolean validateContents() {
        return true;
    }
}

