/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ListSelectionListenerAdapter;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SymbolValidator;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractValuesComponent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JScrollPane;

class SymbolValuesComponent
extends AbstractValuesComponent
implements Selectable {
    private static final long serialVersionUID = 3508078941013882199L;
    private SelectableList _list;
    private AllowableAction _createAction;
    private AllowableAction _editAction;
    private AllowableAction _removeAction;

    public SymbolValuesComponent() {
        Action action = this.getEditAction();
        this._list = ComponentFactory.createSelectableList(action, true);
        this._list.addListSelectionListener(new ListSelectionListenerAdapter(this));
        String string = LocalizedText.getText(ResourceKey.ALLOWED_VALUES);
        LabeledComponent labeledComponent = new LabeledComponent(string, new JScrollPane(this._list));
        labeledComponent.addHeaderButton(action);
        labeledComponent.addHeaderButton(this.getCreateAction());
        labeledComponent.addHeaderButton(this.getRemoveAction());
        this.add(labeledComponent);
    }

    public void clearSelection() {
        this._list.clearSelection();
    }

    private Action getCreateAction() {
        this._createAction = new CreateAction(ResourceKey.VALUE_CREATE){
            private static final long serialVersionUID = -3411238108344825853L;

            public void onCreate() {
                String string = DisplayUtilities.editString(SymbolValuesComponent.this._list, "Create Symbol", null, new SymbolValidator());
                if (string != null && string.length() > 0) {
                    ComponentUtilities.addUniqueListValues(SymbolValuesComponent.this._list, CollectionUtilities.createCollection(string));
                    SymbolValuesComponent.this.valueChanged();
                }
            }
        };
        return this._createAction;
    }

    private Action getEditAction() {
        this._editAction = new ViewAction(ResourceKey.VALUE_VIEW, (Selectable)this){
            private static final long serialVersionUID = -1379237486395269996L;

            public void onView(Object object) {
                String string = DisplayUtilities.editString(SymbolValuesComponent.this._list, "Edit Symbol", object, new SymbolValidator());
                if (string != null) {
                    ComponentUtilities.replaceListValue(SymbolValuesComponent.this._list, object, string);
                    SymbolValuesComponent.this.valueChanged();
                }
            }
        };
        return this._editAction;
    }

    private Action getRemoveAction() {
        this._removeAction = new RemoveAction(ResourceKey.VALUE_REMOVE, (Selectable)this){
            private static final long serialVersionUID = 3520724966158279341L;

            public void onRemove(Collection collection) {
                ComponentUtilities.removeListValues(SymbolValuesComponent.this._list, collection);
                SymbolValuesComponent.this.valueChanged();
            }
        };
        return this._removeAction;
    }

    public Collection getSelection() {
        return this._list.getSelection();
    }

    public Collection getValues() {
        Collection collection = ComponentUtilities.getListValues(this._list);
        return ValueTypeConstraint.getValues(ValueType.SYMBOL, collection);
    }

    public void setEditable(boolean bl) {
        this._createAction.setAllowed(bl);
        this._editAction.setAllowed(bl);
        this._removeAction.setAllowed(bl);
    }

    public void setValues(Collection collection) {
        Collection collection2 = ValueTypeConstraint.getAllowedValues(collection);
        ComponentUtilities.setListValues(this._list, collection2);
    }
}

