/*
 * #%L
 * Protempa Commons Backend Provider
 * %%
 * Copyright (C) 2012 - 2013 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.protempa.bp.commons;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.protempa.backend.AbstractCommonsKnowledgeSourceBackend;
import org.protempa.backend.annotations.BackendInfo;
import org.protempa.backend.annotations.BackendProperty;
import org.drools.util.StringUtils;
import org.protempa.AbstractionDefinition;
import org.protempa.ContextDefinition;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.TemporalPropositionDefinition;

@BackendInfo(displayName = "Mock Knowledge Source Backend")
public class MockKnowledgeSourceBackend
        extends AbstractCommonsKnowledgeSourceBackend {


    private String url;

    public String getUrl() {
        return url;
    }

    @BackendProperty(
            displayName = "URL",
            description = "The URL to the knowledge base"
    )
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public PropositionDefinition readPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return null;
    }

    @Override
    public AbstractionDefinition readAbstractionDefinition(String id) throws KnowledgeSourceReadException {
        return null;
    }

    @Override
    public String[] readAbstractedInto(String propId) throws KnowledgeSourceReadException {
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] readIsA(String propId) throws KnowledgeSourceReadException {
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public ContextDefinition readContextDefinition(String id) throws KnowledgeSourceReadException {
        return null;
    }

    @Override
    public TemporalPropositionDefinition readTemporalPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return null;
    }

    @Override
    public String[] readInduces(String propId) throws KnowledgeSourceReadException {
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] readSubContextOfs(String propId) throws KnowledgeSourceReadException {
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> getKnowledgeSourceSearchResults(String searchKey)
            throws KnowledgeSourceReadException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public Collection<String> collectPropIdDescendantsUsingAllNarrower(boolean inDataSourceOnly, String[] propIds) throws KnowledgeSourceReadException {
        return Collections.emptyList();
    }

    @Override
    public Collection<PropositionDefinition> collectPropDefDescendantsUsingAllNarrower(boolean inDataSourceOnly, String[] propIds) throws KnowledgeSourceReadException {
        return Collections.emptyList();
    }

    @Override
    public Collection<PropositionDefinition> collectPropDefDescendantsUsingInverseIsA(String[] propIds) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> collectPropIdDescendantsUsingInverseIsA(String[] propIds) {
        return Collections.emptyList();
    }

    @Override
    public List<PropositionDefinition> readPropositionDefinitions(String[] ids) {
        return Collections.emptyList();
    }

    @Override
    public List<AbstractionDefinition> readAbstractionDefinitions(String[] ids) {
       return Collections.emptyList();
    }

    @Override
    public List<ContextDefinition> readContextDefinitions(String[] toArray) {
        return Collections.emptyList();
    }

    @Override
    public List<TemporalPropositionDefinition> readTemporalPropositionDefinitions(String[] toArray) {
        return Collections.emptyList();
    }
    
    
    
}
