/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.JavaCodeGenerator;
import edu.stanford.smi.protege.code.generator.wrapping.JavaCodeGeneratorPanel;
import edu.stanford.smi.protege.code.generator.wrapping.ProjectBasedJavaCodeGeneratorOptions;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;

public class JavaCodeGeneratorAction
extends AbstractAction {
    private static final long serialVersionUID = -916379802587626908L;
    public static final String JAVA_CODE_GEN_ACTION_NAME = "Generate Java Code...";
    private KnowledgeBase kb;

    public JavaCodeGeneratorAction(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ProjectBasedJavaCodeGeneratorOptions projectBasedJavaCodeGeneratorOptions = new ProjectBasedJavaCodeGeneratorOptions();
        JavaCodeGeneratorPanel javaCodeGeneratorPanel = new JavaCodeGeneratorPanel(this.kb, projectBasedJavaCodeGeneratorOptions);
        ProjectView projectView = ProjectManager.getProjectManager().getCurrentProjectView();
        if (ModalDialog.showDialog(projectView, javaCodeGeneratorPanel, this.getName(), 11) == 1) {
            javaCodeGeneratorPanel.ok();
            JavaCodeGenerator javaCodeGenerator = new JavaCodeGenerator(this.kb, projectBasedJavaCodeGeneratorOptions);
            try {
                javaCodeGenerator.createAll();
                ModalDialog.showMessageDialog(projectView, "Java code generated successfully in directory:\n" + projectBasedJavaCodeGeneratorOptions.getOutputFolder());
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                ModalDialog.showMessageDialog((Component)projectView, "Could not create Java code:\n" + exception.getMessage(), 14);
            }
        }
    }

    public String getName() {
        return JAVA_CODE_GEN_ACTION_NAME;
    }
}

