/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.PlaceHolderNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.SimpleFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.model.query.SynchronizeQueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.Tree;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergingNarrowFrameStore
implements NarrowFrameStore {
    private static Logger log = Log.getLogger(MergingNarrowFrameStore.class);
    private final Object kbLock;
    private static final NarrowFrameStore ROOT_NODE = new PlaceHolderNarrowFrameStore();
    private NarrowFrameStore activeFrameStore;
    private final Collection<NarrowFrameStore> removeFrameStores = new LinkedHashSet<NarrowFrameStore>();
    private final Collection<NarrowFrameStore> availableFrameStores = new LinkedHashSet<NarrowFrameStore>();
    private NarrowFrameStore topFrameStore;
    private final NarrowFrameStore systemFrameStore;
    private boolean queryAllFrameStores = false;
    private boolean suppressDuplicates = false;
    private final Tree<NarrowFrameStore> frameStoreTree = new Tree<NarrowFrameStore>(ROOT_NODE);

    public MergingNarrowFrameStore(Object object) {
        this.systemFrameStore = new InMemoryFrameDb("system");
        this.addActiveFrameStore(this.systemFrameStore);
        this.kbLock = object;
    }

    public static MergingNarrowFrameStore get(KnowledgeBase knowledgeBase) {
        FrameStore frameStore;
        if (knowledgeBase instanceof DefaultKnowledgeBase && (frameStore = ((DefaultKnowledgeBase)knowledgeBase).getTerminalFrameStore()) instanceof SimpleFrameStore) {
            SimpleFrameStore simpleFrameStore = (SimpleFrameStore)frameStore;
            for (NarrowFrameStore narrowFrameStore = simpleFrameStore.getHelper().getDelegate(); narrowFrameStore != null; narrowFrameStore = narrowFrameStore.getDelegate()) {
                if (!(narrowFrameStore instanceof MergingNarrowFrameStore)) continue;
                return (MergingNarrowFrameStore)narrowFrameStore;
            }
        }
        return null;
    }

    public static NarrowFrameStore getSystemFrameStore(KnowledgeBase knowledgeBase) {
        return MergingNarrowFrameStore.get(knowledgeBase).getSystemFrameStore();
    }

    public static NarrowFrameStore getNarrowFrameStore(KnowledgeBase knowledgeBase, Class clazz) {
        NarrowFrameStore narrowFrameStore = MergingNarrowFrameStore.get(knowledgeBase);
        while ((narrowFrameStore = narrowFrameStore.getDelegate()) != null) {
            if (!clazz.isAssignableFrom(narrowFrameStore.getClass())) continue;
            return narrowFrameStore;
        }
        return null;
    }

    public NarrowFrameStore getSystemFrameStore() {
        return this.systemFrameStore;
    }

    public Collection<NarrowFrameStore> getAvailableFrameStores() {
        return new ArrayList<NarrowFrameStore>(this.availableFrameStores);
    }

    public Collection<NarrowFrameStore> getAllFrameStores() {
        Set<NarrowFrameStore> set = this.frameStoreTree.getNodes();
        set.add(this.systemFrameStore);
        return set;
    }

    @Override
    public String getName() {
        return StringUtilities.getClassName(this);
    }

    @Override
    public void setName(String string) {
        throw new UnsupportedOperationException();
    }

    public NarrowFrameStore getActiveFrameStore() {
        return this.activeFrameStore;
    }

    public void setRemoveFrameStores(Collection<NarrowFrameStore> collection) {
        this.removeFrameStores.clear();
        this.removeFrameStores.addAll(collection);
    }

    public NarrowFrameStore getFrameStore(String string) {
        NarrowFrameStore narrowFrameStore = null;
        for (NarrowFrameStore narrowFrameStore2 : this.frameStoreTree.getDescendents(ROOT_NODE)) {
            if (!string.equals(narrowFrameStore2.getName())) continue;
            narrowFrameStore = narrowFrameStore2;
            break;
        }
        return narrowFrameStore;
    }

    public void addRelation(String string, String string2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding frame store relation between " + string + " and " + string2);
        }
        NarrowFrameStore narrowFrameStore = this.getFrameStore(string);
        NarrowFrameStore narrowFrameStore2 = this.getFrameStore(string2);
        if (narrowFrameStore == null || narrowFrameStore2 == null) {
            String string3 = "Unable to add relation between " + string + "(" + narrowFrameStore + ")";
            string3 = string3 + " and " + string2 + "(" + narrowFrameStore2 + ")";
            Log.getLogger().warning(string3);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("...Added");
                this.dumpFrameStores(Level.FINE);
            }
            this.frameStoreTree.addChild(narrowFrameStore, narrowFrameStore2);
            this.updateQueryableFrameStores();
        }
    }

    public void dumpFrameStores() {
        this.dumpFrameStores(Level.INFO);
    }

    public void dumpFrameStores(Level level) {
        if (!log.isLoggable(level)) {
            return;
        }
        log.log(level, "------------Starting Merged Narrow Frame Store Dump");
        for (NarrowFrameStore narrowFrameStore : this.frameStoreTree.getNodes()) {
            log.log(level, "*" + narrowFrameStore.getClass() + " " + narrowFrameStore.getName() + " " + this.frameStoreTree.getChildren(narrowFrameStore));
        }
        if (this.activeFrameStore != null) {
            log.log(level, "Active frame store = " + this.activeFrameStore.getName());
        }
        log.log(level, "------------Merged Narrow Frame Store Dump Completed");
    }

    public void addActiveFrameStore(NarrowFrameStore narrowFrameStore) {
        this.addActiveFrameStore(narrowFrameStore, CollectionUtilities.EMPTY_ARRAY_LIST);
    }

    public void addActiveChildFrameStore(NarrowFrameStore narrowFrameStore, String string) {
        if (narrowFrameStore == null) {
            throw new IllegalArgumentException("Null child");
        }
        NarrowFrameStore narrowFrameStore2 = this.getFrameStore(string);
        if (narrowFrameStore2 == null) {
            throw new IllegalArgumentException("Null parent: " + string);
        }
        this.frameStoreTree.addChild(narrowFrameStore2, narrowFrameStore);
        this.setActiveFrameStore(narrowFrameStore);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding child frame store (and making active?) " + narrowFrameStore);
            this.dumpFrameStores(Level.FINE);
        }
    }

    public void removeFrameStore(NarrowFrameStore narrowFrameStore) {
        this.frameStoreTree.removeNode(narrowFrameStore);
        this.availableFrameStores.remove(narrowFrameStore);
        this.removeFrameStores.remove(narrowFrameStore);
        if (log.isLoggable(Level.FINE)) {
            log.fine("removing frame store " + narrowFrameStore);
        }
    }

    public void addActiveFrameStore(NarrowFrameStore narrowFrameStore, Collection collection) {
        if (narrowFrameStore == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.frameStoreTree.addChild(ROOT_NODE, narrowFrameStore);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            NarrowFrameStore narrowFrameStore2 = this.getFrameStore(string);
            if (narrowFrameStore2 == null) {
                Log.getLogger().warning("Unable to find child FrameStore: " + string);
                continue;
            }
            this.frameStoreTree.addChild(narrowFrameStore, narrowFrameStore2);
        }
        this.setActiveFrameStore(narrowFrameStore);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Added new active frame store");
            this.dumpFrameStores(Level.FINE);
        }
    }

    public Slot getNameSlot() {
        return (Slot)this.systemFrameStore.getFrame(Model.SlotID.NAME);
    }

    public void setTopFrameStore(String string) {
        this.topFrameStore = string == null ? null : this.getFrameStore(string);
        this.updateQueryableFrameStores();
    }

    public NarrowFrameStore getTopFrameStore() {
        return this.topFrameStore == null ? this.activeFrameStore : this.topFrameStore;
    }

    public NarrowFrameStore setActiveFrameStore(NarrowFrameStore narrowFrameStore) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting the delegate for " + this + " to " + narrowFrameStore);
        }
        NarrowFrameStore narrowFrameStore2 = this.activeFrameStore;
        if (narrowFrameStore != null) {
            this.activeFrameStore = narrowFrameStore;
            this.updateQueryableFrameStores();
        }
        return narrowFrameStore2;
    }

    public void setQueryAllFrameStores(boolean bl) {
        this.queryAllFrameStores = bl;
        this.updateQueryableFrameStores();
    }

    public void setSuppressDuplicates(boolean bl) {
        this.suppressDuplicates = bl;
    }

    private void updateQueryableFrameStores() {
        this.availableFrameStores.clear();
        this.availableFrameStores.add(this.systemFrameStore);
        if (this.queryAllFrameStores) {
            this.availableFrameStores.addAll(this.frameStoreTree.getDescendents(ROOT_NODE));
        } else {
            this.availableFrameStores.addAll(this.frameStoreTree.getNodeAndDescendents(this.getTopFrameStore()));
        }
        this.checkAvailable();
    }

    private void checkAvailable() {
        Iterator<NarrowFrameStore> iterator = this.availableFrameStores.iterator();
        while (iterator.hasNext()) {
            NarrowFrameStore narrowFrameStore = iterator.next();
            if (narrowFrameStore != null) continue;
            Log.getLogger().severe("Null frame store found");
            iterator.remove();
        }
    }

    public NarrowFrameStore setActiveFrameStore(String string) {
        NarrowFrameStore narrowFrameStore = this.getFrameStore(string);
        if (narrowFrameStore == null) {
            Log.getLogger().severe("Missing frame store: " + string);
        }
        return this.setActiveFrameStore(narrowFrameStore);
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return this.activeFrameStore;
    }

    @Override
    public int getFrameCount() {
        int n = 0;
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            n += narrowFrameStore.getFrameCount();
        }
        return n;
    }

    public Set getFrames() {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            hashSet.addAll(narrowFrameStore.getFrames());
        }
        return hashSet;
    }

    @Override
    public int getClsCount() {
        int n = 0;
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            n += narrowFrameStore.getClsCount();
        }
        return n;
    }

    @Override
    public int getSlotCount() {
        int n = 0;
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            n += narrowFrameStore.getSlotCount();
        }
        return n;
    }

    @Override
    public int getFacetCount() {
        int n = 0;
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            n += narrowFrameStore.getFacetCount();
        }
        return n;
    }

    @Override
    public int getSimpleInstanceCount() {
        int n = 0;
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            n += narrowFrameStore.getSimpleInstanceCount();
        }
        return n;
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        Frame frame = null;
        Iterator<NarrowFrameStore> iterator = this.availableFrameStores.iterator();
        while (iterator.hasNext() && frame == null) {
            NarrowFrameStore narrowFrameStore = iterator.next();
            frame = narrowFrameStore.getFrame(frameID);
        }
        return frame;
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this.getValues(frame, slot, facet, bl, false);
    }

    private List getSecondaryValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this.getValues(frame, slot, facet, bl, true);
    }

    private List getValues(Frame frame, Slot slot, Facet facet, boolean bl, boolean bl2) {
        SequencedCollection sequencedCollection = null;
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            List list;
            if (narrowFrameStore == this.activeFrameStore && bl2 || (list = narrowFrameStore.getValues(frame, slot, facet, bl)).isEmpty()) continue;
            if (sequencedCollection == null && !this.suppressDuplicates) {
                sequencedCollection = list;
                continue;
            }
            if (sequencedCollection == null && this.suppressDuplicates) {
                sequencedCollection = new LinkedHashSet(list);
                continue;
            }
            sequencedCollection.addAll(list);
        }
        if (sequencedCollection == null) {
            sequencedCollection = Collections.EMPTY_LIST;
        }
        if (!(sequencedCollection instanceof List)) {
            sequencedCollection = new ArrayList(sequencedCollection);
        }
        return sequencedCollection;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        int n = 0;
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            n += narrowFrameStore.getValuesCount(frame, slot, facet, bl);
        }
        return n;
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this.getDelegate().addValues(frame, slot, facet, bl, collection);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        List list = this.getSecondaryValues(frame, slot, facet, bl);
        if (list.isEmpty()) {
            this.getDelegate().moveValue(frame, slot, facet, bl, n, n2);
        } else {
            List list2 = this.getValues(frame, slot, facet, bl);
            Object e = list2.get(n);
            Object e2 = list2.get(n2);
            if (!list.contains(e) && !list.contains(e2)) {
                this.getDelegate().moveValue(frame, slot, facet, bl, n -= list.size(), n2 -= list.size());
            }
        }
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        this.getDelegate().removeValue(frame, slot, facet, bl, object);
        if (!this.removeFrameStores.isEmpty()) {
            this.removeValueFromRemoveFrameStores(frame, slot, facet, bl, object);
        }
    }

    private void removeValueFromRemoveFrameStores(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        for (NarrowFrameStore narrowFrameStore : this.removeFrameStores) {
            narrowFrameStore.removeValue(frame, slot, facet, bl, object);
        }
    }

    private void removeValuesFromRemoveFrameStores(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        for (Object e : collection) {
            this.removeValueFromRemoveFrameStores(frame, slot, facet, bl, e);
        }
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        ArrayList arrayList;
        List list = this.getSecondaryValues(frame, slot, facet, bl);
        if (!this.removeFrameStores.isEmpty()) {
            arrayList = new ArrayList(list);
            arrayList.removeAll(collection);
            this.removeValuesFromRemoveFrameStores(frame, slot, facet, bl, arrayList);
        }
        arrayList = new ArrayList(collection);
        arrayList.removeAll(list);
        this.getDelegate().setValues(frame, slot, facet, bl, arrayList);
    }

    public Set getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            hashSet.addAll(narrowFrameStore.getFrames(slot, facet, bl, object));
        }
        return hashSet;
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            hashSet.addAll(narrowFrameStore.getFramesWithAnyValue(slot, facet, bl));
        }
        return hashSet;
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        Iterator<NarrowFrameStore> iterator = this.availableFrameStores.iterator();
        while (iterator.hasNext() && !MergingNarrowFrameStore.hasEnoughMatches(hashSet.size(), n)) {
            NarrowFrameStore narrowFrameStore = iterator.next();
            hashSet.addAll(narrowFrameStore.getMatchingFrames(slot, facet, bl, string, n - hashSet.size()));
        }
        return hashSet;
    }

    private static boolean hasEnoughMatches(int n, int n2) {
        return n2 != -1 && n >= n2;
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        HashSet<Reference> hashSet = new HashSet<Reference>();
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            hashSet.addAll(narrowFrameStore.getReferences(object));
        }
        return hashSet;
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        HashSet<Reference> hashSet = new HashSet<Reference>();
        Iterator<NarrowFrameStore> iterator = this.availableFrameStores.iterator();
        while (iterator.hasNext() && !MergingNarrowFrameStore.hasEnoughMatches(hashSet.size(), n)) {
            NarrowFrameStore narrowFrameStore = iterator.next();
            hashSet.addAll(narrowFrameStore.getMatchingReferences(string, n - hashSet.size()));
        }
        return hashSet;
    }

    @Override
    public void executeQuery(final Query query, final QueryCallback queryCallback) {
        new Thread(){

            public void run() {
                try {
                    SynchronizeQueryCallback synchronizeQueryCallback = new SynchronizeQueryCallback(MergingNarrowFrameStore.this.kbLock);
                    HashSet<Frame> hashSet = new HashSet<Frame>();
                    for (NarrowFrameStore narrowFrameStore : MergingNarrowFrameStore.this.availableFrameStores) {
                        narrowFrameStore.executeQuery(query, synchronizeQueryCallback);
                        hashSet.addAll(synchronizeQueryCallback.waitForResults());
                    }
                    queryCallback.provideQueryResults(hashSet);
                }
                catch (OntologyException ontologyException) {
                    queryCallback.handleError(ontologyException);
                }
                catch (ProtegeIOException protegeIOException) {
                    queryCallback.handleError(protegeIOException);
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.WARNING, "Exception found during query", throwable);
                    queryCallback.handleError(new ProtegeError(throwable));
                }
            }
        };
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        HashSet hashSet = new HashSet();
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            hashSet.addAll(narrowFrameStore.getClosure(frame, slot, facet, bl));
        }
        return hashSet;
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.getDelegate().deleteFrame(frame);
    }

    @Override
    public void close() {
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            narrowFrameStore.close();
        }
        this.availableFrameStores.clear();
    }

    @Override
    public void replaceFrame(Frame frame) {
        for (NarrowFrameStore narrowFrameStore : this.getAllFrameStores()) {
            narrowFrameStore.replaceFrame(frame);
        }
    }

    @Override
    public boolean beginTransaction(String string) {
        return this.getDelegate().beginTransaction(string);
    }

    @Override
    public boolean commitTransaction() {
        return this.getDelegate().commitTransaction();
    }

    @Override
    public boolean rollbackTransaction() {
        return this.getDelegate().rollbackTransaction();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this.getDelegate().getTransactionStatusMonitor();
    }

    @Override
    public void reinitialize() {
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            narrowFrameStore.reinitialize();
        }
    }

    @Override
    public boolean setCaching(RemoteSession remoteSession, boolean bl) {
        boolean bl2 = false;
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            bl2 |= narrowFrameStore.setCaching(remoteSession, bl);
        }
        return bl2;
    }

    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        for (NarrowFrameStore narrowFrameStore : this.availableFrameStores) {
            narrowFrameStore.replaceFrame(frame, frame2);
        }
    }
}

