/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.resource;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public final class Text {
    private static String buildFile = "build.properties";
    private static String directory = "files";
    private static Properties props;
    private static final String PROGRAM_NAME = "Prot\u00e9g\u00e9";
    private static final String PROGRAM_ASCII_NAME = "Protege";
    public static final String PROGRAM_NAME_PROPERTY = "resource.text.program_name";

    public static String getBuildInfo() {
        return "Build " + Text.getBuildNumber();
    }

    public static String getProgramName() {
        return SystemUtilities.getSystemProperty(PROGRAM_NAME_PROPERTY, PROGRAM_NAME);
    }

    public static String getProgramTextName() {
        return SystemUtilities.getSystemProperty(PROGRAM_NAME_PROPERTY, PROGRAM_ASCII_NAME);
    }

    public static String getProgramNameAndVersion() {
        return Text.getProgramName() + " " + Text.getVersion() + " " + Text.getStatus();
    }

    public static String getBuildNumber() {
        return props.getProperty("build.number", "?");
    }

    public static String getStatus() {
        return props.getProperty("build.status");
    }

    public static String getVersion() {
        return props.getProperty("build.version", "?");
    }

    public static String getTrademark() {
        return props.getProperty("trademark");
    }

    public static String getCopyright() {
        return props.getProperty("copyright");
    }

    public static URL getAboutURL() {
        return Text.class.getResource("files/about.html");
    }

    static {
        try {
            props = new Properties();
            InputStream inputStream = FileUtilities.getResourceStream(Text.class, directory, buildFile);
            props.load(inputStream);
        }
        catch (IOException iOException) {
            Log.getLogger().severe(Log.toString(iOException));
        }
    }
}

