/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.admin.AbstractRefreshableServerPanel;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.util.RemoteProjectUtil;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ControlServerPanel
extends AbstractRefreshableServerPanel {
    private static final long serialVersionUID = 6214203367190208198L;

    public ControlServerPanel(RemoteServer remoteServer, RemoteSession remoteSession) {
        super(remoteServer, remoteSession);
    }

    protected JComponent createCenterComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(10));
        JButton jButton = new JButton(this.getShutdownAction());
        jButton.setText("Shut down the Protege server");
        boolean bl = this.hasShutdownRight();
        jButton.setEnabled(bl);
        if (!bl) {
            jButton.setToolTipText("You do not have permission to shut down the server");
        }
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalStrut(20));
        boolean bl2 = this.hasMetaProjectSaveRight();
        JButton jButton2 = new JButton(this.getSaveMetaprojectAction());
        jButton2.setText("Save Metaproject");
        jButton2.setEnabled(bl2);
        if (!bl2) {
            jButton2.setToolTipText("You do not have permission to save the metaproject");
        }
        jPanel.add(jButton2);
        LabeledComponent labeledComponent = new LabeledComponent("Control server operation", jPanel, true);
        return labeledComponent;
    }

    protected void addRefreshButton() {
    }

    private Action getShutdownAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1616026038020695181L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModalDialog.showMessageDialog(ControlServerPanel.this, "The Protege server will shut down immediately.\nAll server projects will be saved.\nConnected Protege clients might loose work because of this.\n\nAre you really sure you want to shut down the server?", "Really shutdown?", 13);
                if (n == 2) {
                    ControlServerPanel.this.shutdownServer();
                }
            }
        };
    }

    private void shutdownServer() {
        try {
            this.getServer().shutdown();
        }
        catch (RemoteException remoteException) {
            Log.getLogger().log(Level.WARNING, "Server shutdown has failed.", remoteException);
            ModalDialog.showMessageDialog(this, "Server shutdown has failed.\nSee console and logs for more information.");
            this.treatPossibleConnectionLostException(remoteException);
            return;
        }
        ModalDialog.showMessageDialog((Component)this, "Server shutdown successful.", "Success");
    }

    private boolean hasShutdownRight() {
        return RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER) || RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_SHUTDOWN_SERVER);
    }

    private Action getSaveMetaprojectAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = -3866525559837315333L;

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                try {
                    bl = ControlServerPanel.this.getServer().saveMetaProject(ControlServerPanel.this.getSession());
                }
                catch (RemoteException remoteException) {
                    Log.getLogger().log(Level.WARNING, "Saving of metaproject has failed.", remoteException);
                    ModalDialog.showMessageDialog(ControlServerPanel.this, "Saving of metaproject has failed.\nSee console and logs for more information.");
                    return;
                }
                ModalDialog.showMessageDialog((Component)ControlServerPanel.this, bl ? "Saving of metaproject was successful." : "Saving of metaproject has failed.", bl ? "Success" : "Failure");
            }
        };
    }

    private boolean hasMetaProjectSaveRight() {
        return RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER);
    }
}

