/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.SynchronizeQueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.FrameCalculatorFrameStore;
import edu.stanford.smi.protege.server.framestore.LastUsageInvocationHandler;
import edu.stanford.smi.protege.server.framestore.ReadAccessEnforcementFrameStore;
import edu.stanford.smi.protege.server.framestore.Registration;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.framestore.background.WorkInfo;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.UnbackedOperationImpl;
import edu.stanford.smi.protege.server.socket.RmiSocketFactory;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import edu.stanford.smi.protege.server.update.OntologyUpdate;
import edu.stanford.smi.protege.server.update.RemoteResponse;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.impl.CompleteableCache;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheBeginTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheCommitTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheDelete;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheModify;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRead;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRollbackTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFrameStore
extends UnicastRemoteObject
implements RemoteServerFrameStore {
    private static final long serialVersionUID = 2965578539383364549L;
    private static transient Logger log = Log.getLogger(ServerFrameStore.class);
    public static final transient Logger cacheLog = Logger.getLogger(CompleteableCache.class.getPackage().getName() + ".ClientServer");
    private final FrameStore _delegate;
    private final KnowledgeBase _kb;
    private final TransactionMonitor transactionMonitor;
    private ProjectInstance projectInstance;
    private final FifoWriter<AbstractEvent> _eventWriter = new FifoWriter();
    private final Map<RemoteSession, Registration> _sessionToRegistrationMap;
    private boolean _isDirty;
    private final Object _kbLock;
    private final Facet valuesFacet;
    private static Map<Thread, RemoteSession> sessionMap = new HashMap<Thread, RemoteSession>();
    private final FrameCalculator frameCalculator;
    private static Set<KnowledgeBase> requiresEventDispatch = new HashSet<KnowledgeBase>();
    private final Set<Thread> runningClientThreads;

    public ServerFrameStore(KnowledgeBase knowledgeBase) throws RemoteException {
        super(SSLFactory.getServerPort(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS));
        this._eventWriter.setLogger(cacheLog, "New Event");
        this._sessionToRegistrationMap = new HashMap<RemoteSession, Registration>();
        this.runningClientThreads = new HashSet<Thread>();
        this._kb = knowledgeBase;
        this._kbLock = knowledgeBase;
        FrameStoreManager frameStoreManager = ((DefaultKnowledgeBase)knowledgeBase).getFrameStoreManager();
        if (!requiresEventDispatch.contains(knowledgeBase)) {
            knowledgeBase.setDispatchEventsEnabled(false);
        } else {
            knowledgeBase.getFrameStoreManager().setDispatchEventsPassThrough(true);
            requiresEventDispatch.remove(knowledgeBase);
        }
        this.valuesFacet = this._kb.getSystemFrames().getValuesFacet();
        this.frameCalculator = new FrameCalculator(frameStoreManager.getHeadFrameStore(), ((DefaultKnowledgeBase)this._kb).getCacheMachine(), this._kbLock, this, this._sessionToRegistrationMap);
        frameStoreManager.insertFrameStore(new FrameCalculatorFrameStore(this.frameCalculator), 1);
        this._delegate = frameStoreManager.getHeadFrameStore();
        this.transactionMonitor = this._delegate.getTransactionStatusMonitor();
        if (ServerProperties.delayInMilliseconds() != 0) {
            Log.getLogger().config("Simulated delay of " + ServerProperties.delayInMilliseconds() + " msec/call");
        }
        this.startHeartbeatThread(this._kb.toString());
    }

    public static void requestEventDispatch(KnowledgeBase knowledgeBase) {
        knowledgeBase.setDispatchEventsEnabled(true);
        knowledgeBase.getFrameStoreManager().setDispatchEventsPassThrough(true);
        requiresEventDispatch.add(knowledgeBase);
    }

    private void startHeartbeatThread(String string) {
        if (!ServerProperties.heartbeatDisabled()) {
            new Thread("Heartbeat checker [" + string + "]"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(3000L);
                            long l = System.currentTimeMillis();
                            Object object = ServerFrameStore.this._kbLock;
                            synchronized (object) {
                                for (Map.Entry entry : ServerFrameStore.this._sessionToRegistrationMap.entrySet()) {
                                    Registration registration = (Registration)entry.getValue();
                                    long l2 = registration.getLastHeartbeat();
                                    if (l2 == 0L || l2 > l - 24000L) continue;
                                    RemoteSession remoteSession = (RemoteSession)entry.getKey();
                                    Log.getLogger().info("Session disconnected because of timeout");
                                    ServerFrameStore.this.deregister(remoteSession);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        Log.getLogger().log(Level.WARNING, "Heartbeat thread died", exception);
                        return;
                    }
                }
            }.start();
        }
    }

    @Override
    public Map<RemoteSession, Boolean> getUserInfo() {
        HashMap<RemoteSession, Boolean> hashMap = new HashMap<RemoteSession, Boolean>();
        for (RemoteSession remoteSession : this._sessionToRegistrationMap.keySet()) {
            if (this.transactionMonitor != null) {
                hashMap.put(remoteSession, this.transactionMonitor.getNesting(remoteSession) > 0);
                continue;
            }
            hashMap.put(remoteSession, Boolean.FALSE);
        }
        return hashMap;
    }

    @Override
    public FrameCalculatorStats getStats() {
        return this.frameCalculator.getStats();
    }

    private FrameStore getDelegate() {
        return this._delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCall(RemoteSession remoteSession) throws ServerSessionLost {
        Object object = sessionMap;
        synchronized (object) {
            if (!this._sessionToRegistrationMap.containsKey(remoteSession)) {
                throw new ServerSessionLost("Dropped connection due to timeout");
            }
        }
        ServerFrameStore.recordCallNoCheck(remoteSession);
        object = this.runningClientThreads;
        synchronized (object) {
            this.runningClientThreads.add(Thread.currentThread());
        }
    }

    public static void recordCallNoCheck(RemoteSession remoteSession) {
        ServerFrameStore.setCurrentSession(remoteSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unrecordCall() {
        Set<Thread> set = this.runningClientThreads;
        synchronized (set) {
            this.runningClientThreads.remove(Thread.currentThread());
            if (this.runningClientThreads.isEmpty()) {
                this.runningClientThreads.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void letOtherThreadsRun() {
        Set<Thread> set = this.runningClientThreads;
        synchronized (set) {
            while (!this.runningClientThreads.isEmpty()) {
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("waitig on threads " + this.runningClientThreads);
                    }
                    this.runningClientThreads.wait();
                }
                catch (InterruptedException interruptedException) {
                    log.log(Level.WARNING, "Unexpected Interrupt - please don't press that red button again", interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentSession(RemoteSession remoteSession) {
        Map<Thread, RemoteSession> map = sessionMap;
        synchronized (map) {
            sessionMap.put(Thread.currentThread(), remoteSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteSession getCurrentSession() {
        Map<Thread, RemoteSession> map = sessionMap;
        synchronized (map) {
            return sessionMap.get(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClsCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getClsCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSlotCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getSlotCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFacetCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getFacetCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSimpleInstanceCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getSimpleInstanceCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrameCount(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getFrameCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectTemplateSlot(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectTemplateSlot(cls, slot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectTemplateSlot(Cls cls, Slot slot, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectTemplateSlot(cls, slot, n);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectSuperclass(Cls cls, Cls cls2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().addDirectSuperclass(cls, cls2);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectSuperslot(Slot slot, Slot slot2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectSuperslot(slot, slot2);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectSuperclass(Cls cls, Cls cls2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectSuperclass(cls, cls2);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectSubclass(Cls cls, Cls cls2, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectSubclass(cls, cls2, n);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate replaceFrame(Frame frame, Frame frame2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Reference> set = this.getDelegate().getReferences(frame);
                this.getDelegate().replaceFrame(frame, frame2);
                this.markDirty();
                this.wipeReferencingFrames(frame, set, remoteSession);
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List> getDirectTemplateSlotValues(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            LocalizeUtils.localize(cls, this._kb);
            Object object = this._kbLock;
            synchronized (object) {
                List list = this.getDelegate().getDirectTemplateSlotValues(cls, slot);
                Sft sft = new Sft(slot, null, true);
                CacheResult<List> cacheResult = new CacheResult<List>(list, true);
                this.addReadUpdate(remoteSession, cls, new CacheRead<RemoteSession, Sft, List>(remoteSession, sft, cacheResult));
                RemoteResponse<List> remoteResponse = new RemoteResponse<List>(list, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set<Instance>> getInstances(Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Instance> set = this.getDelegate().getInstances(cls);
                RemoteResponse<Set<Instance>> remoteResponse = new RemoteResponse<Set<Instance>>(set, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Slot> getOwnSlots(Frame frame, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Slot> set = this.getDelegate().getOwnSlots(frame);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<Frame> getFramesWithDirectOwnSlotValue(Slot slot, Object object, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object2 = this._kbLock;
            synchronized (object2) {
                Set<Frame> set = this.getDelegate().getFramesWithDirectOwnSlotValue(slot, object);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object object, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object2 = this._kbLock;
            synchronized (object2) {
                Set set = this.getDelegate().getClsesWithDirectTemplateSlotValue(slot, object);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object object, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object2 = this._kbLock;
            synchronized (object2) {
                Set set = this.getDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, object);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Frame> set = this.getDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, string, n);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String string, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, string, n);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String string, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, string, n);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List> getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            LocalizeUtils.localize(cls, this._kb);
            Object object = this._kbLock;
            synchronized (object) {
                List list = this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
                Sft sft = new Sft(slot, facet, true);
                CacheResult<List> cacheResult = new CacheResult<List>(list, true);
                this.addReadUpdate(remoteSession, cls, new CacheRead<RemoteSession, Sft, List>(remoteSession, sft, cacheResult));
                RemoteResponse<List> remoteResponse = new RemoteResponse<List>(list, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Cls> getClses(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Cls> set = this.getDelegate().getClses();
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Facet> set = this.getDelegate().getTemplateFacets(cls, slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Frame> getFrame(String string, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Frame frame = this.getDelegate().getFrame(string);
                RemoteResponse<Frame> remoteResponse = new RemoteResponse<Frame>(frame, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame getFrame(FrameID frameID, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Frame frame = this.getDelegate().getFrame(frameID);
                return frame;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            LocalizeUtils.localize(frame, this._kb);
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getDirectOwnSlotValuesCount(frame, slot);
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List> getDirectOwnSlotValues(Frame frame, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("getDirectOwnSlotValues for frame " + frame.getFrameID() + " slot " + slot.getFrameID());
            }
            LocalizeUtils.localize(frame, this._kb);
            LocalizeUtils.localize(slot, this._kb);
            Object object = this._kbLock;
            synchronized (object) {
                List list = this.getDelegate().getDirectOwnSlotValues(frame, slot);
                Sft sft = new Sft(slot, null, false);
                CacheResult<List> cacheResult = new CacheResult<List>(list, true);
                this.addReadUpdate(remoteSession, frame, new CacheRead<RemoteSession, Sft, List>(remoteSession, sft, cacheResult));
                RemoteResponse<List> remoteResponse = new RemoteResponse<List>(list, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection arrayList, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                if (!(arrayList instanceof List)) {
                    arrayList = new ArrayList(arrayList);
                }
                this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, arrayList);
                this.markDirty();
                Sft sft = new Sft(slot, facet, true);
                CacheResult<List> cacheResult = new CacheResult<List>(arrayList, true);
                this.addWriteUpdate(remoteSession, cls, new CacheModify<RemoteSession, Sft, List>(remoteSession, sft, cacheResult));
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Facet> createFacet(FrameID frameID, Collection collection, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.markDirty();
                Facet facet = this.getDelegate().createFacet(frameID, collection, bl);
                RemoteResponse<Facet> remoteResponse = new RemoteResponse<Facet>(facet, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFrames(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Frame> set = this.getDelegate().getFrames();
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setDirectTemplateSlotValues(Cls cls, Slot slot, Collection arrayList, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            if (!(arrayList instanceof List)) {
                arrayList = new ArrayList(arrayList);
            }
            Object object = this._kbLock;
            synchronized (object) {
                this.markDirty();
                this.getDelegate().setDirectTemplateSlotValues(cls, slot, arrayList);
                Sft sft = new Sft(slot, null, true);
                CacheResult<List> cacheResult = new CacheResult<List>(arrayList, true);
                this.addWriteUpdate(remoteSession, cls, new CacheModify<RemoteSession, Sft, List>(remoteSession, sft, cacheResult));
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Collection collection = this.getDelegate().getTemplateFacetValues(cls, slot, facet);
                return collection;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteCls(Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().deleteCls(cls);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteSlot(Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().deleteSlot(slot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteFacet(Facet facet, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().deleteFacet(facet);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteSimpleInstance(SimpleInstance simpleInstance, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().deleteSimpleInstance(simpleInstance);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Slot> createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.markDirty();
                Slot slot = this.getDelegate().createSlot(frameID, collection, collection2, bl);
                RemoteResponse<Slot> remoteResponse = new RemoteResponse<Slot>(slot, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectSuperslot(Slot slot, Slot slot2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().addDirectSuperslot(slot, slot2);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectTemplateSlot(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().addDirectTemplateSlot(cls, slot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectOwnSlotValue(frame, slot, n, n2);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setDirectOwnSlotValues(Frame frame, Slot slot, Collection arrayList, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            if (!(arrayList instanceof List)) {
                arrayList = new ArrayList(arrayList);
            }
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().setDirectOwnSlotValues(frame, slot, arrayList);
                this.markDirty();
                Sft sft = new Sft(slot, null, true);
                CacheResult<List> cacheResult = new CacheResult<List>(arrayList, true);
                this.addReadUpdate(remoteSession, frame, new CacheModify<RemoteSession, Sft, List>(remoteSession, sft, cacheResult));
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Cls> createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.markDirty();
                Cls cls = this.getDelegate().createCls(frameID, collection, collection2, bl);
                RemoteResponse<Cls> remoteResponse = new RemoteResponse<Cls>(cls, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Facet> getFacets(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Facet> set = this.getDelegate().getFacets();
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Collection<Frame>> executeQuery(Query query, RemoteSession remoteSession) throws ProtegeException, ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            SynchronizeQueryCallback synchronizeQueryCallback = new SynchronizeQueryCallback(this._kbLock);
            RemoteResponse<Collection<Frame>> remoteResponse = this._kbLock;
            synchronized (remoteResponse) {
                this.getDelegate().executeQuery(query, synchronizeQueryCallback);
            }
            remoteResponse = new RemoteResponse<Collection<Frame>>(synchronizeQueryCallback.waitForResults(), this.getValueUpdates(remoteSession));
            return remoteResponse;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectType(Instance instance, Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectType(instance, cls);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Reference> getReferences(Object object, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object2 = this._kbLock;
            synchronized (object2) {
                Set<Reference> set = this.getDelegate().getReferences(object);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Reference> getMatchingReferences(String string, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Reference> set = this.getDelegate().getMatchingReferences(string, n);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Cls> getClsesWithMatchingBrowserText(String string, Collection collection, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Cls> set = this.getDelegate().getClsesWithMatchingBrowserText(string, collection, n);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<SimpleInstance> createSimpleInstance(FrameID frameID, Collection collection, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.recordCall(remoteSession);
                this.markDirty();
                SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(frameID, collection, bl);
                RemoteResponse<SimpleInstance> remoteResponse = new RemoteResponse<SimpleInstance>(simpleInstance, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectType(Instance instance, Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().addDirectType(instance, cls);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectType(Instance instance, Cls cls, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectType(instance, cls, n);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFrameName(Frame frame, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                String string = this.getDelegate().getFrameName(frame);
                return string;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getOverriddenTemplateSlots(Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getOverriddenTemplateSlots(cls);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getDirectlyOverriddenTemplateSlots(cls);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getOverriddenTemplateFacets(cls, slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getOverriddenTemplateFacets(cls, slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectTemplateFacetOverrides(Cls cls, Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    @Override
    public void close(RemoteSession remoteSession) throws ServerSessionLost {
        ServerFrameStore.recordCallNoCheck(remoteSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeProtegeJob(ProtegeJob protegeJob, RemoteSession remoteSession) throws ProtegeException, ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                protegeJob.localize(this._kb);
            }
            object = protegeJob.run();
            return object;
        }
        catch (ProtegeException protegeException) {
            Log.getLogger().log(Level.WARNING, "Exception on remote execution", protegeException);
            throw protegeException;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RemoteSession remoteSession) throws ServerSessionLost {
        Object object = this._kbLock;
        synchronized (object) {
            Registration registration = new Registration(this._eventWriter);
            this._sessionToRegistrationMap.put(remoteSession, registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                while (this.inTransaction()) {
                    this.rollbackTransaction(remoteSession);
                }
                this._sessionToRegistrationMap.remove(remoteSession);
                this.frameCalculator.deregister(remoteSession);
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    @Override
    public String toString() {
        return "ServerFrameStore[" + this._kb + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List<AbstractEvent>> getEvents(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.updateEvents(remoteSession);
                ArrayList<AbstractEvent> arrayList = new ArrayList<AbstractEvent>();
                Registration registration = this._sessionToRegistrationMap.get(remoteSession);
                if (registration == null) {
                    throw new IllegalStateException("Not registered");
                }
                FifoReader<AbstractEvent> fifoReader = registration.getEvents();
                AbstractEvent abstractEvent = null;
                while ((abstractEvent = fifoReader.read()) != null) {
                    arrayList.add(abstractEvent);
                }
                RemoteResponse<List<AbstractEvent>> remoteResponse = new RemoteResponse<List<AbstractEvent>>(arrayList, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    public void updateEvents(RemoteSession remoteSession) {
        Registration registration = this._sessionToRegistrationMap.get(remoteSession);
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        for (AbstractEvent abstractEvent : this.getDelegate().getEvents()) {
            this.addEvent(remoteSession, registration, transactionIsolationLevel, abstractEvent);
        }
    }

    private void addEvent(RemoteSession remoteSession, Registration registration, TransactionIsolationLevel transactionIsolationLevel, AbstractEvent abstractEvent) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Server Processing event " + abstractEvent);
        }
        this.processEvent(remoteSession, registration, transactionIsolationLevel, abstractEvent);
        this._eventWriter.write(abstractEvent);
    }

    private List<ValueUpdate> getValueUpdates(RemoteSession remoteSession) {
        this.updateEvents(remoteSession);
        List<ValueUpdate> list = this._sessionToRegistrationMap.get(remoteSession).getAndClearValueUpdates();
        int n = list.size();
        if (n != 0) {
            this._sessionToRegistrationMap.get(remoteSession).getBandWidthPolicy().addItemsSent(list.size());
        }
        return list;
    }

    private void processEvent(RemoteSession remoteSession, Registration registration, TransactionIsolationLevel transactionIsolationLevel, AbstractEvent abstractEvent) {
        if (abstractEvent.getEventType() != 101 && abstractEvent.isReplacementEvent()) {
            return;
        }
        if (abstractEvent instanceof FrameEvent) {
            this.handleFrameEvent(remoteSession, (FrameEvent)abstractEvent);
        } else if (abstractEvent instanceof ClsEvent) {
            this.handleClsEvent(remoteSession, (ClsEvent)abstractEvent);
        }
        if (abstractEvent instanceof KnowledgeBaseEvent) {
            this.handleKnowledgeBaseEvent(remoteSession, (KnowledgeBaseEvent)abstractEvent);
        }
    }

    private void handleFrameEvent(RemoteSession remoteSession, FrameEvent frameEvent) {
        Frame frame = frameEvent.getFrame();
        int n = frameEvent.getEventType();
        Sft sft = null;
        if (n == 101 || n == 102) {
            if (frame instanceof Slot || frame instanceof Facet) {
                this.addWriteUpdate(remoteSession, null, new CacheDelete<RemoteSession, Sft, List>(remoteSession));
            } else {
                this.wipeReferencingFrames(frame, this.getDelegate().getReferences(frame), remoteSession);
            }
            return;
        }
        if (n == 106) {
            Slot slot = frameEvent.getSlot();
            CacheResult cacheResult = CacheResult.getInvalid();
            sft = new Sft(slot, null, false);
            this.addWriteUpdate(remoteSession, frame, new CacheModify<RemoteSession, Sft, List>(remoteSession, sft, cacheResult));
        } else if (n == 110) {
            Slot slot = frameEvent.getSlot();
            CacheResult cacheResult = CacheResult.getInvalid();
            sft = new Sft(slot, null, false);
            this.addWriteUpdate(remoteSession, frame, new CacheModify<RemoteSession, Sft, List>(remoteSession, sft, cacheResult));
        } else if (n == 107) {
            Slot slot = frameEvent.getSlot();
            CacheResult cacheResult = new CacheResult(new ArrayList(), true);
            sft = new Sft(slot, null, false);
            this.addWriteUpdate(remoteSession, frame, new CacheModify<RemoteSession, Sft, List>(remoteSession, sft, cacheResult));
        }
    }

    private void wipeReferencingFrames(Frame frame, Collection<Reference> collection, RemoteSession remoteSession) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        hashSet.add(frame);
        for (Reference object : collection) {
            hashSet.add(object.getFrame());
        }
        for (Frame frame2 : hashSet) {
            this.addWriteUpdate(remoteSession, frame2, new CacheDelete<RemoteSession, Sft, List>(remoteSession));
        }
    }

    private void handleClsEvent(RemoteSession remoteSession, ClsEvent clsEvent) {
        Object object;
        Cls cls = clsEvent.getCls();
        int n = clsEvent.getEventType();
        Sft sft = null;
        if (n == 310) {
            object = clsEvent.getSlot();
            sft = new Sft((Slot)object, this.valuesFacet, true);
        } else if (n == 311) {
            object = clsEvent.getSlot();
            Facet facet = clsEvent.getFacet();
            sft = new Sft((Slot)object, facet, false);
        } else if (n == 313) {
            object = clsEvent.getSlot();
            Facet facet = clsEvent.getFacet();
            sft = new Sft((Slot)object, facet, true);
        }
        if (sft != null) {
            object = CacheResult.getInvalid();
            this.addWriteUpdate(remoteSession, cls, new CacheModify<RemoteSession, Sft, List>(remoteSession, sft, (CacheResult<List>)object));
        }
    }

    private void addWriteUpdate(RemoteSession remoteSession, Frame frame, SerializedCacheUpdate<RemoteSession, Sft, List> serializedCacheUpdate) {
        ValueUpdate valueUpdate = new ValueUpdate(frame, serializedCacheUpdate);
        TransactionIsolationLevel transactionIsolationLevel = this.getTransactionIsolationLevel();
        if (TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, transactionIsolationLevel)) {
            for (Registration registration : this._sessionToRegistrationMap.values()) {
                registration.addUpdate(valueUpdate);
            }
        } else {
            Registration registration = this._sessionToRegistrationMap.get(ServerFrameStore.getCurrentSession());
            registration.addUpdate(valueUpdate);
            registration.addCommittableUpdate(valueUpdate);
        }
    }

    public void addReadUpdate(RemoteSession remoteSession, Frame frame, SerializedCacheUpdate<RemoteSession, Sft, List> serializedCacheUpdate) {
        Registration registration = this._sessionToRegistrationMap.get(ServerFrameStore.getCurrentSession());
        ValueUpdate valueUpdate = new ValueUpdate(frame, serializedCacheUpdate);
        registration.addUpdate(valueUpdate);
    }

    private void handleKnowledgeBaseEvent(RemoteSession remoteSession, KnowledgeBaseEvent knowledgeBaseEvent) {
        int n = knowledgeBaseEvent.getEventType();
        if (n == 601 || n == 603 || n == 605 || n == 607 || n == 602 || n == 604 || n == 606 || n == 608) {
            Frame frame = knowledgeBaseEvent.getFrame();
            this.addWriteUpdate(remoteSession, frame, new CacheDelete<RemoteSession, Sft, List>(remoteSession));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Boolean> beginTransaction(String string, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Begin Transaction for session " + remoteSession);
            }
            Object object = this._kbLock;
            synchronized (object) {
                this.updateEvents(remoteSession);
                boolean bl = this.getDelegate().beginTransaction(string);
                this.addWriteUpdate(remoteSession, null, new CacheBeginTransaction<RemoteSession, Sft, List>(remoteSession));
                RemoteResponse<Boolean> remoteResponse = new RemoteResponse<Boolean>(bl, this.getValueUpdates(remoteSession));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Boolean> commitTransaction(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Commit Transaction for Session " + remoteSession);
            }
            Object object = this._kbLock;
            synchronized (object) {
                Object object2;
                this.addWriteUpdate(remoteSession, null, new CacheCommitTransaction<RemoteSession, Sft, List>(remoteSession));
                boolean bl = this.getDelegate().commitTransaction();
                this.updateEvents(remoteSession);
                if (!this.inTransaction()) {
                    object2 = this._sessionToRegistrationMap.get(remoteSession);
                    List<ValueUpdate> list = ((Registration)object2).getCommits();
                    for (Registration registration : this._sessionToRegistrationMap.values()) {
                        if (registration.equals(object2)) continue;
                        for (ValueUpdate valueUpdate : list) {
                            registration.addUpdate(valueUpdate);
                        }
                    }
                    ((Registration)object2).endTransaction();
                }
                if (!this.existsTransaction()) {
                    this._kbLock.notifyAll();
                }
                object2 = new RemoteResponse<Boolean>(bl, this.getValueUpdates(remoteSession));
                return object2;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Boolean> rollbackTransaction(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Rollback Transaction for session " + remoteSession);
            }
            Object object = this._kbLock;
            synchronized (object) {
                Object object2;
                this.updateEvents(remoteSession);
                this.addWriteUpdate(remoteSession, null, new CacheRollbackTransaction<RemoteSession, Sft, List>(remoteSession));
                boolean bl = this.getDelegate().rollbackTransaction();
                if (!this.inTransaction()) {
                    object2 = this._sessionToRegistrationMap.get(remoteSession);
                    ((Registration)object2).endTransaction();
                }
                if (!this.existsTransaction()) {
                    this._kbLock.notifyAll();
                }
                object2 = new RemoteResponse<Boolean>(bl, this.getValueUpdates(remoteSession));
                return object2;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionIsolationLevel getTransactionIsolationLevel() {
        try {
            Object object = this._kbLock;
            synchronized (object) {
                if (this.transactionMonitor == null) {
                    return TransactionIsolationLevel.NONE;
                }
                return this.transactionMonitor.getTransationIsolationLevel();
            }
        }
        catch (TransactionException transactionException) {
            Log.getLogger().log(Level.WARNING, "Exception caught finding transaction isolation level", transactionException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTransactionIsolationLevel(TransactionIsolationLevel transactionIsolationLevel) throws TransactionException {
        Object object = this._kbLock;
        synchronized (object) {
            if (this.transactionMonitor == null) {
                return false;
            }
            this.transactionMonitor.setTransactionIsolationLevel(transactionIsolationLevel);
        }
        return true;
    }

    public boolean inTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.inTransaction();
    }

    public boolean existsTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.existsTransaction();
    }

    public boolean exclusiveTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.exclusiveTransaction();
    }

    public TransactionMonitor getTransactionStatusMonitor() {
        return this.transactionMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTransactionsToComplete() {
        Object object = this._kbLock;
        synchronized (object) {
            while (this.existsTransaction()) {
                try {
                    this._kbLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    log.log(Level.WARNING, "Interrupted waiting for transactions to complete", interruptedException);
                }
            }
        }
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    private void markDirty() {
        this._isDirty = true;
    }

    public void markClean() {
        this._isDirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectSubslot(Slot slot, Slot slot2, int n, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectSubslot(slot, slot2, n);
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFramesWithAnyDirectOwnSlotValue(Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Frame> set = this.getDelegate().getFramesWithAnyDirectOwnSlotValue(slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Cls> getClsesWithAnyDirectTemplateSlotValue(Slot slot, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Cls> set = this.getDelegate().getClsesWithAnyDirectTemplateSlotValue(slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set> getDirectOwnSlotValuesClosure(Frame frame, Slot slot, Set<Frame> set, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Set set2 = null;
            Object object = this._kbLock;
            synchronized (object) {
                set2 = this.getDelegate().getDirectOwnSlotValuesClosure(frame, slot);
            }
            LocalizeUtils.localize(set, this._kb);
            if (!this.frameCalculator.isDisabled(remoteSession)) {
                for (Frame frame2 : set) {
                    this.frameCalculator.addRequest(frame2, remoteSession, CacheRequestReason.USER_CLOSURE_REQUEST);
                }
            }
            object = new RemoteResponse<Set>(set2, this.getValueUpdates(remoteSession));
            return object;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set> getDirectOwnSlotValuesClosure(Collection<Frame> collection, Slot slot, Set<Frame> set, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            HashSet hashSet = new HashSet();
            Object object = this._kbLock;
            synchronized (object) {
                for (Frame frame : collection) {
                    Set set2 = this.getDelegate().getDirectOwnSlotValuesClosure(frame, slot);
                    if (set2 == null) continue;
                    hashSet.addAll(set2);
                }
            }
            LocalizeUtils.localize(set, this._kb);
            if (!this.frameCalculator.isDisabled(remoteSession)) {
                for (Frame frame : set) {
                    this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.USER_CLOSURE_REQUEST);
                }
            }
            object = new RemoteResponse(hashSet, this.getValueUpdates(remoteSession));
            return object;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate preload(Set<String> set, boolean bl, RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            if (bl) {
                int n = ServerProperties.getPreloadFrameLimit();
                int n2 = 0;
                Object object = this._kbLock;
                synchronized (object) {
                    for (Frame frame : this.getDelegate().getFrames()) {
                        if (++n2 > n) break;
                        this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.PRELOAD);
                    }
                }
            } else {
                this.addUserFrames(remoteSession, set);
                this.addSystemClasses(remoteSession);
            }
            OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(remoteSession));
            return ontologyUpdate;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemClasses(RemoteSession remoteSession) {
        LinkedHashSet<Frame> linkedHashSet = new LinkedHashSet<Frame>();
        linkedHashSet.addAll(this._kb.getSystemFrames().getFrames());
        if (!this.frameCalculator.isDisabled(remoteSession)) {
            for (Frame frame : linkedHashSet) {
                Object object = this.frameCalculator.getRequestLock();
                synchronized (object) {
                    WorkInfo workInfo = this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.PRELOAD);
                    if (workInfo != null) {
                        workInfo.setSkipDirectInstances(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemClasses(Set<Frame> set, Cls cls) {
        if (!cls.isSystem() || set.contains(cls)) {
            return;
        }
        List<Cls> list = null;
        Set<Slot> set2 = this._kbLock;
        synchronized (set2) {
            list = this._delegate.getDirectSubclasses(cls);
        }
        set2 = null;
        Iterator<Instance> iterator = this._kbLock;
        synchronized (iterator) {
            set2 = this._delegate.getOwnSlots(cls);
            set2.addAll(this._delegate.getTemplateSlots(cls));
        }
        for (Slot instance : set2) {
            if (!instance.isSystem()) continue;
            set.add(instance);
        }
        for (Cls cls2 : list) {
            this.addSystemClasses(set, cls2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserFrames(RemoteSession remoteSession, Set<String> set) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        for (String object : set) {
            Frame frame = null;
            Object object2 = this._kbLock;
            synchronized (object2) {
                frame = this._delegate.getFrame(object);
            }
            if (frame == null) continue;
            hashSet.add(frame);
            if (!(frame instanceof Cls)) continue;
            object2 = (Cls)frame;
            for (Object e : this._kb.getSuperclasses((Cls)object2)) {
                Cls cls = (Cls)e;
                hashSet.add(cls);
                hashSet.addAll(cls.getDirectSubclasses());
            }
            Object object3 = this._kbLock;
            synchronized (object3) {
                hashSet.addAll(this._kb.getSuperclasses((Cls)frame));
                hashSet.addAll(this._kb.getDirectSubclasses((Cls)frame));
            }
        }
        if (!this.frameCalculator.isDisabled(remoteSession)) {
            for (Frame frame : hashSet) {
                this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.IMMEDIATE_PRELOAD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestValueCache(Set<Frame> set, boolean bl, RemoteSession remoteSession) {
        Object object = this.frameCalculator.getRequestLock();
        synchronized (object) {
            for (Frame frame : set) {
                LocalizeUtils.localize(frame, this._kb);
                WorkInfo workInfo = this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.USER_SPECIFIC_FRAMES);
                if (workInfo == null) continue;
                workInfo.setSkipDirectInstances(bl);
            }
        }
    }

    public FrameCalculator getFrameCalculator() {
        return this.frameCalculator;
    }

    public void setFrameCalculatorDisabled(boolean bl) {
        FrameCalculator.setDisabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartBeat(RemoteSession remoteSession) throws ServerSessionLost {
        this.recordCall(remoteSession);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Registration registration = this._sessionToRegistrationMap.get(remoteSession);
                registration.setLastHeartbeat(System.currentTimeMillis());
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    public void setMetaProjectInstance(ProjectInstance projectInstance) {
        this.projectInstance = projectInstance;
        if (projectInstance != null) {
            FrameStoreManager frameStoreManager = this._kb.getFrameStoreManager();
            ReadAccessEnforcementFrameStore readAccessEnforcementFrameStore = new ReadAccessEnforcementFrameStore(this);
            if (readAccessEnforcementFrameStore.isApplicable()) {
                frameStoreManager.insertFrameStore((FrameStore)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{FrameStore.class}, (InvocationHandler)readAccessEnforcementFrameStore), 1);
            }
            LastUsageInvocationHandler lastUsageInvocationHandler = new LastUsageInvocationHandler(projectInstance, this.frameCalculator);
            frameStoreManager.insertFrameStore((FrameStore)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{FrameStore.class}, (InvocationHandler)lastUsageInvocationHandler), 1);
        }
    }

    public ProjectInstance getMetaProjectInstance() {
        return this.projectInstance;
    }

    @Override
    public Set<Operation> getAllowedOperations(RemoteSession remoteSession) {
        Policy policy = Server.getPolicy();
        User user = policy.getUserByName(remoteSession.getUserName());
        return ServerFrameStore.unbackOperations(policy.getAllowedOperations(user, this.projectInstance));
    }

    @Override
    public Set<Operation> getKnownOperations(RemoteSession remoteSession) {
        return ServerFrameStore.unbackOperations(Server.getPolicy().getKnownOperations());
    }

    private static Set<Operation> unbackOperations(Set<Operation> set) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        for (Operation operation : set) {
            hashSet.add(new UnbackedOperationImpl(operation));
        }
        return hashSet;
    }
}

