/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.util.Log;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimulateDelayInputStream
extends FilterInputStream {
    static Logger log = Log.getLogger(SimulateDelayInputStream.class);
    private static int KB = 1024;
    private InputStream is;
    private static int bandwidth = ServerProperties.getKiloBytesPerSecondDownload();
    private int bytesRead = 0;

    public SimulateDelayInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.is = inputStream;
    }

    public int read() throws IOException {
        int n = this.is.read();
        if (n != -1) {
            this.delayForUpload(1);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is.read(byArray, n, n2);
        if (n3 > 0) {
            this.delayForUpload(n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            this.delayForUpload((int)l2);
        }
        return l2;
    }

    private synchronized void delayForUpload(int n) {
        int n2;
        this.bytesRead += n;
        if (bandwidth != 0 && (n2 = this.bytesRead / (bandwidth * KB)) > 0) {
            this.bytesRead -= bandwidth * KB * n2;
            try {
                Thread.sleep(1000 * n2);
                log.info("Simulated " + n2 + " seconds of upload delay");
            }
            catch (InterruptedException interruptedException) {
                log.log(Level.WARNING, "Simulation of network delay failed", interruptedException);
            }
        }
    }
}

