/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileToDatabaseTest
extends APITestCase {
    private Logger log = Log.getLogger(FileToDatabaseTest.class);

    public void testFileToDatabaseConversion() {
        ArrayList arrayList = new ArrayList();
        for (APITestCase.DBType dBType : APITestCase.DBType.values()) {
            APITestCase.setDBType(dBType);
            if (!APITestCase.dbConfigured()) continue;
            Project project = new Project("examples/wines/wines.pprj", arrayList);
            this.handleErrors(arrayList);
            KnowledgeBase knowledgeBase = project.getKnowledgeBase();
            KnowledgeBase knowledgeBase2 = this.convert(project);
            FileToDatabaseTest.assertNotNull((Object)knowledgeBase2.getCls("Beaujolais"));
        }
    }

    private KnowledgeBase convert(Project project) {
        ArrayList arrayList = new ArrayList();
        project.setProjectFilePath("junit/pprj/wines-db.pprj");
        DatabaseKnowledgeBaseFactory databaseKnowledgeBaseFactory = new DatabaseKnowledgeBaseFactory();
        PropertyList propertyList = PropertyList.create(project.getInternalProjectKnowledgeBase());
        DatabaseKnowledgeBaseFactory.setSources(propertyList, APITestCase.getDBProperty("driver"), APITestCase.getDBProperty("url"), "JunitNewspaper", APITestCase.getDBProperty("user"), APITestCase.getDBProperty("password"));
        databaseKnowledgeBaseFactory.saveKnowledgeBase(project.getKnowledgeBase(), propertyList, arrayList);
        this.handleErrors(arrayList);
        project.dispose();
        Project project2 = Project.createNewProject(databaseKnowledgeBaseFactory, arrayList);
        DatabaseKnowledgeBaseFactory.setSources(project2.getSources(), APITestCase.getDBProperty("driver"), APITestCase.getDBProperty("url"), "JunitNewspaper", APITestCase.getDBProperty("user"), APITestCase.getDBProperty("password"));
        project2.createDomainKnowledgeBase(databaseKnowledgeBaseFactory, arrayList, true);
        this.handleErrors(arrayList);
        project2.save(arrayList);
        this.handleErrors(arrayList);
        return project2.getKnowledgeBase();
    }

    private void handleErrors(Collection collection) {
        if (!collection.isEmpty()) {
            for (Object e : collection) {
                if (e instanceof Throwable) {
                    this.log.log(Level.WARNING, "exception caught", (Throwable)e);
                    continue;
                }
                this.log.warning("Error = " + e);
            }
            FileToDatabaseTest.fail();
        }
    }
}

