/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.UnaryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtilities {
    public static final ArrayList EMPTY_ARRAY_LIST = new ArrayList();

    public static boolean containSameItems(Collection collection, Collection collection2) {
        Set set = collection instanceof Set ? (Set)collection : new HashSet(collection);
        Set set2 = collection2 instanceof Set ? (Set)collection2 : new HashSet(collection2);
        return ((Object)set).equals(set2);
    }

    public static boolean containsAny(Collection collection, Collection collection2) {
        Collection collection3;
        Collection collection4;
        if (collection.size() < collection2.size()) {
            collection4 = collection;
            collection3 = collection2;
        } else {
            collection4 = collection2;
            collection3 = collection;
        }
        boolean bl = false;
        Iterator iterator = collection4.iterator();
        while (iterator.hasNext()) {
            if (!collection3.contains(iterator.next())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static <X> Collection<X> createCollection(X x) {
        return CollectionUtilities.createList(x);
    }

    public static <X> List<X> createList(X x) {
        List list;
        if (x == null) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList(1);
            list.add(x);
        }
        return list;
    }

    public static <X, Y> Map<X, Y> createSmallMap() {
        return new HashMap(11);
    }

    public static boolean equalsSet(Collection collection, Collection collection2) {
        boolean bl;
        if (collection == null) {
            bl = collection2 == null;
        } else if (collection2 == null) {
            bl = false;
        } else if (collection.size() == collection2.size()) {
            bl = true;
            Iterator iterator = collection.iterator();
            while (bl && iterator.hasNext()) {
                Object e = iterator.next();
                bl = collection2.contains(e);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean equalsList(Collection<?> collection, Collection<?> collection2) {
        boolean bl;
        if (collection == null) {
            bl = collection2 == null;
        } else if (collection2 == null) {
            bl = false;
        } else if (collection.size() == collection2.size()) {
            bl = true;
            Iterator<?> iterator = collection.iterator();
            Iterator<?> iterator2 = collection2.iterator();
            while (bl && iterator.hasNext() && iterator2.hasNext()) {
                Object obj = iterator.next();
                Object obj2 = iterator2.next();
                bl = obj.equals(obj2);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static <X> X getFirstItem(Collection<X> collection) {
        X x = collection == null || collection.isEmpty() ? null : (collection instanceof List ? (X)((List)collection).get(0) : (X)collection.iterator().next());
        return x;
    }

    public static <X> X getSoleItem(Collection<X> collection) {
        Assert.assertEquals("size", collection.size(), 1);
        return CollectionUtilities.getFirstItem(collection);
    }

    public static <X> Collection<X> removeFirst(Collection<X> collection) {
        List list;
        if (collection == null || collection.size() == 0) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList<X>(collection);
            list.remove(0);
        }
        return list;
    }

    public static String toString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        if (collection != null) {
            boolean bl = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                Object object = iterator.next();
                if (object instanceof Frame) {
                    Frame frame = (Frame)object;
                    if (frame.isDeleted()) {
                        object = "<deleted frame " + frame.getFrameID() + ">";
                    } else {
                        object = frame.getBrowserText();
                        if (object == null) {
                            object = "<null browser text on " + frame.getFrameID() + ">";
                        }
                    }
                }
                stringBuffer.append(object);
            }
        }
        return stringBuffer.toString();
    }

    public static <X, Y> void apply(Collection<? extends X> collection, UnaryFunction<X, Y> unaryFunction) {
        for (X x : collection) {
            unaryFunction.apply(x);
        }
    }
}

