/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.WidgetClassNameRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.widget.FormWidget;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;

class WidgetDescriptorEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -7611162969958514326L;
    private FormWidget _widget;

    public WidgetDescriptorEditor(FormWidget formWidget) {
        super(ComponentFactory.createComboBox());
        this._widget = formWidget;
        this.getComboBox().setRenderer(new WidgetClassNameRenderer());
    }

    private JComboBox getComboBox() {
        return (JComboBox)this.getComponent();
    }

    private ComboBoxModel getComboBoxModel(Cls cls, Slot slot) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(WidgetClassNameRenderer.NONE);
        Project project = this._widget.getProject();
        Iterator iterator = project.getSuitableWidgetClassNames(cls, slot, null).iterator();
        while (iterator.hasNext()) {
            defaultComboBoxModel.addElement((String)iterator.next());
        }
        return defaultComboBoxModel;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        JComboBox jComboBox = this.getComboBox();
        Slot slot = (Slot)jTable.getModel().getValueAt(n, 0);
        jComboBox.setModel(this.getComboBoxModel(this._widget.getCls(), slot));
        jComboBox.setSelectedItem(object);
        return this.getComponent();
    }
}

