/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.ClsCode;
import edu.stanford.smi.protege.code.generator.wrapping.JavaCodeGeneratorOptions;
import edu.stanford.smi.protege.code.generator.wrapping.SlotAtClassCode;
import edu.stanford.smi.protege.code.generator.wrapping.SlotCode;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;

public class JavaCodeGenerator {
    private KnowledgeBase kb;
    private JavaCodeGeneratorOptions options;
    private static final boolean TRANSITIVE = true;
    private static final boolean ALL_PROPERTIES = true;
    private static final boolean ONLY_LOCAL_PROPERTIES = false;

    public JavaCodeGenerator(KnowledgeBase knowledgeBase, JavaCodeGeneratorOptions javaCodeGeneratorOptions) {
        String string;
        this.kb = knowledgeBase;
        this.options = javaCodeGeneratorOptions;
        File file = javaCodeGeneratorOptions.getOutputFolder();
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        if ((string = javaCodeGeneratorOptions.getPackage()) != null) {
            string = string.replace('.', '/');
            File file2 = file == null ? new File(string) : new File(file, string);
            file2.mkdirs();
            File file3 = new File(file2, "impl");
            file3.mkdirs();
        } else {
            File file4 = file == null ? new File("impl") : new File(file, "impl");
            file4.mkdirs();
        }
    }

    public void createAll() throws IOException {
        for (Cls cls : this.options.getClses()) {
            Cls cls2 = cls;
            if (cls2.isSystem()) continue;
            this.createInterface(cls2);
            this.createImplementation(cls2);
        }
        this.createFactoryClass();
        this.createOntologyJavaMappingClass();
    }

    private void createOntologyJavaMappingClass() throws IOException {
        File file = this.getInterfaceFile("OntologyJavaMapping");
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("import " + this.options.getPackage() + ".impl.*;");
        printWriter.println("import edu.stanford.smi.protege.code.generator.wrapping.OntologyJavaMappingUtil;");
        printWriter.println();
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege (http://protege.stanford.edu).");
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public class OntologyJavaMapping {");
        printWriter.println();
        printWriter.println("    public static void initMap() {");
        for (Cls cls : this.options.getClses()) {
            if (cls.isSystem()) continue;
            printWriter.println("        OntologyJavaMappingUtil.add(\"" + cls.getName() + "\", " + this.getInterfaceName(cls) + ".class, " + this.getImplementationName(cls) + ".class);");
        }
        printWriter.println("    }");
        printWriter.println("}");
        fileWriter.close();
    }

    public void createFactoryClass() throws IOException {
        String string = this.options.getFactoryClassName();
        if (string != null && string.length() > 0) {
            File file = this.getInterfaceFile(string);
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printFactoryClass(printWriter);
            fileWriter.close();
        }
    }

    private void printFactoryClass(PrintWriter printWriter) {
        String string;
        Object object;
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("import java.util.*;");
        printWriter.println("import " + this.options.getPackage() + ".impl.*;");
        printWriter.println("import " + this.options.getPackage() + ".OntologyJavaMapping;");
        printWriter.println("import edu.stanford.smi.protege.model.*;");
        printWriter.println("import edu.stanford.smi.protege.code.generator.wrapping.OntologyJavaMappingUtil;");
        printWriter.println();
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege (http://protege.stanford.edu).");
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public class " + this.options.getFactoryClassName() + " {");
        printWriter.println("    static { OntologyJavaMapping.initMap(); }");
        printWriter.println();
        printWriter.println("    private KnowledgeBase kb;");
        printWriter.println();
        printWriter.println("    public " + this.options.getFactoryClassName() + "(KnowledgeBase kb) {");
        printWriter.println("        this.kb = kb;");
        printWriter.println("    }");
        for (Cls instance : this.options.getClses()) {
            if (instance.isSystem()) continue;
            object = this.getInterfaceName(instance);
            printWriter.println();
            printWriter.println();
            printWriter.println("    // ***** Class " + instance.getName() + " *****");
            printWriter.println();
            printWriter.println("    public Cls get" + (String)object + "Class() {");
            printWriter.println("        final String name = \"" + instance.getName() + "\";");
            printWriter.println("        return kb.getCls(name);");
            printWriter.println("    }");
            printWriter.println();
            if (!instance.isAbstract()) {
                printWriter.println("    public " + (String)object + " create" + (String)object + "(String name) {");
                printWriter.println("        Cls cls = get" + (String)object + "Class();");
                printWriter.println("        Instance inst = cls.createDirectInstance(name);");
                printWriter.println("        return new " + this.getImplementationName(instance) + "(inst);");
                printWriter.println("    }");
                printWriter.println();
            }
            printWriter.println("    public " + (String)object + " get" + (String)object + "(String name) {");
            printWriter.println("        return OntologyJavaMappingUtil.getSpecificObject(kb, kb.getInstance(name), " + (String)object + ".class);");
            printWriter.println("    }");
            string = this.options.getSetMode() ? "Set" : "Collection";
            String string2 = this.options.getSetMode() ? "HashSet" : "ArrayList";
            printWriter.println();
            printWriter.println("    public " + string + "<" + (String)object + "> getAll" + (String)object + "Objects() {");
            printWriter.println("        return getAll" + (String)object + "Objects(false);");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + string + "<" + (String)object + "> getAll" + (String)object + "Objects(boolean transitive) {");
            printWriter.println("        " + string + "<" + (String)object + "> result = new " + string2 + "<" + (String)object + ">();");
            printWriter.println("        final Cls cls = get" + (String)object + "Class();");
            printWriter.println("        for (Object element : transitive ? cls.getInstances() : cls.getDirectInstances()) {");
            printWriter.println("            Instance inst = (Instance) element;");
            printWriter.println("            result.add(OntologyJavaMappingUtil.getSpecificObject(kb, inst, " + (String)object + ".class));");
            printWriter.println("        }");
            printWriter.println("        return result;");
            printWriter.println("    }");
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("    // ***** Getter methods for slots *****");
        for (Slot slot : this.kb.getSlots()) {
            if (slot.isSystem()) continue;
            object = new SlotCode(slot, false);
            string = ((SlotCode)object).getUpperCaseJavaName();
            printWriter.println();
            printWriter.println("    public Slot get" + string + "Slot() {");
            printWriter.println("        final String name = \"" + slot.getName() + "\";");
            printWriter.println("        return kb.getSlot(name);");
            printWriter.println("    }");
        }
        printWriter.println("}");
    }

    private void printAdditionalFactoryMehods(PrintWriter printWriter) throws IOException {
        String string;
        InputStream inputStream = JavaCodeGenerator.class.getResourceAsStream("resources/FactoryAdditionalMethods.template");
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        while ((string = bufferedReader.readLine()) != null) {
            printWriter.println(string);
        }
        dataInputStream.close();
    }

    public void createImplementation(Cls cls) throws IOException {
        File file = this.getImplementationFile(cls);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printImplementationCode(printWriter, cls);
        fileWriter.close();
    }

    public void printImplementationCode(PrintWriter printWriter, Cls cls) {
        boolean bl;
        ClsCode clsCode = new ClsCode(cls);
        boolean bl2 = bl = this.hasMultipleSuperclasses(cls);
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ".impl;");
        } else {
            printWriter.println("package impl;");
        }
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protege.code.generator.wrapping.AbstractWrappedInstance;");
        printWriter.println("import edu.stanford.smi.protege.model.*;");
        this.perhapsAddImportJavaUtil(clsCode, printWriter, bl);
        String string = this.options.getPackage();
        if (string != null) {
            printWriter.println("import " + string + "." + this.getInterfaceNamePossiblyAbstract(cls) + ";");
            printWriter.println("import " + string + ".*;");
            printWriter.println();
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege (http://protege.stanford.edu).");
        printWriter.println(" * Source Class: " + cls.getName());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        String string2 = this.getImplementationNamePossiblyAbstract(cls);
        printWriter.println("public class " + string2 + this.getImplementationExtendsCode(cls));
        printWriter.println("         implements " + this.getInterfaceNamePossiblyAbstract(cls) + " {");
        this.printConstructors(printWriter, string2);
        Iterator<SlotAtClassCode> iterator = clsCode.getSlotCodes(bl).iterator();
        while (iterator.hasNext()) {
            SlotAtClassCode slotAtClassCode;
            SlotAtClassCode slotAtClassCode2 = slotAtClassCode = iterator.next();
            this.printImplementationSlotCode(printWriter, slotAtClassCode2);
        }
        printWriter.println("}");
    }

    private void printConstructors(PrintWriter printWriter, String string) {
        printWriter.println();
        printWriter.println("    public " + string + "(Instance instance) {");
        printWriter.println("        super(instance);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public " + string + "() {");
        printWriter.println("    }");
    }

    private String getImplementationExtendsCode(Cls cls) {
        String string = " extends ";
        String string2 = this.getBaseImplementation(cls);
        if (string2 == null) {
            return string + "AbstractWrappedInstance";
        }
        return string + string2;
    }

    public void createInterface(Cls cls) throws IOException {
        File file = this.getInterfaceFile(cls);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printInterfaceCode(printWriter, cls);
        fileWriter.close();
    }

    private void createUserInterface(Cls cls) throws IOException {
        String string = this.getInterfaceName(cls);
        File file = this.getInterfaceFile(string);
        if (!file.exists()) {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printUserInterfaceCode(printWriter, cls);
            fileWriter.close();
        }
    }

    public void printInterfaceCode(PrintWriter printWriter, Cls cls) {
        ClsCode clsCode = new ClsCode(cls);
        this.printInterfacePackageStatement(printWriter);
        this.perhapsAddImportJavaUtil(clsCode, printWriter, false);
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege (http://protege.stanford.edu).");
        printWriter.println(" * Source Class: " + cls.getName());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public interface " + this.getInterfaceNamePossiblyAbstract(cls) + this.getInterfaceExtendsCode(cls) + " {");
        Iterator<SlotAtClassCode> iterator = clsCode.getSlotCodes(false).iterator();
        while (iterator.hasNext()) {
            SlotAtClassCode slotAtClassCode = iterator.next();
            this.createInterfaceSlotCode(printWriter, slotAtClassCode);
            if (!iterator.hasNext()) continue;
            printWriter.println();
        }
        printWriter.println();
        printWriter.println("    void delete();");
        printWriter.println("}");
    }

    private void printInterfacePackageStatement(PrintWriter printWriter) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ";");
            printWriter.println();
        }
    }

    public void printUserInterfaceCode(PrintWriter printWriter, Cls cls) {
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("public interface " + this.getInterfaceName(cls) + " extends " + this.getInterfaceNamePossiblyAbstract(cls) + " {");
        printWriter.println("}");
    }

    private String getInterfaceExtendsCode(Cls cls) {
        String string = " extends ";
        String string2 = this.getBaseInterface(cls);
        if (string2 == null) {
            return "";
        }
        return string + string2;
    }

    public void printImplementationSlotCode(PrintWriter printWriter, SlotAtClassCode slotAtClassCode) {
        String string;
        String string2;
        Slot slot = slotAtClassCode.getSlot();
        String string3 = slotAtClassCode.getUpperCaseJavaName();
        String string4 = this.getJavaTypeName(slotAtClassCode, false, slotAtClassCode.isMultiple());
        String string5 = this.getJavaTypeName(slotAtClassCode, true, slotAtClassCode.isMultiple());
        String string6 = slotAtClassCode.getJavaType();
        boolean bl = slotAtClassCode.isMultiple();
        String string7 = "get" + string3 + "Slot()";
        printWriter.println();
        printWriter.println("    // Slot " + slot.getName());
        printWriter.println();
        printWriter.println("    public " + string4 + " get" + string3 + "() {");
        if (bl) {
            printWriter.println("        Collection protegeValues = getWrappedProtegeInstance().getOwnSlotValues(" + string7 + ");");
            printWriter.println("        " + string4 + " values = new " + (this.options.getSetMode() ? "HashSet" : "ArrayList") + "<" + slotAtClassCode.getJavaType(true) + ">();");
            if (slotAtClassCode.isCustomType()) {
                printWriter.println("        Cls cls = getKnowledgeBase().getCls(\"" + slotAtClassCode.getRangeClsName() + "\");");
            }
            printWriter.println("        for (Object object : protegeValues) {");
            if (slotAtClassCode.isCustomType()) {
                printWriter.println("            if (object instanceof Instance && ((Instance)object).hasType(cls)) {");
                printWriter.println("                values.add(new " + this.getImplementationName(slotAtClassCode.getRangeCls()) + "((Instance)object));");
            } else {
                printWriter.println("            if (object instanceof " + string4 + ") {");
                printWriter.println("                values.add((" + string4 + ") object);");
            }
            printWriter.println("            }");
            printWriter.println("        }");
            printWriter.println("        return values;");
        } else if (slotAtClassCode.isCustomType()) {
            printWriter.println("        Object object = getWrappedProtegeInstance().getOwnSlotValue(" + string7 + ");");
            printWriter.println("        Cls cls = getKnowledgeBase().getCls(\"" + slotAtClassCode.getRangeClsName() + "\");");
            printWriter.println("        if (object instanceof Instance && ((Instance)object).hasType(cls)) {");
            printWriter.println("            return new " + this.getImplementationName(slotAtClassCode.getRangeCls()) + "((Instance)object);");
            printWriter.println("        }");
            printWriter.println("        return null;");
        } else if (slotAtClassCode.needsPrimitiveMethod()) {
            string2 = slotAtClassCode.getJavaType(true);
            printWriter.println("        " + string2 + " value = (" + string2 + ") getWrappedProtegeInstance().getOwnSlotValue(" + string7 + ");");
            printWriter.println("        return value == null ? null :");
            printWriter.println("            (" + string2 + ") value." + slotAtClassCode.getPrimitiveMethod() + ";");
        } else {
            printWriter.println("        return (" + string4 + ") getWrappedProtegeInstance().getOwnSlotValue(" + string7 + ");");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public Slot get" + string3 + "Slot() {");
        printWriter.println("        final String name = \"" + slot.getName() + "\";");
        printWriter.println("        return getKnowledgeBase().getSlot(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public boolean has" + string3 + "() {");
        printWriter.println("        return hasSlotValues(" + string7 + ");");
        printWriter.println("    }");
        string2 = "new" + string3;
        if (bl) {
            printWriter.println();
            printWriter.println();
            printWriter.println("    public void add" + string3 + "(" + string6 + " " + string2 + ") {");
            printWriter.println("        addSlotValue(" + string7 + ", " + string2 + ");");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println();
            string = "old" + string3;
            printWriter.println("    public void remove" + string3 + "(" + string6 + " " + string + ") {");
            printWriter.println("        removeSlotValue(" + string7 + ", " + string + ");");
            printWriter.println("    }");
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("    public void set" + string3 + "(" + string5 + " " + string2 + ") {");
        if (bl) {
            printWriter.println("        setSlotValues(" + string7 + ", " + string2 + ");");
        } else if (slotAtClassCode.isPrimitive()) {
            string = null;
            string = "int".equals(string4) ? "java.lang.Integer" : ("boolean".equals(string4) ? "java.lang.Boolean" : "java.lang.Float");
            printWriter.println("        setSlotValue(" + string7 + ", new " + string + "(" + string2 + "));");
        } else {
            printWriter.println("        setSlotValue(" + string7 + ", " + string2 + ");");
        }
        printWriter.println("    }");
    }

    public void createInterfaceSlotCode(PrintWriter printWriter, SlotAtClassCode slotAtClassCode) {
        Slot slot = slotAtClassCode.getSlot();
        String string = slotAtClassCode.getUpperCaseJavaName();
        printWriter.println();
        printWriter.println("    // Slot " + slot.getName());
        printWriter.println();
        printWriter.println("    " + this.getJavaTypeName(slotAtClassCode, false, slotAtClassCode.isMultiple()) + " get" + string + "();");
        printWriter.println();
        printWriter.println("    boolean has" + string + "();");
        if (slotAtClassCode.isMultiple()) {
            String string2 = slotAtClassCode.getJavaType();
            printWriter.println();
            printWriter.println("    void add" + string + "(" + string2 + " new" + string + ");");
            printWriter.println();
            printWriter.println("    void remove" + string + "(" + string2 + " old" + string + ");");
        }
        printWriter.println();
        printWriter.println("    void set" + string + "(" + this.getJavaTypeName(slotAtClassCode, true, slotAtClassCode.isMultiple()) + " new" + string + ");");
    }

    private String getJavaTypeName(SlotAtClassCode slotAtClassCode, boolean bl, boolean bl2) {
        String string = slotAtClassCode.getJavaType(slotAtClassCode.isMultiple());
        if (slotAtClassCode.isMultiple()) {
            if (!slotAtClassCode.isCustomType()) {
                bl = false;
            }
            String string2 = string.equals("Object") ? "<?>" : (bl ? "<? extends " + string + ">" : "<" + string + ">");
            return this.options.getSetMode() ? "Set" + string2 : "Collection" + string2;
        }
        return string;
    }

    public String getBaseImplementation(Cls cls) {
        String string = "";
        for (Cls cls2 : cls.getDirectSuperclasses()) {
            Cls cls3 = cls2;
            String string2 = this.getSystemJavaClass(cls3);
            if (string2 != null) {
                return "Default" + string2;
            }
            if (!(cls3 instanceof Cls) || this.kb.getRootCls().equals(cls3)) continue;
            if (string.equals("")) {
                string = this.getImplementationName(cls3);
                continue;
            }
            return null;
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public String getBaseInterface(Cls cls) {
        String string = "";
        for (Cls cls2 : cls.getDirectSuperclasses()) {
            Cls cls3 = cls2;
            String string2 = this.getSystemJavaClass(cls3);
            if (string2 != null) {
                return string2;
            }
            if (!(cls3 instanceof Cls) || this.kb.getRootCls().equals(cls3)) continue;
            string = string + (string.equals("") ? "" : ", ") + this.getInterfaceName(cls3);
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public File getImplementationFile(Cls cls) {
        String string = this.getImplementationNamePossiblyAbstract(cls);
        return this.getImplementationFile(string);
    }

    private File getImplementationFile(String string) {
        String string2 = this.options.getPackage();
        string2 = string2 != null ? string2.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), string2 + "impl/" + string + ".java");
    }

    public String getImplementationName(Cls cls) {
        return "Default" + this.getInterfaceName(cls);
    }

    public String getImplementationNamePossiblyAbstract(Cls cls) {
        return "Default" + this.getInterfaceNamePossiblyAbstract(cls);
    }

    public File getInterfaceFile(Cls cls) {
        String string = this.getInterfaceNamePossiblyAbstract(cls);
        return this.getInterfaceFile(string);
    }

    private File getInterfaceFile(String string) {
        String string2 = this.options.getPackage();
        string2 = string2 != null ? string2.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), string2 + string + ".java");
    }

    public String getInterfaceNamePossiblyAbstract(Cls cls) {
        String string = new ClsCode(cls).getJavaName();
        return string;
    }

    public String getInterfaceName(Cls cls) {
        return new ClsCode(cls).getJavaName();
    }

    private String getSystemJavaClass(Cls cls) {
        if (cls.equals(this.kb.getSystemFrames().getStandardSlotMetaCls())) {
            return "Slot";
        }
        if (cls.equals(this.kb.getSystemFrames().getStandardClsMetaCls())) {
            return "Cls";
        }
        return null;
    }

    public static String getValidJavaName(String string) {
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            string = string.replace(c, '_');
        }
        return string;
    }

    private void perhapsAddImportJavaUtil(ClsCode clsCode, PrintWriter printWriter, boolean bl) {
        for (SlotAtClassCode slotAtClassCode : clsCode.getSlotCodes(bl)) {
            SlotAtClassCode slotAtClassCode2 = slotAtClassCode;
            if (!slotAtClassCode2.isMultiple()) continue;
            printWriter.println("import java.util.*;");
            printWriter.println();
            return;
        }
    }

    public boolean hasMultipleSuperclasses(Cls cls) {
        boolean bl = false;
        for (Cls cls2 : cls.getDirectSuperclasses()) {
            Cls cls3 = cls2;
            String string = this.getSystemJavaClass(cls3);
            if (string != null) {
                return false;
            }
            if (!(cls3 instanceof Cls) || this.kb.getRootCls().equals(cls3)) continue;
            if (!bl) {
                bl = true;
                continue;
            }
            return true;
        }
        return false;
    }
}

