/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerActivityFrameStore;
import edu.stanford.smi.protege.server.Server_Test;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.util.ControlFrameCalculatorCachingJob;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class FrameCalculatorCacheControl_Test
extends TestCase {
    private static transient Logger log = Log.getLogger(FrameCalculatorCacheControl_Test.class);
    private static final String SERVER_PROJECT = "examples/server/metaproject.pprj";
    private static final String HOST = "localhost";
    private static final String NAME = "//localhost/" + Server.getBoundName();
    private static final String USER = "Ray Fergerson";
    private static final String PASSWORD = "claudia";
    private static final String CLIENT_PROJECT = "Newspaper";
    private ServerActivityFrameStore activityDetector;

    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("server.client.preload.skip", "TRUE");
        try {
            Server_Test.setMetaProject(SERVER_PROJECT);
            Server_Test.startServer();
            Naming.lookup(NAME);
            KnowledgeBase knowledgeBase = Server.getInstance().getProject(CLIENT_PROJECT).getKnowledgeBase();
            this.activityDetector = new ServerActivityFrameStore(knowledgeBase);
            knowledgeBase.getFrameStoreManager().insertFrameStore((FrameStore)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{FrameStore.class}, (InvocationHandler)this.activityDetector), 1);
        }
        catch (NotBoundException notBoundException) {
            FrameCalculatorCacheControl_Test.fail((String)"Could not bind to server (is rmiregistry running?)");
        }
    }

    public void tearDown() {
        try {
            Server.getInstance().reinitialize();
        }
        catch (RemoteException remoteException) {
            FrameCalculatorCacheControl_Test.fail();
        }
    }

    public DefaultKnowledgeBase getKb() {
        RemoteProjectManager remoteProjectManager = RemoteProjectManager.getInstance();
        Project project = remoteProjectManager.getProject(HOST, USER, PASSWORD, CLIENT_PROJECT, true);
        return (DefaultKnowledgeBase)project.getKnowledgeBase();
    }

    public void waitForCache(KnowledgeBase knowledgeBase) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            FrameCalculatorCacheControl_Test.fail();
        }
        knowledgeBase.flushEvents();
    }

    public void flushCache(KnowledgeBase knowledgeBase) {
        RemoteClientFrameStore remoteClientFrameStore = (RemoteClientFrameStore)((DefaultKnowledgeBase)knowledgeBase).getTerminalFrameStore();
        remoteClientFrameStore.flushCache();
    }

    public void testFrameCalculatorCacheControl() {
        Log.setLoggingLevel(FrameCalculatorCacheControl_Test.class, Level.FINE);
        DefaultKnowledgeBase defaultKnowledgeBase = this.getKb();
        this.checkDisabledCacheWorks(defaultKnowledgeBase, true);
        this.checkEnabledCacheWorks(defaultKnowledgeBase, false);
    }

    private void checkEnabledCacheWorks(KnowledgeBase knowledgeBase, boolean bl) {
        Slot slot = knowledgeBase.getSystemFrames().getDocumentationSlot();
        boolean bl2 = (Boolean)new ControlFrameCalculatorCachingJob(knowledgeBase, true).execute();
        FrameCalculatorCacheControl_Test.assertTrue((bl2 == bl ? 1 : 0) != 0);
        this.waitForCache(knowledgeBase);
        this.flushCache(knowledgeBase);
        if (log.isLoggable(Level.FINE)) {
            Log.setLoggingLevel(ServerFrameStore.class, Level.FINE);
            Log.setLoggingLevel(ServerActivityFrameStore.class, Level.FINE);
        }
        this.activityDetector.clearServerActivity();
        Cls cls = knowledgeBase.getCls("Reporter");
        FrameCalculatorCacheControl_Test.assertEquals((int)3, (int)cls.getInstances().size());
        FrameCalculatorCacheControl_Test.assertTrue((boolean)this.activityDetector.serverInvoked());
        this.waitForCache(knowledgeBase);
        this.activityDetector.clearServerActivity();
        FrameCalculatorCacheControl_Test.assertTrue((boolean)((String)cls.getDirectOwnSlotValue(slot)).startsWith("A reporter is"));
        FrameCalculatorCacheControl_Test.assertFalse((boolean)this.activityDetector.serverInvoked());
        if (log.isLoggable(Level.FINE)) {
            Log.setLoggingLevel(ServerFrameStore.class, Level.WARNING);
            Log.setLoggingLevel(ServerActivityFrameStore.class, Level.WARNING);
        }
    }

    private void checkDisabledCacheWorks(KnowledgeBase knowledgeBase, boolean bl) {
        Slot slot = knowledgeBase.getSystemFrames().getDocumentationSlot();
        boolean bl2 = (Boolean)new ControlFrameCalculatorCachingJob(knowledgeBase, false).execute();
        FrameCalculatorCacheControl_Test.assertTrue((bl == bl2 ? 1 : 0) != 0);
        this.waitForCache(knowledgeBase);
        this.flushCache(knowledgeBase);
        if (log.isLoggable(Level.FINE)) {
            Log.setLoggingLevel(ServerFrameStore.class, Level.FINE);
            Log.setLoggingLevel(ServerActivityFrameStore.class, Level.FINE);
        }
        this.activityDetector.clearServerActivity();
        Cls cls = knowledgeBase.getCls("Editor");
        FrameCalculatorCacheControl_Test.assertEquals((int)4, (int)cls.getInstances().size());
        FrameCalculatorCacheControl_Test.assertTrue((boolean)this.activityDetector.serverInvoked());
        this.waitForCache(knowledgeBase);
        this.activityDetector.clearServerActivity();
        FrameCalculatorCacheControl_Test.assertTrue((boolean)((String)cls.getDirectOwnSlotValue(slot)).startsWith("Editors are responsible"));
        FrameCalculatorCacheControl_Test.assertTrue((boolean)this.activityDetector.serverInvoked());
        if (log.isLoggable(Level.FINE)) {
            Log.setLoggingLevel(ServerFrameStore.class, Level.WARNING);
            Log.setLoggingLevel(ServerActivityFrameStore.class, Level.WARNING);
        }
    }
}

