/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore.background;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.util.Log;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCacheRequestor {
    Logger log = Log.getLogger(ClientCacheRequestor.class);
    private Set<Frame> frames = new HashSet<Frame>();
    private Set<Frame> framesWithDirectInstances = new HashSet<Frame>();
    private Object lock = new Object();
    private RequestorThread th = null;
    private RemoteServerFrameStore delegate;
    private RemoteSession session;

    public ClientCacheRequestor(RemoteServerFrameStore remoteServerFrameStore, RemoteSession remoteSession) {
        this.delegate = remoteServerFrameStore;
        this.session = remoteSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFrameValues(Set<Frame> set, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (bl) {
                this.frames.addAll(set);
            } else {
                this.framesWithDirectInstances.addAll(set);
            }
            if (this.th == null || this.th.getStatus() == ThreadStatus.SHUTDOWN) {
                this.th = new RequestorThread();
                this.th.start();
            }
        }
    }

    public class RequestorThread
    extends Thread {
        private ThreadStatus status = ThreadStatus.IDLE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ClientCacheRequestor.this.lock;
            synchronized (object) {
                this.status = ThreadStatus.RUNNING;
            }
            while (true) {
                object = null;
                Set set = null;
                Object object2 = ClientCacheRequestor.this.lock;
                synchronized (object2) {
                    if (ClientCacheRequestor.this.frames.isEmpty() && ClientCacheRequestor.this.framesWithDirectInstances.isEmpty()) {
                        this.status = ThreadStatus.SHUTDOWN;
                        return;
                    }
                    if (!ClientCacheRequestor.this.frames.isEmpty()) {
                        object = ClientCacheRequestor.this.frames;
                        ClientCacheRequestor.this.frames = new HashSet();
                    }
                    if (!ClientCacheRequestor.this.framesWithDirectInstances.isEmpty()) {
                        set = ClientCacheRequestor.this.framesWithDirectInstances;
                        ClientCacheRequestor.this.framesWithDirectInstances = new HashSet();
                    }
                }
                try {
                    if (ClientCacheRequestor.this.log.isLoggable(Level.FINE)) {
                        ClientCacheRequestor.this.log.fine("Sending frames " + object + " / " + set);
                    }
                    if (object != null) {
                        ClientCacheRequestor.this.delegate.requestValueCache((Set<Frame>)object, true, ClientCacheRequestor.this.session);
                    }
                    if (set == null) continue;
                    ClientCacheRequestor.this.delegate.requestValueCache(set, false, ClientCacheRequestor.this.session);
                    continue;
                }
                catch (Exception exception) {
                    Log.emptyCatchBlock(exception);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadStatus getStatus() {
            Object object = ClientCacheRequestor.this.lock;
            synchronized (object) {
                return this.status;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThreadStatus {
        IDLE,
        RUNNING,
        SHUTDOWN;

    }
}

