/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.job;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.storage.database.ValueCachingNarrowFrameStore;
import edu.stanford.smi.protege.util.ProtegeJob;

public class CacheControlJob
extends ProtegeJob {
    private boolean disableFrameCalculator;
    private boolean disableDatabaseCache;

    public CacheControlJob(KnowledgeBase knowledgeBase, boolean bl, boolean bl2) {
        super(knowledgeBase);
        this.disableFrameCalculator = bl;
        this.disableDatabaseCache = bl2;
    }

    public static void setCacheStatus(KnowledgeBase knowledgeBase, boolean bl, boolean bl2) {
        new CacheControlJob(knowledgeBase, bl, bl2).execute();
    }

    public Object run() throws ProtegeException {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get(this.getKnowledgeBase());
        Object serverProject = mergingNarrowFrameStore.getAllFrameStores().iterator();
        block0: while (serverProject.hasNext()) {
            NarrowFrameStore object;
            for (NarrowFrameStore narrowFrameStore = object = serverProject.next(); narrowFrameStore != null; narrowFrameStore = narrowFrameStore.getDelegate()) {
                if (!(narrowFrameStore instanceof ValueCachingNarrowFrameStore)) continue;
                ValueCachingNarrowFrameStore valueCachingNarrowFrameStore = (ValueCachingNarrowFrameStore)narrowFrameStore;
                if (this.disableDatabaseCache) {
                    valueCachingNarrowFrameStore.addUnCachingSession(remoteSession);
                    continue block0;
                }
                valueCachingNarrowFrameStore.removeUnCachingSession(remoteSession);
                continue block0;
            }
        }
        if (this.getKnowledgeBase().getProject().isMultiUserServer()) {
            serverProject = Server.getInstance().getServerProject(this.getKnowledgeBase().getProject());
            FrameCalculator frameCalculator = ((ServerFrameStore)((ServerProject)serverProject).getDomainKbFrameStore(remoteSession)).getFrameCalculator();
            frameCalculator.setDisabled(this.disableFrameCalculator, remoteSession);
        }
        return true;
    }
}

