/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ListFinder;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protege.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;

public class BrowserTextListFinder
extends ListFinder {
    private static final long serialVersionUID = 3317904008378472274L;

    public BrowserTextListFinder(JList jList, ResourceKey resourceKey) {
        super(jList, resourceKey);
    }

    protected List getMatches(String string, int n) {
        if (!string.endsWith("*")) {
            string = string + "*";
        }
        SimpleStringMatcher simpleStringMatcher = new SimpleStringMatcher(string);
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        ListModel listModel = this._list.getModel();
        int n2 = listModel.getSize();
        for (int i = 0; i < n2; ++i) {
            FrameWithBrowserText frameWithBrowserText = (FrameWithBrowserText)listModel.getElementAt(i);
            String string2 = frameWithBrowserText.getBrowserText();
            if (string2 == null || !simpleStringMatcher.isMatch(string2 = string2.toLowerCase()) && !simpleStringMatcher.isMatch(StringUtilities.unquote(string2))) continue;
            arrayList.add(frameWithBrowserText.getFrame());
        }
        return arrayList;
    }

    protected void select(Object object) {
        if (object instanceof Frame) {
            this._list.setSelectedValue(new FrameWithBrowserText((Frame)object), true);
        } else if (object instanceof FrameWithBrowserText) {
            int n = ((SimpleListModel)this._list.getModel()).indexOf(object);
            if (n >= 0) {
                this._list.setSelectedIndex(n);
            }
        } else {
            this._list.setSelectedIndex(0);
        }
    }
}

