/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ClsTreeFinder;
import edu.stanford.smi.protege.ui.ClsesTreeDragSourceListener;
import edu.stanford.smi.protege.ui.ClsesTreeTarget;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.SuperclassTraverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class SubclassPane
extends SelectableContainer {
    private KnowledgeBase _knowledgeBase;
    private Action _createClsAction;
    private Action _deleteClsAction;
    private static final int MAX_EXPANSIONS = 1000;

    public SubclassPane(Action action, Cls cls, Action action2, Action action3) {
        this._knowledgeBase = cls.getKnowledgeBase();
        this._createClsAction = action2;
        this._deleteClsAction = action3;
        SelectableTree selectableTree = this.createSelectableTree(action, cls);
        selectableTree.setLargeModel(true);
        selectableTree.setSelectionRow(0);
        selectableTree.setAutoscrolls(true);
        this.setSelectable(selectableTree);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = ComponentFactory.createScrollPane(selectableTree);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)new ClsTreeFinder(this._knowledgeBase, selectableTree), "South");
        this.setupDragAndDrop();
        this.getTree().setCellRenderer(FrameRenderer.createInstance());
        this.getTree().addMouseListener(new TreePopupMenuMouseListener(selectableTree){

            public JPopupMenu getPopupMenu() {
                return SubclassPane.this.getPopupMenu();
            }
        });
    }

    protected SelectableTree createSelectableTree(Action action, Cls cls) {
        return ComponentFactory.createSelectableTree(action, new ParentChildRoot(cls));
    }

    private Action createCollapseAllAction() {
        return new StandardAction(ResourceKey.CLASS_BROWSER_COLLAPSE_TREE_MENU_ITEM){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentUtilities.fullSelectionCollapse(SubclassPane.this.getTree());
            }
        };
    }

    private Action createExpandAllAction() {
        return new StandardAction(ResourceKey.CLASS_BROWSER_EXPAND_TREE_MENU_ITEM){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentUtilities.fullSelectionExpand(SubclassPane.this.getTree(), 1000);
            }
        };
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = null;
        if (!this.getSelection().isEmpty()) {
            jPopupMenu = new JPopupMenu();
            SubclassPane.add(jPopupMenu, this._createClsAction);
            SubclassPane.add(jPopupMenu, this.getCreateClsWithMetaClsAction());
            SubclassPane.add(jPopupMenu, this._deleteClsAction);
            SubclassPane.addSeparator(jPopupMenu);
            SubclassPane.add(jPopupMenu, this.getChangeMetaclassAction());
            SubclassPane.add(jPopupMenu, this.getChangeSubclassMetaclassAction());
            SubclassPane.addSeparator(jPopupMenu);
            SubclassPane.add(jPopupMenu, this.getHideClsAction());
            SubclassPane.addSeparator(jPopupMenu);
            SubclassPane.add(jPopupMenu, this.createSetClsMetaClsAction());
            SubclassPane.add(jPopupMenu, this.createSetSlotMetaClsAction());
            SubclassPane.addSeparator(jPopupMenu);
            SubclassPane.add(jPopupMenu, this.createExpandAllAction());
            SubclassPane.add(jPopupMenu, this.createCollapseAllAction());
        }
        return jPopupMenu;
    }

    private static void add(JPopupMenu jPopupMenu, Action action) {
        jPopupMenu.add(action);
    }

    private static void addSeparator(JPopupMenu jPopupMenu) {
        int n = jPopupMenu.getComponentCount();
        Component component = jPopupMenu.getComponent(n - 1);
        if (!(component instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }

    private Action createSetClsMetaClsAction() {
        final Cls cls = (Cls)this.getSoleSelection();
        StandardAction standardAction = new StandardAction(ResourceKey.CLASS_BROWSER_SET_AS_DEFAULT_METACLASS_MENU_ITEM){

            public void actionPerformed(ActionEvent actionEvent) {
                SubclassPane.this._knowledgeBase.setDefaultClsMetaCls(cls);
                SubclassPane.this.repaint();
            }
        };
        boolean bl = cls != null && cls.isClsMetaCls() && !cls.isDefaultClsMetaCls() && cls.isConcrete();
        standardAction.setEnabled(bl);
        return standardAction;
    }

    private Action createSetSlotMetaClsAction() {
        final Cls cls = (Cls)this.getSoleSelection();
        final boolean bl = cls != null && cls.isDefaultSlotMetaCls();
        ResourceKey resourceKey = bl ? ResourceKey.CLASS_BROWSER_UNSET_AS_DEFAULT_METASLOT_MENU_ITEM : ResourceKey.CLASS_BROWSER_SET_AS_DEFAULT_METASLOT_MENU_ITEM;
        StandardAction standardAction = new StandardAction(resourceKey){

            public void actionPerformed(ActionEvent actionEvent) {
                SubclassPane.this._knowledgeBase.setDefaultSlotMetaCls(bl ? null : cls);
                SubclassPane.this.repaint();
            }
        };
        boolean bl2 = bl || cls != null && cls.isSlotMetaCls() && cls.isConcrete();
        standardAction.setEnabled(bl2);
        return standardAction;
    }

    public void extendSelection(Cls cls) {
        ComponentUtilities.extendSelection(this.getTree(), cls);
    }

    private Action getChangeMetaclassAction() {
        StandardAction standardAction = new StandardAction(ResourceKey.CLASS_BROWSER_CHANGE_METACLASS_MENU_ITEM){

            public void actionPerformed(ActionEvent actionEvent) {
                Collection<Cls> collection = CollectionUtilities.createCollection(SubclassPane.this._knowledgeBase.getRootClsMetaCls());
                Cls cls = SubclassPane.this.pickConcreteCls(collection, "Select Concrete Metaclass");
                if (cls != null) {
                    for (Cls cls2 : SubclassPane.this.getSelection()) {
                        if (cls.equals(cls2.getDirectType())) continue;
                        cls2.setDirectType(cls);
                    }
                }
            }
        };
        standardAction.setEnabled(this.canChangeMetaCls());
        return standardAction;
    }

    private boolean canChangeMetaCls() {
        Cls cls = this._knowledgeBase.getRootClsMetaCls();
        Collection<Cls> collection = CollectionUtilities.createCollection(cls);
        boolean bl = DisplayUtilities.hasMultipleConcreteClses(this._knowledgeBase, collection);
        return bl && this.selectionIsEditable();
    }

    private boolean selectionIsEditable() {
        boolean bl = true;
        Iterator iterator = this.getSelection().iterator();
        while (iterator.hasNext() && bl) {
            Frame frame = (Frame)iterator.next();
            bl = frame.isEditable();
        }
        return bl;
    }

    protected Cls pickConcreteCls(Collection collection, String string) {
        return DisplayUtilities.pickConcreteCls(this, this._knowledgeBase, collection, string);
    }

    private Action getChangeSubclassMetaclassAction() {
        Cls cls = this._knowledgeBase.getRootClsMetaCls();
        Collection<Cls> collection = CollectionUtilities.createCollection(cls);
        boolean bl = DisplayUtilities.hasMultipleConcreteClses(this._knowledgeBase, collection);
        final Cls cls2 = (Cls)this.getSoleSelection();
        StandardAction standardAction = new StandardAction(ResourceKey.CLASS_BROWSER_CHANGE_METACLASS_OF_SUBCLASSES_MENU_ITEM){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Cls cls = cls2.getDirectType();
                String string = "Change metaclass of all subclasses of ";
                string = string + cls2.getName();
                int n = ModalDialog.showMessageDialog((Component)SubclassPane.this, string = string + " to " + cls.getName(), 11);
                if (n == 1) {
                    WaitCursor waitCursor = new WaitCursor(SubclassPane.this);
                    try {
                        cls2.setDirectTypeOfSubclasses(cls);
                    }
                    finally {
                        waitCursor.hide();
                    }
                }
            }
        };
        boolean bl2 = cls2 != null && bl && cls2.getDirectSubclassCount() >= 1;
        standardAction.setEnabled(bl2);
        return standardAction;
    }

    private Action getCreateClsWithMetaClsAction() {
        StandardAction standardAction = new StandardAction(ResourceKey.CLASS_BROWSER_CREATE_SUBCLASS_USING_METACLASS_MENU_ITEM){

            public void actionPerformed(ActionEvent actionEvent) {
                Cls cls = SubclassPane.this._knowledgeBase.getRootClsMetaCls();
                Collection<Cls> collection = CollectionUtilities.createCollection(cls);
                Cls cls2 = SubclassPane.this.pickConcreteCls(collection, "Select Metaclass");
                Collection collection2 = SubclassPane.this.getSelection();
                if (cls2 != null && !collection2.isEmpty()) {
                    Cls cls3 = SubclassPane.this._knowledgeBase.createCls(null, collection2, cls2);
                    SubclassPane.this.extendSelection(cls3);
                }
            }
        };
        boolean bl = this.hasMultipleConcreteClsMetaClses();
        standardAction.setEnabled(bl);
        return standardAction;
    }

    public Cls getDisplayParent() {
        TreePath treePath = this.getTree().getSelectionModel().getLeadSelectionPath().getParentPath();
        LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath.getLastPathComponent();
        Object object = lazyTreeNode.getUserObject();
        return object instanceof Cls ? (Cls)object : null;
    }

    public JComponent getDropComponent() {
        return this.getTree();
    }

    private Action getHideClsAction() {
        final Cls cls = (Cls)this.getSoleSelection();
        final boolean bl = cls == null || cls.isVisible();
        ResourceKey resourceKey = bl ? ResourceKey.CLASS_BROWSER_HIDE_CLASS_MENU_ITEM : ResourceKey.CLASS_BROWSER_UNHIDE_CLASS_MENU_ITEM;
        return new StandardAction(resourceKey){

            public void actionPerformed(ActionEvent actionEvent) {
                cls.setVisible(!bl);
                SubclassPane.this.repaint();
            }
        };
    }

    private JPopupMenu getPopupMenu() {
        return this.createPopupMenu();
    }

    private JTree getTree() {
        return (JTree)((Object)this.getSelectable());
    }

    private boolean hasMultipleConcreteClsMetaClses() {
        Cls cls = this._knowledgeBase.getCls(":STANDARD-CLASS");
        return cls.getDirectSubclassCount() > 0;
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection(this.getTree());
    }

    public void setExpandedCls(Cls cls, boolean bl) {
        List<Cls> list = ModelUtilities.getPathToRoot(cls);
        ComponentUtilities.setExpanded(this.getTree(), list, bl);
    }

    public void setFinderComponent(JComponent jComponent) {
        this.add((Component)jComponent, "South");
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this.getTree().setCellRenderer(defaultRenderer);
    }

    public void setSelectedCls(Cls cls) {
        if (!this.getSelection().contains(cls)) {
            List<Cls> list = ModelUtilities.getPathToRoot(cls);
            ComponentUtilities.setSelectedObjectPath(this.getTree(), list);
        }
    }

    public void setSelectedClses(Collection collection) {
        ArrayList<List<Cls>> arrayList = new ArrayList<List<Cls>>();
        for (Object e : collection) {
            if (!(e instanceof Cls)) continue;
            Cls cls = (Cls)e;
            arrayList.add(ModelUtilities.getPathToRoot(cls));
        }
        ComponentUtilities.setSelectedObjectPaths(this.getTree(), arrayList);
    }

    protected void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getTree(), 3, new ClsesTreeDragSourceListener());
        new DropTarget(this.getTree(), 3, new ClsesTreeTarget());
    }

    public void setDisplayParent(Cls cls) {
        ComponentUtilities.setDisplayParent(this.getTree(), cls, new SuperclassTraverser());
    }

    public String toString() {
        return "SubclassPane";
    }

    public void dispose() {
        ((SelectableTree)this.getSelectable()).setRoot(null);
        ((SelectableTree)this.getSelectable()).setModel(null);
        this._knowledgeBase = null;
        super.dispose();
    }
}

