/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.Transaction;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.SlotHierarchyRenderer;
import edu.stanford.smi.protege.ui.SlotSubslotRoot;
import edu.stanford.smi.protege.ui.SlotsTreeDragSourceListener;
import edu.stanford.smi.protege.ui.SlotsTreeFinder;
import edu.stanford.smi.protege.ui.SlotsTreeTarget;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.DeleteAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SuperslotTraverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class SubslotPane
extends SelectableContainer {
    private Project _project;
    private KnowledgeBase _knowledgeBase;
    private Action _createSlotAction;
    private Action _createSubslotAction;
    private Action _deleteSlotAction;
    private Action _viewSlotAction;
    private LabeledComponent _labeledComponent;
    private static final int MAX_EXPANSIONS = 100;

    public SubslotPane(Project project) {
        this._project = project;
        this._knowledgeBase = this._project.getKnowledgeBase();
        this._createSlotAction = this.getCreateAction();
        this._deleteSlotAction = this.getDeleteAction();
        this._createSubslotAction = this.getCreateSubslotAction();
        this._viewSlotAction = this.getViewAction();
        LazyTreeRoot lazyTreeRoot = this.createRoot(this._knowledgeBase);
        SelectableTree selectableTree = ComponentFactory.createSelectableTree(this._viewSlotAction, lazyTreeRoot);
        selectableTree.setCellRenderer(new SlotHierarchyRenderer());
        selectableTree.setShowsRootHandles(true);
        selectableTree.setSelectionRow(0);
        selectableTree.setLargeModel(true);
        this.setSelectable(selectableTree);
        this.setLayout(new BorderLayout());
        String string = LocalizedText.getText(ResourceKey.SLOT_BROWSER_HIERARCHY_LABEL);
        this._labeledComponent = new LabeledComponent(string, ComponentFactory.createScrollPane(selectableTree));
        this._labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this.addButtons(this._labeledComponent);
        this.add((Component)this.createHeader(), "North");
        this.add((Component)this._labeledComponent, "Center");
        this.add((Component)new SlotsTreeFinder(this._knowledgeBase, selectableTree), "South");
        selectableTree.addMouseListener(new TreePopupMenuMouseListener(selectableTree){

            public JPopupMenu getPopupMenu() {
                return SubslotPane.this.getPopupMenu();
            }
        });
        this.setupDragAndDrop();
        this._viewSlotAction.setEnabled(true);
        this._deleteSlotAction.setEnabled(true);
    }

    public LabeledComponent getLabeledComponent() {
        return this._labeledComponent;
    }

    private JComponent createHeader() {
        JLabel jLabel = ComponentFactory.createLabel(Icons.getProjectIcon());
        jLabel.setText(this._project.getName());
        String string = LocalizedText.getText(ResourceKey.SLOT_BROWSER_TITLE);
        String string2 = LocalizedText.getText(ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent headerComponent = new HeaderComponent(string, string2, jLabel);
        headerComponent.setColor(Colors.getSlotColor());
        return headerComponent;
    }

    protected LazyTreeRoot createRoot(KnowledgeBase knowledgeBase) {
        return new SlotSubslotRoot(knowledgeBase);
    }

    protected void addButtons(LabeledComponent labeledComponent) {
        labeledComponent.addHeaderButton(this._viewSlotAction);
        labeledComponent.addHeaderButton(this._createSlotAction);
        labeledComponent.addHeaderButton(this._deleteSlotAction);
    }

    protected Action createCollapseAllAction() {
        return new AbstractAction("Collapse"){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentUtilities.fullSelectionCollapse(SubslotPane.this.getTree());
            }
        };
    }

    protected Action createExpandAllAction() {
        return new AbstractAction("Expand"){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentUtilities.fullSelectionExpand(SubslotPane.this.getTree(), 100);
            }
        };
    }

    public void extendSelection(Slot slot) {
        ComponentUtilities.extendSelection(this.getTree(), slot);
    }

    protected Action getChangeSlotMetaclassAction(final Slot slot) {
        Cls cls = this._knowledgeBase.getRootSlotMetaCls();
        final Collection<Cls> collection = CollectionUtilities.createCollection(cls);
        boolean bl = DisplayUtilities.hasMultipleConcreteClses(this._knowledgeBase, collection);
        AbstractAction abstractAction = new AbstractAction("Change slot metaclass..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Cls cls = SubslotPane.this.pickConcreteCls(collection, "Select Slot Metaclass");
                if (cls != null && !cls.equals(slot.getDirectType())) {
                    slot.setDirectType(cls);
                }
            }
        };
        abstractAction.setEnabled(bl && slot.isEditable());
        return abstractAction;
    }

    protected Cls pickConcreteCls(Collection collection, String string) {
        return DisplayUtilities.pickConcreteCls(this, this._knowledgeBase, collection, string);
    }

    protected Action getChangeSubslotSlotMetaclassAction(final Slot slot) {
        Cls cls = this._knowledgeBase.getRootSlotMetaCls();
        Collection<Cls> collection = CollectionUtilities.createCollection(cls);
        boolean bl = DisplayUtilities.hasMultipleConcreteClses(this._knowledgeBase, collection);
        AbstractAction abstractAction = new AbstractAction("Change slot metaclass of subslots"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Cls cls = slot.getDirectType();
                String string = "Change slot metaclass of all subslots of ";
                string = string + slot.getName();
                int n = ModalDialog.showMessageDialog((Component)SubslotPane.this, string = string + " to " + cls.getName(), 11);
                if (n == 1) {
                    WaitCursor waitCursor = new WaitCursor(SubslotPane.this);
                    try {
                        slot.setDirectTypeOfSubslots(cls);
                    }
                    finally {
                        waitCursor.hide();
                    }
                }
            }
        };
        boolean bl2 = slot.isEditable() && bl && slot.getDirectSubslotCount() >= 1;
        abstractAction.setEnabled(bl2);
        return abstractAction;
    }

    protected Action getCreateAction() {
        return new CreateAction(ResourceKey.SLOT_CREATE){

            public void onCreate() {
                Transaction<Slot> transaction = new Transaction<Slot>(SubslotPane.this._knowledgeBase, "Create Slot (random name)"){
                    private Slot slot;

                    @Override
                    public boolean doOperations() {
                        this.slot = SubslotPane.this._knowledgeBase.createSlot(null);
                        return true;
                    }

                    @Override
                    public Slot getResult() {
                        return this.slot;
                    }
                };
                transaction.execute();
                SubslotPane.this.setSelectedSlot((Slot)transaction.getResult());
            }
        };
    }

    protected Action getCreateSlotWithSlotMetaclassAction() {
        AbstractAction abstractAction = new AbstractAction("Create subslot using slot metaclass..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Cls cls = SubslotPane.this._knowledgeBase.getRootSlotMetaCls();
                Collection<Cls> collection = CollectionUtilities.createCollection(cls);
                Cls cls2 = SubslotPane.this.pickConcreteCls(collection, "Select Slot Metaclass");
                Collection collection2 = SubslotPane.this.getSelection();
                if (cls2 != null && !collection2.isEmpty()) {
                    Slot slot = SubslotPane.this._knowledgeBase.createSlot(null, cls2, collection2, true);
                    SubslotPane.this.extendSelection(slot);
                }
            }
        };
        boolean bl = this.hasMultipleConcreteSlotMetaClses();
        abstractAction.setEnabled(bl);
        return abstractAction;
    }

    protected Action getCreateSubslotAction() {
        return new CreateAction(ResourceKey.SLOT_CREATE_SUBSLOT){

            public void onCreate() {
                Collection collection = SubslotPane.this.getSelection();
                Slot slot = (Slot)CollectionUtilities.getFirstItem(collection);
                if (slot != null) {
                    try {
                        SubslotPane.this._knowledgeBase.beginTransaction("Create subslot of " + collection);
                        Cls cls = slot.getDirectType();
                        Slot slot2 = SubslotPane.this._knowledgeBase.createSlot(null, cls, collection, true);
                        SubslotPane.this.createInverseSlot(slot2, collection);
                        SubslotPane.this._knowledgeBase.commitTransaction();
                        SubslotPane.this.extendSelection(slot2);
                    }
                    catch (Exception exception) {
                        SubslotPane.this._knowledgeBase.rollbackTransaction();
                        Log.getLogger().warning("Error at creating subslot of " + slot);
                    }
                }
            }
        };
    }

    private void createInverseSlot(Slot slot, Collection collection) {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        Cls cls = null;
        for (Slot slot2 : collection) {
            Slot slot3 = slot2.getInverseSlot();
            if (slot3 == null) continue;
            arrayList.add(slot3);
            if (cls != null) continue;
            cls = slot3.getDirectType();
        }
        if (!arrayList.isEmpty()) {
            Slot slot2;
            slot2 = this._knowledgeBase.createSlot("inverse_of_" + slot.getName(), cls, arrayList, true);
            slot.setInverseSlot(slot2);
        }
    }

    protected Action getDeleteAction() {
        return new DeleteAction(ResourceKey.SLOT_DELETE, (Selectable)this){

            public void onDelete(Collection collection) {
                SubslotPane.this.handleDelete(collection);
            }

            public void onSelectionChange() {
                Slot slot = (Slot)CollectionUtilities.getFirstItem(this.getSelection());
                if (slot != null) {
                    this.setAllowed(slot.isEditable());
                }
            }
        };
    }

    protected void handleDelete(Collection collection) {
        this.removeSelection();
        try {
            this._knowledgeBase.beginTransaction("Delete slots " + collection);
            for (Slot slot : collection) {
                this._knowledgeBase.deleteSlot(slot);
            }
            this._knowledgeBase.commitTransaction();
        }
        catch (Exception exception) {
            this._knowledgeBase.rollbackTransaction();
            Log.getLogger().warning("Error at deleting slots " + collection);
        }
    }

    public Slot getDisplayParent() {
        TreePath treePath;
        Slot slot = null;
        TreePath treePath2 = this.getTree().getSelectionModel().getLeadSelectionPath();
        if (treePath2 != null && (treePath = treePath2.getParentPath()) != null) {
            LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath.getLastPathComponent();
            Object object = lazyTreeNode.getUserObject();
            slot = object instanceof Slot ? (Slot)object : null;
        }
        return slot;
    }

    public JTree getDropComponent() {
        return this.getTree();
    }

    public List getPath(Slot slot, List list) {
        list.add(0, slot);
        Slot slot2 = (Slot)CollectionUtilities.getFirstItem(slot.getDirectSuperslots());
        if (slot2 != null) {
            this.getPath(slot2, list);
        }
        return list;
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = null;
        Collection collection = this.getSelection();
        if (collection.size() == 1) {
            Slot slot = (Slot)CollectionUtilities.getFirstItem(collection);
            jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this._createSlotAction);
            jPopupMenu.add(this._createSubslotAction);
            jPopupMenu.add(this.getCreateSlotWithSlotMetaclassAction());
            jPopupMenu.add(this._deleteSlotAction);
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.getChangeSlotMetaclassAction(slot));
            jPopupMenu.add(this.getChangeSubslotSlotMetaclassAction(slot));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.createExpandAllAction());
            jPopupMenu.add(this.createCollapseAllAction());
        }
        return jPopupMenu;
    }

    private JTree getTree() {
        return (JTree)((Object)this.getSelectable());
    }

    protected Action getViewAction() {
        return new ViewAction(ResourceKey.SLOT_VIEW, (Selectable)this){

            public void onView(Object object) {
                SubslotPane.this._project.show((Slot)object);
            }
        };
    }

    private boolean hasMultipleConcreteSlotMetaClses() {
        int n = 0;
        Collection collection = this._knowledgeBase.getRootSlotMetaCls().getSubclasses();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && n < 2) {
            Cls cls = (Cls)iterator.next();
            if (!cls.isConcrete()) continue;
            ++n;
        }
        return n > 1;
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection(this.getTree());
    }

    public void setExpandedSlot(Slot slot, boolean bl) {
        ComponentUtilities.setExpanded(this.getTree(), this.getPath(slot, new LinkedList()), bl);
    }

    public void setFinderComponent(JComponent jComponent) {
        this.add((Component)jComponent, "South");
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this.getTree().setCellRenderer(defaultRenderer);
    }

    public void setSelectedSlot(Slot slot) {
        if (!this.getSelection().contains(slot)) {
            ComponentUtilities.setSelectedObjectPath(this.getTree(), this.getPath(slot, new LinkedList()));
        }
    }

    private void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getTree(), 3, new SlotsTreeDragSourceListener());
        new DropTarget(this.getTree(), 3, new SlotsTreeTarget());
    }

    public void setDisplayParent(Slot slot) {
        ComponentUtilities.setDisplayParent(this.getTree(), slot, new SuperslotTraverser());
    }

    public String toString() {
        return "SubclassPane";
    }

    public void dispose() {
        super.dispose();
        this._project = null;
        this._knowledgeBase = null;
    }
}

