/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.metaproject.Group;
import edu.stanford.smi.protege.server.metaproject.GroupOperation;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.PropertyValue;
import edu.stanford.smi.protege.server.metaproject.ServerInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.GroupImpl;
import edu.stanford.smi.protege.server.metaproject.impl.GroupOperationImpl;
import edu.stanford.smi.protege.server.metaproject.impl.OperationImpl;
import edu.stanford.smi.protege.server.metaproject.impl.PolicyControlledObjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.PolicyImpl;
import edu.stanford.smi.protege.server.metaproject.impl.ProjectInstanceImpl;
import edu.stanford.smi.protege.server.metaproject.impl.PropertyValueImpl;
import edu.stanford.smi.protege.server.metaproject.impl.ServerInstanceImpl;
import edu.stanford.smi.protege.server.metaproject.impl.UserImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceImpl;
import edu.stanford.smi.protege.util.Log;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaProjectImpl
implements MetaProject,
Localizable,
Serializable {
    private static final long serialVersionUID = -7866511885264147967L;
    private transient KnowledgeBase kb;
    private transient Policy policy;

    public MetaProjectImpl(URI uRI) {
        this(uRI, false);
    }

    public MetaProjectImpl(URI uRI, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Project project = Project.loadProjectFromURI(uRI, arrayList, bl);
        if (!arrayList.isEmpty()) {
            throw new RuntimeException(arrayList.iterator().next().toString());
        }
        this.kb = project.getKnowledgeBase();
    }

    public MetaProjectImpl(Project project) {
        this.kb = project.getKnowledgeBase();
    }

    public Cls getCls(ClsEnum clsEnum) throws OntologyException {
        Cls cls = this.kb.getCls(clsEnum.toString());
        if (cls == null) {
            throw new OntologyException("Metaproject Ontology should contain a class " + (Object)((Object)clsEnum));
        }
        return cls;
    }

    public Slot getSlot(SlotEnum slotEnum) throws OntologyException {
        Slot slot = this.kb.getSlot(slotEnum.toString());
        if (slot == null) {
            throw new OntologyException("Metaproject Ontology should contain a slot " + (Object)((Object)slotEnum));
        }
        return slot;
    }

    protected WrappedProtegeInstanceImpl wrapInstance(ClsEnum clsEnum, Instance instance) {
        if (!instance.hasType(this.getCls(clsEnum))) {
            throw new IllegalArgumentException("" + instance + " should be a " + (Object)((Object)clsEnum) + " instance");
        }
        switch (clsEnum) {
            case GroupOperation: {
                return new GroupOperationImpl(this, instance);
            }
            case Group: {
                return new GroupImpl(this, instance);
            }
            case Project: {
                return new ProjectInstanceImpl(this, instance);
            }
            case Operation: {
                return new OperationImpl(this, instance);
            }
            case User: {
                return new UserImpl(this, instance);
            }
            case Server: {
                return new ServerInstanceImpl(this, instance);
            }
            case PolicyControlledObject: {
                return new PolicyControlledObjectImpl(this, instance);
            }
            case PropertyValue: {
                return new PropertyValueImpl(this, instance);
            }
        }
        throw new UnsupportedOperationException("Unexpected cls " + (Object)((Object)clsEnum));
    }

    protected Set getWrappedInstances(ClsEnum clsEnum) {
        HashSet<WrappedProtegeInstanceImpl> hashSet = new HashSet<WrappedProtegeInstanceImpl>();
        for (Instance instance : this.kb.getInstances(this.getCls(clsEnum))) {
            hashSet.add(this.wrapInstance(clsEnum, instance));
        }
        return hashSet;
    }

    @Override
    public Set<ProjectInstance> getProjects() {
        return this.getWrappedInstances(ClsEnum.Project);
    }

    @Override
    public ProjectInstance getProject(String string) {
        Collection collection = this.kb.getFramesWithValue(this.getSlot(SlotEnum.name), null, false, string);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Frame frame = (Frame)collection.iterator().next();
        if (!(frame instanceof Frame)) {
            return null;
        }
        return new ProjectInstanceImpl(this, (Instance)frame);
    }

    @Override
    public Set<User> getUsers() {
        return this.getWrappedInstances(ClsEnum.User);
    }

    @Override
    public User getUser(String string) {
        Collection collection = this.kb.getFramesWithValue(this.getSlot(SlotEnum.name), null, false, string);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Frame frame = (Frame)collection.iterator().next();
        if (!(frame instanceof Frame)) {
            return null;
        }
        return new UserImpl(this, (Instance)frame);
    }

    @Override
    public Operation getOperation(String string) {
        Collection collection = this.kb.getFramesWithValue(this.getSlot(SlotEnum.name), null, false, string);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Frame frame = (Frame)collection.iterator().next();
        if (!(frame instanceof Frame)) {
            return null;
        }
        return new OperationImpl(this, (Instance)frame);
    }

    @Override
    public Set<Operation> getOperations() {
        return this.getWrappedInstances(ClsEnum.Operation);
    }

    @Override
    public Group getGroup(String string) {
        Collection collection = this.kb.getFramesWithValue(this.getSlot(SlotEnum.name), null, false, string);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Frame frame = (Frame)collection.iterator().next();
        if (!(frame instanceof Frame)) {
            return null;
        }
        return new GroupImpl(this, (Instance)frame);
    }

    @Override
    public Set<Group> getGroups() {
        return this.getWrappedInstances(ClsEnum.Group);
    }

    @Override
    public Set<GroupOperation> getGroupOperations() {
        return this.getWrappedInstances(ClsEnum.GroupOperation);
    }

    @Override
    public Set<ServerInstance> getServers() {
        return this.getWrappedInstances(ClsEnum.Server);
    }

    @Override
    public Policy getPolicy() {
        if (this.policy == null) {
            this.policy = new PolicyImpl(this);
        }
        return this.policy;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.kb;
    }

    @Override
    public boolean save(Collection collection) {
        ArrayList arrayList = new ArrayList();
        try {
            this.kb.getProject().save(arrayList);
            if (arrayList.size() > 0) {
                Log.getLogger().warning("Server: Errors at saving metaproject. Error messages: " + arrayList);
                collection.addAll(arrayList);
                return false;
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Server: Errors at saving metaproject. Error message: " + exception.getMessage(), exception);
            collection.add(exception);
            return false;
        }
        if (Log.getLogger().isLoggable(Level.FINE)) {
            Log.getLogger().fine("SERVER: Saved metaproject.");
        }
        return true;
    }

    @Override
    public void dispose() {
        this.kb.getProject().dispose();
    }

    @Override
    public ProjectInstance createProject(String string) {
        Instance instance = this.kb.createInstance(string, this.getCls(ClsEnum.Project));
        ProjectInstanceImpl projectInstanceImpl = new ProjectInstanceImpl(this, instance);
        projectInstanceImpl.setName(string);
        return projectInstanceImpl;
    }

    @Override
    public User createUser(String string, String string2) {
        Instance instance = this.kb.createInstance(null, this.getCls(ClsEnum.User));
        UserImpl userImpl = new UserImpl(this, instance);
        userImpl.setName(string);
        userImpl.setPassword(string2);
        return userImpl;
    }

    @Override
    public Group createGroup(String string) {
        Instance instance = this.kb.createInstance(string, this.getCls(ClsEnum.Group));
        GroupImpl groupImpl = new GroupImpl(this, instance);
        groupImpl.setName(string);
        return groupImpl;
    }

    @Override
    public Operation createOperation(String string) {
        Instance instance = this.kb.createInstance(string, this.getCls(ClsEnum.Operation));
        OperationImpl operationImpl = new OperationImpl(this, instance);
        operationImpl.setName(string);
        return operationImpl;
    }

    @Override
    public GroupOperation createGroupOperation() {
        Instance instance = this.kb.createInstance(null, this.getCls(ClsEnum.GroupOperation));
        GroupOperationImpl groupOperationImpl = new GroupOperationImpl(this, instance);
        return groupOperationImpl;
    }

    @Override
    public PropertyValue createPropertyValue() {
        Instance instance = this.kb.createInstance(null, this.getCls(ClsEnum.PropertyValue));
        PropertyValueImpl propertyValueImpl = new PropertyValueImpl(this, instance);
        return propertyValueImpl;
    }

    @Override
    public PropertyValue createPropertyValue(String string, String string2) {
        PropertyValue propertyValue = this.createPropertyValue();
        propertyValue.setPropertyName(string);
        propertyValue.setPropertyValue(string2);
        return propertyValue;
    }

    @Override
    public Collection<PropertyValue> getPropertyValues(String string, String string2) {
        Collection collection = this.kb.getFramesWithValue(this.getSlot(SlotEnum.propertyName), null, false, string);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        Slot slot = this.getSlot(SlotEnum.propertyValue);
        Cls cls = this.getCls(ClsEnum.PropertyValue);
        for (Frame frame : collection) {
            Object object;
            if (!((Instance)frame).hasType(cls) || ((object = frame.getOwnSlotValue(slot)) != null || string2 != null) && (string2 == null || !string2.equals(object))) continue;
            arrayList.add(new PropertyValueImpl(this, (Instance)frame));
        }
        return arrayList;
    }

    @Override
    public ServerInstance createServer(String string) {
        Instance instance = this.kb.createInstance(null, this.getCls(ClsEnum.Server));
        ServerInstanceImpl serverInstanceImpl = new ServerInstanceImpl(this, instance);
        serverInstanceImpl.setName(string);
        return serverInstanceImpl;
    }

    @Override
    public void localize(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
        this.policy = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SlotEnum {
        name,
        password,
        salt,
        location,
        email,
        lastLogin,
        lastAccess,
        group,
        member,
        allowedGroup,
        allowedOperation,
        allowedGroupOperation,
        owner,
        description,
        annotationProject,
        hostName,
        properties,
        propertyName,
        propertyValue,
        server;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClsEnum {
        Project,
        User,
        Group,
        Operation,
        GroupOperation,
        PolicyControlledObject,
        Server,
        PropertyValue;

    }
}

