/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ArchiveManager;
import edu.stanford.smi.protege.util.ArchiveRecord;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialogCloseDoubleClickAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

class RevertProjectPanel
extends JPanel {
    private static final long serialVersionUID = 8202074349453422106L;
    private static boolean _lastArchiveCurrentValue;
    private Project _currentProject;
    private JCheckBox _archiveCurrentCheckBox;
    private JTable _table;

    RevertProjectPanel(Project project) {
        super(new BorderLayout());
        this._currentProject = project;
        this.add((Component)this.createVersionsTable(), "Center");
        this.add((Component)this.createOptionsPanel(), "South");
    }

    private JComponent createVersionsTable() {
        this._table = ComponentFactory.createTable(null);
        this._table.setAutoCreateColumnsFromModel(true);
        this._table.setModel(this.createTableModel());
        this._table.addMouseListener(new ModalDialogCloseDoubleClickAdapter());
        int n = this._table.getRowCount() - 1;
        if (n >= 0) {
            this._table.setRowSelectionInterval(n, n);
        }
        return new LabeledComponent("Archived Versions", ComponentFactory.createScrollPane(this._table));
    }

    private JComponent createOptionsPanel() {
        this._archiveCurrentCheckBox = new JCheckBox("Archive current version before revert");
        this._archiveCurrentCheckBox.setSelected(_lastArchiveCurrentValue);
        return this._archiveCurrentCheckBox;
    }

    public Date getSelectedTimestamp() {
        Date date = null;
        int n = this._table.getSelectedRow();
        if (n != -1) {
            date = (Date)this._table.getValueAt(n, 0);
        }
        return date;
    }

    public boolean getArchiveCurrentVersion() {
        _lastArchiveCurrentValue = this._archiveCurrentCheckBox.isSelected();
        return _lastArchiveCurrentValue;
    }

    private TableModel createTableModel() {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Date and Time");
        defaultTableModel.addColumn("Comment");
        for (ArchiveRecord archiveRecord : ArchiveManager.getArchiveManager().getArchiveRecords(this._currentProject)) {
            Date date = archiveRecord.getTimestamp();
            String string = archiveRecord.getComment();
            defaultTableModel.addRow(new Object[]{date, string});
        }
        return defaultTableModel;
    }
}

