/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JTextField;

class URLPanel
extends JPanel
implements Validatable {
    private static final long serialVersionUID = -3336694646619661586L;
    private JTextField field = ComponentFactory.createTextField();

    URLPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)new LabeledComponent("URL", this.field), "North");
        this.setName("URL");
    }

    public boolean validateContents() {
        boolean bl = false;
        try {
            String string = this.field.getText();
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            inputStream.close();
            if (string.endsWith(".pprj")) {
                bl = true;
            } else {
                ModalDialog.showMessageDialog(this, "Can only open Protege project (.pprj) files");
            }
        }
        catch (Exception exception) {
            ModalDialog.showMessageDialog(this, "Unreachable URL");
        }
        return bl;
    }

    public void saveContents() {
    }

    public URI getURI() {
        String string = this.field.getText();
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uRI;
    }
}

